/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.builders_delight;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;

public class BuildersDelightModule
extends SimpleModule {
    public BuildersDelightModule(String modId) {
        super(modId, "bdl");
        ResourceLocation tabDeco = this.modRes("decoration");
        ResourceLocation tabBlock = this.modRes("blocks");
        ResourceLocation tabMater = this.modRes("materials");
    }

    public void craftingWithTagsRecipe(String baseName, String input, Item output, WoodType wood, ResourceSink sink, ResourceManager manager) {
        String pathBuilder = this.shortenedId() + "/" + wood.getVariantId(baseName, false);
        ResourceLocation recipeLoc = this.modRes("recipes/oak_" + baseName + ".json");
        try (InputStream recipeStream = ((Resource)manager.getResource(recipeLoc).orElseThrow()).open();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            String inputTag = "everycomp:" + wood.getTypeName() + "_" + input;
            JsonObject underKey = baseName.equals("glass_1") ? recipe.getAsJsonObject("key").getAsJsonObject("1") : recipe.getAsJsonObject("key").getAsJsonObject("0");
            JsonObject underResult = recipe.getAsJsonObject("result");
            underKey.addProperty("tag", inputTag);
            underResult.addProperty("item", Utils.getID((Item)output).toString());
            sink.addJson(EveryCompat.res(pathBuilder), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException ex) {
            EveryCompat.LOGGER.error("{BuildersDelight Module} TagsRecipe(): ", (Throwable)ex);
        }
    }

    private static void addChiselRecipe(ResourceSink sink, WoodType w, String name, AbstractSimpleEntrySet<?, ?, ?> ... entries) {
        JsonArray arr = new JsonArray();
        for (AbstractSimpleEntrySet<?, ?, ?> e : entries) {
            Item o = (Item)e.items.get(w);
            if (o == null) continue;
            arr.add(Utils.getID((Item)o).toString());
        }
        Object vanilla = w.getChild(name);
        if (vanilla != null) {
            arr.add(Utils.getID((Object)vanilla).toString());
        }
        if (!arr.isEmpty()) {
            JsonObject jo = new JsonObject();
            ResourceLocation res = EveryCompat.res("chisel/" + w.getVariantId(name) + ".json");
            jo.add("variants", (JsonElement)arr);
            sink.addJson(res, (JsonElement)jo, ResType.GENERIC);
        }
    }
}

