/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.unusual_furniture.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.every_compat.modules.neoforge.unusual_furniture.UnusualFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.neoforge.unusual_furniture.compat_entity.CompatDrawerBlockEntity;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.toopa.unusualfurniture.block.JungleDrawerBlock;
import net.toopa.unusualfurniture.client.model.Modeljavadrawer;
import net.toopa.unusualfurniture.client.model.animations.javadrawerAnimation;
import net.toopa.unusualfurniture.procedures.OakDrawerClosePlaybackConditionProcedure;
import net.toopa.unusualfurniture.procedures.OakDrawerOpenPlaybackConditionProcedure;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CompatDrawerRenderer
implements BlockEntityRenderer<CompatDrawerBlockEntity> {
    private final CustomHierarchicalModel model;

    public CompatDrawerRenderer(BlockEntityRendererProvider.Context context, WoodType woodType, String shortenedId) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modeljavadrawer.LAYER_LOCATION));
    }

    private void updateRenderState(CompatDrawerBlockEntity blockEntity) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        blockEntity.animationState0.animateWhen(OakDrawerOpenPlaybackConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), (double)blockEntity.getBlockPos().getX(), (double)blockEntity.getBlockPos().getY(), (double)blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState1.animateWhen(OakDrawerClosePlaybackConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), (double)blockEntity.getBlockPos().getX(), (double)blockEntity.getBlockPos().getY(), (double)blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(@NotNull CompatDrawerBlockEntity blockEntity, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity);
        ResourceLocation textureLocation = UnusualFurnitureModule.BLOCK_TO_TEXTURE_MAP.get(blockEntity.getBlockState().getBlock());
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)JungleDrawerBlock.FACING);
        switch (facing) {
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)textureLocation));
        this.model.setupBlockEntityAnim(blockEntity, (float)blockEntity.getLevel().getGameTime() + partialTick);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    private static final class CustomHierarchicalModel
    extends Modeljavadrawer {
        private final ModelPart root;
        private final BlockEntityHierarchicalModel animator = new BlockEntityHierarchicalModel();

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupBlockEntityAnim(CompatDrawerBlockEntity blockEntity, float ageInTicks) {
            this.animator.setupBlockEntityAnim(blockEntity, ageInTicks);
            super.setupAnim(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        }

        public ModelPart getRoot() {
            return this.root;
        }

        private class BlockEntityHierarchicalModel
        extends HierarchicalModel<Entity> {
            private BlockEntityHierarchicalModel() {
            }

            @NotNull
            public ModelPart root() {
                return CustomHierarchicalModel.this.root;
            }

            public void setupAnim(@NotNull Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            }

            public void setupBlockEntityAnim(CompatDrawerBlockEntity blockEntity, float ageInTicks) {
                CustomHierarchicalModel.this.animator.root().getAllParts().forEach(ModelPart::resetPose);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState0, javadrawerAnimation.Open, ageInTicks, 1.0f);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState1, javadrawerAnimation.Close, ageInTicks, 1.0f);
            }
        }
    }
}

