/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.quark;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.ECPlatformStuff;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.UtilityTag;
import net.mehvahdjukaar.every_compat.modules.botanypots.BotanyPotsHelper;
import net.mehvahdjukaar.every_compat.modules.quark.QuarkSimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.violetmoon.quark.content.building.block.HedgeBlock;
import org.violetmoon.quark.content.building.block.HollowLogBlock;
import org.violetmoon.quark.content.building.block.LeafCarpetBlock;
import org.violetmoon.quark.content.building.block.VariantBookshelfBlock;
import org.violetmoon.quark.content.building.block.VariantLadderBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.quark.content.building.block.WoodPostBlock;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.building.module.LeafCarpetModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.building.module.VariantLaddersModule;
import org.violetmoon.quark.content.building.module.VerticalPlanksModule;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.building.module.WoodenPostsModule;
import org.violetmoon.zeta.block.ZetaBlock;

public class QuarkModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> verticalSlabs;
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> verticalPlanks;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> hollowLogs;
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> hedges;
    public final SimpleEntrySet<LeavesType, Block> leafCarpets;
    public static final PaletteStrategy bookshelfPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        PaletteColor l0 = p.getDarkest();
        p.increaseDown();
        p.increaseDown();
        p.increaseDown();
        p.increaseDown();
        p.remove(l0);
    }));

    public QuarkModule(String modId) {
        super(modId, "q", "everycomp");
        ResourceKey tab = CreativeModeTabs.BUILDING_BLOCKS;
        this.verticalSlabs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "vertical_slab", VerticalSlabsModule.class, this.getModBlock("oak_vertical_slab"), () -> VanillaWoodTypes.OAK, w -> new VerticalSlabBlock(() -> w.getBlockOfThis("slab"), Utils.copyPropertySafe((Block)Objects.requireNonNull(w.getBlockOfThis("slab"))).sound(w.getSound()))).requiresChildren(new String[]{"slab"})).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("wooden_vertical_slabs"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("vertical_slabs"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("vertical_slab"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/vertslabs/oak_vertical_slab"))).addRecipe(this.modRes("building/crafting/vertslabs/oak_vertical_slab_revert"))).addCondition(woodType -> !PlatHelper.isModLoaded((String)"v_slab_compat"))).copyParentDrop().build();
        this.addEntry(this.verticalSlabs);
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "bookshelf", VariantBookshelvesModule.class, this.getModBlock("acacia_bookshelf"), () -> VanillaWoodTypes.ACACIA, w -> new VariantBookshelfBlock(this.shortenedId() + "/" + w.getAppendableId(), null, w.canBurn(), w.getSound())).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"), bookshelfPalette)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"c:bookshelves"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/bookshelves/acacia_bookshelf"))).copyParentDrop().build();
        this.addEntry(this.bookshelves);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", WoodenPostsModule.class, this.getModBlock("oak_post"), () -> VanillaWoodTypes.OAK, w -> {
            Block fence = w.getBlockOfThis("fence");
            return new WoodPostBlock(null, Objects.requireNonNull(fence), this.shortenedId() + "/" + w.getNamespace() + "/", Objects.requireNonNull(fence).defaultBlockState().getSoundType());
        }).requiresChildren(new String[]{"fence", "wood"})).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("posts"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/posts/oak_post"))).setRenderType(RenderLayer.CUTOUT).build();
        this.addEntry(this.posts);
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", "stripped", WoodenPostsModule.class, this.getModBlock("stripped_oak_post"), () -> VanillaWoodTypes.OAK, w -> {
            if (w.getNamespace().equals("malum") || w.getNamespace().equals("twigs")) {
                return null;
            }
            Block fence = w.getBlockOfThis("fence");
            return new WoodPostBlock(null, Objects.requireNonNull(fence), this.shortenedId() + "/" + w.getNamespace() + "/stripped_", Objects.requireNonNull(fence).defaultBlockState().getSoundType());
        }).requiresChildren(new String[]{"fence", "stripped_log", "stripped_wood"})).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("posts"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/posts/stripped_oak_post"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.strippedPosts);
        this.verticalPlanks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "planks", "vertical", VerticalPlanksModule.class, this.getModBlock("vertical_oak_planks"), () -> VanillaWoodTypes.OAK, w -> {
            String name = this.shortenedId() + "/" + w.getVariantId("planks", "vertical");
            return new ZetaBlock(name, null, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        }).addCondition(w -> !w.getId().toString().equals("gardens_of_the_dead:whistle_planks"))).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.PLANKS, new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addRecipe(this.modRes("building/crafting/vertplanks/vertical_oak_planks"))).build();
        this.addEntry(this.verticalPlanks);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "ladder", VariantLaddersModule.class, this.getModBlock("spruce_ladder"), () -> VanillaWoodTypes.SPRUCE, w -> new VariantLadderBlock(this.shortenedId() + "/" + w.getAppendableId(), null, Utils.copyPropertySafe((Block)Blocks.LADDER).sound(w.getSound()), w.canBurn())).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.CLIMBABLE, Registries.BLOCK)).addTag(this.modRes("ladders"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTexture(EveryCompat.res("block/spruce_ladder"))).addRecipe(this.modRes("building/crafting/ladders/spruce_ladder"))).setRenderType(RenderLayer.TRANSLUCENT).build();
        this.addEntry(this.ladders);
        this.hollowLogs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "log", "hollow", HollowLogsModule.class, this.getModBlock("hollow_oak_log"), () -> VanillaWoodTypes.OAK, w -> new HollowLogBlock(this.shortenedId() + "/" + w.getAppendableId(), w.log, null, w.canBurn())).requiresChildren(new String[]{"stripped_log"})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("hollow_logs"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addRecipe(this.modRes("building/crafting/hollowlogs/hollow_oak_log"))).build();
        this.addEntry(this.hollowLogs);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "chest", VariantChestsModule.class, this.getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK, w -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe((Block)Blocks.CHEST))).addTile((x$0, x$1) -> new qChestBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(ResourceLocation.parse((String)"c:chests/wooden"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("revertable_chests"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/chests/oak_chest"))).addRecipe(this.modRes("building/chests/oak_chest_wood"))).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).excludeBlockTypes("twilightforest", new String[]{"dark"})).build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "chest", "trapped", VariantChestsModule.class, this.getModBlock("trapped_oak_chest"), () -> VanillaWoodTypes.OAK, w -> {
            boolean isNamespaceLoaded;
            boolean bl = isNamespaceLoaded = w.getNamespace().equals("twilightforest") || w.getNamespace().equals("blue_skies");
            if (!this.chests.blocks.containsKey(w) && !isNamespaceLoaded) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe((Block)Blocks.TRAPPED_CHEST));
        }).addTile((x$0, x$1) -> new qTrappedBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(ResourceLocation.parse((String)"forge:chests/trapped"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"forge:chests/wooden"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("revertable_trapped_chests"), Registries.ITEM)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/chests/trapped_oak_chest"))).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).build();
        this.addEntry(this.trappedChests);
        this.hedges = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "hedge", HedgesModule.class, this.getModBlock("oak_hedge"), () -> VanillaLeavesTypes.OAK, leavesType -> new HedgeBlock("", null, Blocks.OAK_FENCE, leavesType.leaves)).addCondition(l -> l.getAssociatedWoodType() != null)).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", CompatSpritesHelper.LOOKS_LIKE_LEAF_TEXTURE))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("hedges"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).copyParentTint()).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.hedges);
        this.leafCarpets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "leaf_carpet", LeafCarpetModule.class, this.getModBlock("oak_leaf_carpet"), () -> VanillaLeavesTypes.OAK, leavesType -> {
            String name = this.shortenedId() + "/" + leavesType.getVariantId("%s_leaf_carpet");
            return new LeafCarpetBlock(name, leavesType.leaves, null);
        }).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))).addTag(BlockTags.MINEABLE_WITH_HOE, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"forge:mineable/sickle"), Registries.BLOCK)).addTag(ResourceLocation.parse((String)"mynethersdelight:resurgent_soil_plant"), Registries.BLOCK)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/leafcarpet/oak_leaf_carpet"))).setRenderType(RenderLayer.CUTOUT_MIPPED).copyParentTint()).build();
        this.addEntry(this.leafCarpets);
    }

    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return this.trappedChests.getTile(CompatChestBlockEntity.class);
    }

    @Override
    public void onModSetup() {
        this.posts.blocks.forEach((w, post) -> {
            Block stripped = (Block)this.strippedPosts.blocks.get(w);
            if (stripped != null) {
                ECPlatformStuff.registerStripping(post, stripped);
            }
        });
        this.leafCarpets.blocks.forEach((w, leaf) -> ComposterBlock.COMPOSTABLES.put(leaf, 0.2f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
        CompatChestBlockRenderer.register(event, this.trappedChests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept(this::generateChestTextures);
    }

    private void generateChestTextures(ResourceManager manager, ResourceSink sink) {
        this.trappedChests.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("quark_variant_chests/oak/normal"), EveryCompat.res("model/oak_chest_normal_m"), EveryCompat.res("model/oak_chest_normal_o"), EveryCompat.res("model/trapped_chest_normal"));
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("quark_variant_chests/oak/left"), EveryCompat.res("model/oak_chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), EveryCompat.res("model/trapped_chest_left"));
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("quark_variant_chests/oak/right"), EveryCompat.res("model/oak_chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), EveryCompat.res("model/trapped_chest_right"));
        });
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            if (PlatHelper.isModLoaded((String)"botanypots")) {
                this.hedges.items.forEach((leaves, item) -> {
                    Item leavesItem = leaves.leaves.asItem();
                    BotanyPotsHelper.cropQuarkHedgeRecipe(this, item, leavesItem, sink, manager, leaves);
                });
            }
            for (Map.Entry entry : this.hedges.blocks.entrySet()) {
                LeavesType leavesType = (LeavesType)entry.getKey();
                Block block = (Block)entry.getValue();
                if (block == null) continue;
                this.generalHedgeRecipe(leavesType, block, sink, manager);
            }
        });
    }

    public void generalHedgeRecipe(LeavesType leavesType, Block hedge, ResourceSink sink, ResourceManager manager) {
        String recipe = "{\n    \"neoforge:conditions\": [\n        {\n            \"type\": \"zeta:flag\",\n            \"flag\": \"hedges\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"pattern\": [\n        \"L\",\n        \"W\"\n    ],\n    \"key\": {\n        \"L\": {\n            \"item\": \"[LEAVES]\"\n        },\n        \"W\": {\n            \"tag\": \"[TAG]\"\n        }\n    },\n    \"result\": {\n        \"id\": \"[HEDGE]\",\n        \"count\": 2\n    }\n} \n";
        WoodType woodType = leavesType.getAssociatedWoodType();
        if (Objects.nonNull(woodType)) {
            String newTag = UtilityTag.getATagOrCreateANew("log", "cap", (BlockType)woodType, sink, manager).toString();
            String newRecipe = recipe.replace("[LEAVES]", Utils.getID((Block)leavesType.leaves).toString()).replace("[TAG]", newTag).replace("[HEDGE]", Utils.getID((Block)hedge).toString());
            sink.addBytes(EveryCompat.res(leavesType.createPathWith(this.shortenedId(), "hedge")), newRecipe.getBytes(), ResType.RECIPES);
        } else {
            EveryCompat.LOGGER.error("Hedge's LeavesType do not have associated WoodType for: {}. HOW??", (Object)leavesType.getId().toString());
        }
    }

    private class qTrappedBlockEntity
    extends CompatChestBlockEntity {
        public qTrappedBlockEntity(QuarkModule quarkModule, BlockPos pos, BlockState state) {
            super(quarkModule.trappedChests.getTile(), pos, state);
        }
    }

    private class qChestBlockEntity
    extends CompatChestBlockEntity {
        public qChestBlockEntity(QuarkModule quarkModule, BlockPos pos, BlockState state) {
            super(quarkModule.chests.getTile(), pos, state);
        }
    }
}

