/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.modules.storagedrawers.ModDrawersGeometry;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public class StorageDrawersModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, BlockStandardDrawers> FULL_DRAWERS_1;
    public final SimpleEntrySet<WoodType, BlockStandardDrawers> FULL_DRAWERS_2;
    public final SimpleEntrySet<WoodType, BlockStandardDrawers> FULL_DRAWERS_4;
    public final SimpleEntrySet<WoodType, BlockStandardDrawers> HALF_DRAWERS_1;
    public final SimpleEntrySet<WoodType, BlockStandardDrawers> HALF_DRAWERS_2;
    public final SimpleEntrySet<WoodType, BlockStandardDrawers> HALF_DRAWERS_4;
    public final SimpleEntrySet<WoodType, BlockTrim> TRIMS;
    private static final PaletteStrategy drawersPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.remove(p.getLightest());
        p.increaseInner();
        p.increaseInner();
        p.increaseInner();
        p.increaseUp();
    }));
    private static final PaletteStrategy trimPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.remove(p.getLightest());
        p.increaseInner();
        p.increaseUp();
    }));

    public StorageDrawersModule(String modId) {
        super(modId, "sd", "everycomp");
        ResourceLocation tab = this.modRes("storagedrawers");
        this.FULL_DRAWERS_1 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "full_drawers_1", this.getModBlock("oak_full_drawers_1", BlockStandardDrawers.class), () -> VanillaWoodTypes.OAK, w -> {
            int drawerCount = 1;
            boolean halfDepth = false;
            IDrawerConfig config = StorageDrawersModule.getStandardConfig(drawerCount, halfDepth);
            return new BlockStandardDrawers(drawerCount, false, config, StorageDrawersModule.getWoodenDrawerBlockProperties());
        }).addCustomItem((TriFunction<WoodType, BlockStandardDrawers, Item.Properties, Item>)((TriFunction)(woodType, block, properties) -> new ItemDrawers((Block)block, properties))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("full_drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTile(this.getModTile("standard_drawers_1")).addTexture(this.modRes("block/drawers_oak_front_1"), drawersPalette)).addTexture(this.modRes("block/drawers_oak_side"), drawersPalette)).addTexture(this.modRes("block/drawers_oak_sort"), drawersPalette)).addTexture(this.modRes("block/drawers_oak_trim"), drawersPalette)).build();
        this.addEntry(this.FULL_DRAWERS_1);
        this.FULL_DRAWERS_2 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "full_drawers_2", this.getModBlock("oak_full_drawers_2", BlockStandardDrawers.class), () -> VanillaWoodTypes.OAK, w -> {
            int drawerCount = 2;
            boolean halfDepth = false;
            IDrawerConfig config = StorageDrawersModule.getStandardConfig(drawerCount, halfDepth);
            return new BlockStandardDrawers(drawerCount, halfDepth, config, StorageDrawersModule.getWoodenDrawerBlockProperties());
        }).addCustomItem((TriFunction<WoodType, BlockStandardDrawers, Item.Properties, Item>)((TriFunction)(woodType, block, properties) -> new ItemDrawers((Block)block, properties))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("full_drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTile(this.getModTile("standard_drawers_2")).addTexture(this.modRes("block/drawers_oak_front_2"), drawersPalette)).build();
        this.addEntry(this.FULL_DRAWERS_2);
        this.FULL_DRAWERS_4 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "full_drawers_4", this.getModBlock("oak_full_drawers_4", BlockStandardDrawers.class), () -> VanillaWoodTypes.OAK, w -> {
            int drawerCount = 4;
            boolean halfDepth = false;
            IDrawerConfig config = StorageDrawersModule.getStandardConfig(drawerCount, halfDepth);
            return new BlockStandardDrawers(drawerCount, halfDepth, config, StorageDrawersModule.getWoodenDrawerBlockProperties());
        }).addCustomItem((TriFunction<WoodType, BlockStandardDrawers, Item.Properties, Item>)((TriFunction)(woodType, block, properties) -> new ItemDrawers((Block)block, properties))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("full_drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTile(this.getModTile("standard_drawers_4")).addTexture(this.modRes("block/drawers_oak_front_4"), drawersPalette)).build();
        this.addEntry(this.FULL_DRAWERS_4);
        this.HALF_DRAWERS_1 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "half_drawers_1", this.getModBlock("oak_half_drawers_1", BlockStandardDrawers.class), () -> VanillaWoodTypes.OAK, w -> {
            int drawerCount = 1;
            boolean halfDepth = true;
            IDrawerConfig config = StorageDrawersModule.getStandardConfig(drawerCount, halfDepth);
            return new BlockStandardDrawers(drawerCount, halfDepth, config, StorageDrawersModule.getWoodenDrawerBlockProperties());
        }).addCustomItem((TriFunction<WoodType, BlockStandardDrawers, Item.Properties, Item>)((TriFunction)(woodType, block, properties) -> new ItemDrawers((Block)block, properties))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("half_drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTile(this.getModTile("standard_drawers_1")).addTexture(this.modRes("block/drawers_oak_side_h"), drawersPalette)).addTexture(this.modRes("block/drawers_oak_side_v"), drawersPalette)).build();
        this.addEntry(this.HALF_DRAWERS_1);
        this.HALF_DRAWERS_2 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "half_drawers_2", this.getModBlock("oak_half_drawers_2", BlockStandardDrawers.class), () -> VanillaWoodTypes.OAK, w -> {
            int drawerCount = 2;
            boolean halfDepth = true;
            IDrawerConfig config = StorageDrawersModule.getStandardConfig(drawerCount, halfDepth);
            return new BlockStandardDrawers(drawerCount, halfDepth, config, StorageDrawersModule.getWoodenDrawerBlockProperties());
        }).addCustomItem((TriFunction<WoodType, BlockStandardDrawers, Item.Properties, Item>)((TriFunction)(woodType, block, properties) -> new ItemDrawers((Block)block, properties))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("half_drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTile(this.getModTile("standard_drawers_2")).build();
        this.addEntry(this.HALF_DRAWERS_2);
        this.HALF_DRAWERS_4 = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "half_drawers_4", this.getModBlock("oak_half_drawers_4", BlockStandardDrawers.class), () -> VanillaWoodTypes.OAK, w -> {
            int drawerCount = 4;
            boolean halfDepth = true;
            IDrawerConfig config = StorageDrawersModule.getStandardConfig(drawerCount, halfDepth);
            return new BlockStandardDrawers(drawerCount, halfDepth, config, StorageDrawersModule.getWoodenDrawerBlockProperties());
        }).addCustomItem((TriFunction<WoodType, BlockStandardDrawers, Item.Properties, Item>)((TriFunction)(woodType, block, properties) -> new ItemDrawers((Block)block, properties))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(this.modRes("half_drawers"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTile(this.getModTile("standard_drawers_4")).build();
        this.addEntry(this.HALF_DRAWERS_4);
        this.TRIMS = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "trim", this.getModBlock("oak_trim", BlockTrim.class), () -> VanillaWoodTypes.OAK, w -> new BlockTrim(Utils.copyPropertySafe((Block)this.getModBlock("oak_trim").get()))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("trim"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).setTabKey(tab)).defaultRecipe().addTexture(this.modRes("block/drawers_oak_trim"), trimPalette)).build();
        this.addEntry(this.TRIMS);
    }

    static BlockBehaviour.Properties getWoodenDrawerBlockProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(3.0f, 4.0f).isSuffocating(StorageDrawersModule::predFalse).isRedstoneConductor(StorageDrawersModule::predFalse);
    }

    private static IDrawerConfig getStandardConfig(int drawerCount, boolean halfDepth) {
        ModCommonConfig.Drawers base = ModCommonConfig.INSTANCE.DRAWERS;
        if (drawerCount == 1) {
            return halfDepth ? base.halfDrawers1x1 : base.fullDrawers1x1;
        }
        if (drawerCount == 2) {
            return halfDepth ? base.halfDrawers1x2 : base.fullDrawers1x2;
        }
        if (drawerCount == 4) {
            return halfDepth ? base.halfDrawers2x2 : base.fullDrawers2x2;
        }
        return null;
    }

    private static boolean predFalse(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, s) -> ModDrawersGeometry.loadGeometryData(this, manager));
    }

    private <B extends Block> Stream<B> getBlocksOfType(Class<B> blockClass) {
        Stream<Object> allBlocks = this.getEntries().stream().map(e -> ((SimpleEntrySet)e).blocks.values()).flatMap(Collection::stream);
        Objects.requireNonNull(blockClass);
        allBlocks = allBlocks.filter(blockClass::isInstance);
        Objects.requireNonNull(blockClass);
        return allBlocks.map(blockClass::cast);
    }

    public Stream<BlockDrawers> getDrawers() {
        StorageDrawersModule obj = this;
        return this.getDrawersOfType(BlockDrawers.class);
    }

    public <BD extends BlockDrawers> Stream<BD> getDrawersOfType(Class<BD> drawerClass) {
        return this.getBlocksOfType(drawerClass);
    }

    public <BD extends BlockDrawers> Stream<BD> getDrawersOfTypeAndSize(Class<BD> drawerClass, int size) {
        return this.getDrawersOfType(drawerClass).filter(blockDrawers -> blockDrawers.getDrawerCount() == size);
    }

    public <BD extends BlockDrawers> Stream<BD> getDrawersOfTypeAndSizeAndDepth(Class<BD> drawerClass, int size, boolean halfDepth) {
        return this.getDrawersOfTypeAndSize(drawerClass, size).filter(blockDrawers -> blockDrawers.isHalfDepth() == halfDepth);
    }
}

