package net.mehvahdjukaar.every_compat.api;

import ;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.*;

//contrary to popular belief this class is indeed not simple. Its usage however is
public class ItemOnlyEntrySet<T extends BlockType, I extends class_1792> extends AbstractSimpleEntrySet<T, class_2248, I> {

    protected final Supplier<@Nullable I> baseItem;
    protected final Function<T, @Nullable I> itemFactory;

    public ItemOnlyEntrySet(Class<T> type,
                            String name, @Nullable String prefix,
                            Function<T, I> itemFactory,
                            Supplier<@Nullable I> baseItem,
                            Supplier<T> baseType,
                            @Nullable Supplier<class_5321<class_1761>> tab,
                            TabAddMode tabMode,
                            @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier,
                            @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform,
                            boolean mergedPalette, boolean copyTint,
                            Predicate<T> condition) {
        super(type, name, prefix, baseType, tab, tabMode, paletteSupplier, extraTransform, mergedPalette, copyTint, condition);
        this.itemFactory = itemFactory;
        this.baseItem = baseItem;
    }

    public I getBaseItem() {
        return baseItem.get();
    }

    @Override
    public void addTranslations(SimpleModule module, AfterLanguageLoadEvent lang) {
        items.forEach((w, v) -> LangBuilder.addDynamicEntry(lang, "item_type." + module.getModId() + "." + typeName, w, v));
    }

    @Override
    public void registerBlocks(SimpleModule module, Registrator<class_2248> registry, Collection<T> woodTypes) {

    }

    @NotNull
    public String getItemName(T w) {
        String name;
        if (prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) name += "_" + this.postfix;
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(SimpleModule module, Registrator<class_1792> registry) {
        BlockTypeRegistry<T> typeRegistry = BlockSetAPI.getTypeRegistry(this.type);
        for (T w : Objects.requireNonNull(typeRegistry).getValues()) {
            String name = getItemName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (module.isEntryAlreadyRegistered(name, w, class_7923.field_41178)) continue;

            if (condition.test(w)) {
                I item = itemFactory.apply(w);
                //for blocks that fail
                if (item != null) {
                    this.items.put(w, item);

                    registry.register(module.makeMyRes(fullName), item);
                    w.addChild(getChildKey(module), item);
                    totalChildren++;
                }
            }
        }
        //populate default ones
    }

    @Override
    public void registerTiles(SimpleModule module, Registrator<class_2591<?>> registry) {
        class_1792 base = getBaseItem();
        if (base == null || base == class_1802.field_8162)
            //?? wtf im using disabled to allow for null??
            throw new UnsupportedOperationException("Base Item cant be null (" + this.typeName + " for " + module.modId + " module)");

        String childKey = getChildKey(module);
        baseType.get().addChild(childKey, base);

        //attempts adding all other children
        Set<String> alreadySupportedMods = new HashSet<>(module.getAlreadySupportedMods());
        alreadySupportedMods.add(module.modId);
        var possibleNamespaces = alreadySupportedMods.toArray(String[]::new);
        for (var w : Objects.requireNonNull( BlockSetAPI.getTypeRegistry(this.getTypeClass())).getValues() ) {
            if (!items.containsKey(w)) {
                String path = getItemName(w);
                class_1792 item = getOptionalItem(path, w.getNamespace());
                if (item == null) item = getOptionalItem(path, possibleNamespaces);
                if (item != null) w.addChild(childKey, item);
            }
        }
    }

    @Nullable
    private static class_1792 getOptionalItem(String path, String... namespaces) {
        class_2960 id;
        for (var n : namespaces) {
            id = new class_2960(n, path);
            var i = class_7923.field_41178.method_17966(id);
            if (i.isPresent()) {
                return i.get();
            }
        }
        return null;
    }

    @Override
    public void setRenderLayer() {

    }

    @Override
    public void generateLootTables(SimpleModule module, class_3300 manager, ResourceSink sink) {

    }

    @Override
    public void generateModels(SimpleModule module, class_3300 manager, ResourceSink handler) {
        ResourcesUtils.generateStandardItemModels(manager, handler, items, baseType.get(),
                makeModelTransformer(module, manager));
    }

    // items models
    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, class_3300 manager) {
        BlockTypeResTransformer<T> modelTransformer = BlockTypeResTransformer.create(module.modId, manager);
        if (extraModelTransform != null) extraModelTransform.accept(modelTransformer);

        ResourcesUtils.addBuiltinModelTransformer(modelTransformer, baseType.get());

        return modelTransformer;
    }

    @Override
    public Map<T, ?> getDefaultEntries() {
        return items;
    }

    //ok...
    public static <T extends BlockType, I extends class_1792> net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet.Builder<T, I> builder(Class<T> type, String name,
                                                                              Supplier<I> baseItem, Supplier<T> baseType,
                                                                              Function<T, I> itemSupplier) {

        return new net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet.Builder<>(type, name, null, baseType, baseItem, itemSupplier);
    }

    public static <T extends BlockType, I extends class_1792> net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet.Builder<T, I> builder(Class<T> type, String name, String prefix,
                                                                              Supplier<I> baseItem, Supplier<T> baseType,
                                                                              Function<T, I> itemSupplier) {

        return new net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet.Builder<>(type, name, prefix, baseType, baseItem, itemSupplier);
    }

    public static class Builder<T extends BlockType, I extends class_1792> extends AbstractSimpleEntrySet.Builder<net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet.Builder<T, I>, T, class_2248, I> {
        protected final Supplier<@Nullable I> baseItem;
        protected final Function<T, I> itemFactory;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<I> baseItem, Function<T, I> itemFactory) {
            super(type, name, prefix, baseType);
            this.baseItem = baseItem;
            this.itemFactory = itemFactory;
        }

        public ItemOnlyEntrySet<T, I> build() {
            var e = new ItemOnlyEntrySet<>(type, name, prefix, itemFactory, baseItem, baseType, tab, tabMode,
                    palette, extraModelTransform, useMergedPalette, copyTint, condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(textures);
            return e;
        }

        public ItemOnlyEntrySet.Builder<T, I> defaultRecipe() {
            this.recipes.add(() -> Utils.getID(this.baseItem.get()));
            return this;
        }
    }
}
