package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public class TagUtility {

    /**
     * Get the namespace:WoodType_logs tag from the wood mods or create a new tag if not available
     *
     * @return ResourceLocation
     **/
    public static class_2960 getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink handler, class_3300 manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();

        // ResourceLocation
        class_2960 RLocLogs = new class_2960(resLocMOD + "_" + suffixTag);
        class_2960 RLocStems = new class_2960(resLocMOD + "_" + suffixAlt);
        class_2960 RLocFolders = new class_2960(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName());
        class_2960 RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);

        if (manager.method_14486(ResType.TAGS.getPath(RLocLogs.method_45138("blocks/"))).isPresent())
            return RLocLogs;
        else if (manager.method_14486(ResType.TAGS.getPath(RLocStems.method_45138("blocks/"))).isPresent())
            return RLocStems;
        else if (manager.method_14486(ResType.TAGS.getPath(RLocEC.method_45138("blocks/"))).isPresent())
            return RLocEC;
        else if (manager.method_14486(ResType.TAGS.getPath(RLocFolders.method_45138("blocks/"))).isPresent())
            return RLocFolders;
        else // if RLocECTags is not available, then it will be generated
            createAndAddDefaultTags(RLocEC, handler, blockType);

        return RLocEC;

    }

    /**
     * The method is to create a custom Tag file with
     * DEFAULT BLOCKS - log, stripped_log, wood, stripped_wood
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddDefaultTags(class_2960 resLoc, ResourceSink sink, BlockType blockType, class_2248... blocks) {
        if (blockType instanceof WoodType woodType)
            return createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        else
            return createAndAddCustomTags(resLoc, sink, blocks);
    }

    /**
     * Add any blocks to newly created tag
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_2248... blocks) {
        boolean isTagCreated = false;

        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(resLoc);
        // Adding blocks to tag file
        for (class_2248 block : blocks) {
            if (block != null) {
                tagBuilder.addEntry(block);
                isTagCreated = true;
            }
        }
        // Adding to the resources
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41254);
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId, String tag,
            boolean includeBlock, boolean includeItem, ResourceSink pack
    ) {
        addTagToAllBlocks(blocks, nameStone, modId,
                class_6862.method_40092(class_7924.field_41254, new class_2960(tag)),
                includeBlock, includeItem, pack);
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId, class_6862<class_2248> tag,
            boolean includeBlock, boolean includeItem, ResourceSink pack
    ) {
        addTagToAllBlocks(blocks, nameStone, modId,
                tag, includeBlock, includeItem, pack, null);
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId,
            class_6862<class_2248> tag, boolean includeBlock, boolean includeItem, ResourceSink pack,
            @Nullable String regexBlockId
    ) {
        if (PlatHelper.isModLoaded(modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                T stoneType = entry.getKey();
                B block = entry.getValue();

                String blockPath = Utils.getID(block).method_12832();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);

                if (stoneType.getTypeName().equals(nameStone) &&
                        (regexBlockId == null || blockId.matches(regexBlockId))) {
                    tagBuilder.addEntry(block);
                    isTagCreated = true;
                }
            }
            if (isTagCreated) {
                if (includeBlock) pack.addTag(tagBuilder, class_7924.field_41254);
                if (includeItem) pack.addTag(tagBuilder, class_7924.field_41197);
            }
        }
    }

}
