package net.mehvahdjukaar.every_compat.misc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1087;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_918;
import I;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map.Entry;

@Environment(EnvType.CLIENT)
public abstract class BlockTypeCycleItemRenderer<T extends BlockType> extends ItemStackRenderer {

    private final List<String> childKeys = new ArrayList<>();
    private final List<T> moddedTypes = new ArrayList<>();
    private final Class<T> typeClass;
    private class_1799 currentStack = class_1802.field_8077.method_7854();
    private int lastIndex = 0;
    private int lastTime = 0;
    private int typeIndex = 0;
    private boolean initialized;

    public BlockTypeCycleItemRenderer(Class<T> tClass) {
        super();
        this.typeClass = tClass;
    }

    private void initialize() {
        BlockTypeRegistry<T> reg = BlockSetAPI.getTypeRegistry(typeClass);
        if (reg == null) return;
        for (var c : reg.getDefaultType().getChildren()) {
            if (c.getKey().contains(":") && !childKeys.contains(c.getKey()) && c.getValue() instanceof class_1935) {
                childKeys.add(c.getKey());
            }
        }
        for (var w : reg.getValues()) {
            if (!w.isVanilla()) moddedTypes.add(w);
        }
        if (moddedTypes.isEmpty()) childKeys.clear();
        Collections.shuffle(moddedTypes);
    }

    @Override
    public void method_3166(class_1799 stack, class_811 transformType,
                             class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {

        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        class_1799 item = getAnyItem();

        var itemRenderer = class_310.method_1551().method_1480();

        matrixStack.method_22903();
        matrixStack.method_22904(0.5D, 0.5D, 0.5D);
        class_1087 bakedmodel = itemRenderer.method_4019(item, null, null, 0);
        itemRenderer.method_23179(item, transformType, false, matrixStack, buffer, combinedLight, combinedOverlay, bakedmodel);
        if (!bakedmodel.method_4712()) class_308.method_24210();
        //forces rendering now with flat lighting
        if (buffer instanceof class_4597.class_4598 bu) {
            bu.method_22993();
        }
        class_308.method_24211();
        matrixStack.method_22909();

    }


    public class_1799 getAnyItem() {
        int size = childKeys.size();
        if (size == 0) return class_1802.field_8077.method_7854();
        int time = (int) (class_156.method_658() / 350L);
        int tm = time % (size+1);
        if (tm != lastTime) {

            class_1935 v = null;
            do {
                var l = (this.lastIndex + 1) % size;
                // this.woodIndex = (this.woodIndex + 1);
                if (l < lastIndex || size == 1) this.typeIndex = (this.typeIndex + 1) % moddedTypes.size();
                this.lastIndex = l;
                String key = childKeys.get(lastIndex);
                var vv = moddedTypes.get(typeIndex % moddedTypes.size()).getChild(key);
                if (vv instanceof class_1935 il) {
                    v = il;
                }
            } while (v == null);

            this.currentStack = v.method_8389().method_7854();
        }
        this.lastTime = tm;
        return currentStack;
    }
}
