package net.mehvahdjukaar.every_compat.modules.fabric.mcaw;

import net.kikoz.mcwbridges.MacawsBridges;
import net.kikoz.mcwbridges.init.BlockInit;
import net.kikoz.mcwbridges.objects.*;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

// SUPPORT: v3.0.0+
public class MacawBridgesModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> bridgePiers;
    public final SimpleEntrySet<WoodType, class_2248> bridgeMiddles;
    public final SimpleEntrySet<WoodType, class_2248> ropeBridges;
    public final SimpleEntrySet<WoodType, class_2248> railBridges;
    public final SimpleEntrySet<WoodType, class_2248> bridgeStairs;
    public final SimpleEntrySet<WoodType, class_2248> ropeStairs;

    public MacawBridgesModule(String modId) {
        super(modId, "mcb");
        class_5321<class_1761> tab = MacawsBridges.BRIDGEGROUP;

        bridgePiers = SimpleEntrySet.builder(WoodType.class, "bridge_pier",
                        () -> BlockInit.OAK_BRIDGE_PIER, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Bridge_Support(Utils.copyPropertySafe(w.planks)))
                .requiresChildren("fence") //REASON: recieps
                //TEXTURES: log, planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_piers"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(bridgePiers);

        ropeBridges = SimpleEntrySet.builder(WoodType.class, "bridge", "rope",
                        () -> BlockInit.ROPE_OAK_BRIDGE, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Bridge_Block_Rope(Utils.copyPropertySafe(w.planks)))
                .requiresChildren("slab") //REASON: recieps
                //TEXTURES: log, planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("rope_bridges"), class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(ropeBridges);

        bridgeMiddles = SimpleEntrySet.builder(WoodType.class, "log_bridge_middle",
                        () -> BlockInit.OAK_LOG_BRIDGE_MIDDLE, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Log_Bridge(Utils.copyPropertySafe(w.planks)))
                .requiresChildren("slab", "fence") //REASON: recieps
                //TEXTURES: log, planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("log_bridges"), class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(bridgeMiddles);


        railBridges = SimpleEntrySet.builder(WoodType.class, "rail_bridge",
                        () -> BlockInit.OAK_RAIL_BRIDGE, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Rail_Bridge(Utils.copyPropertySafe(w.planks).method_22488()))
                .requiresChildren("slab", "fence") //REASON: recieps
                //TEXTURES: log, planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("rail_bridges"), class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(railBridges);


        bridgeStairs = SimpleEntrySet.builder(WoodType.class, "log_bridge_stair",
                        () -> BlockInit.OAK_LOG_BRIDGE_STAIR, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Bridge_Stairs(Utils.copyPropertySafe(w.planks)))
                .requiresFromMap(bridgeMiddles.blocks) //REASON: recipes
                //TEXTURES: log, planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("log_stairs"), class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(bridgeStairs);

        ropeStairs = SimpleEntrySet.builder(WoodType.class, "rope_bridge_stair",
                        () -> BlockInit.OAK_ROPE_BRIDGE_STAIR, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new Bridge_Stairs(Utils.copyPropertySafe(w.planks)))
                .requiresFromMap(ropeBridges.blocks) //REASON: recipes
                //TEXTURES: log, planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("rope_stairs"), class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(ropeStairs);


    }


}
