package net.mehvahdjukaar.every_compat.modules.fabric.regions_unexplored;

import com.google.gson.JsonObject;
import io.github.uhq_games.regions_unexplored.block.RuBlocks;
import io.github.uhq_games.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import io.github.uhq_games.regions_unexplored.world.level.block.plant.tall.ShrubBlock;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_7924;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.TagUtility.createAndAddCustomTags;

// SUPPORT: v0.5.6+
public class RegionsUnexploredModule extends SimpleModule {
    public final SimpleEntrySet<WoodType, class_2248> branchs;
    public final SimpleEntrySet<LeavesType, class_2248> shrubs;

    public RegionsUnexploredModule(String modId) {
        super(modId, "ru");
        var tab = modRes("main");

        branchs = SimpleEntrySet.builder(WoodType.class, "branch",
                        getModBlock("oak_branch"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new BranchBlock(class_4970.class_2251.method_9630(RuBlocks.ACACIA_BRANCH),
                                BranchBlock.BranchType.BRANCH)
                )
                .addTexture(modRes("block/oak_branch"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("branches"), class_7924.field_41254)
                .addTag(modRes("branches"), class_7924.field_41197)
                .addRecipe(modRes("oak_branch_from_oak_log"))
                .setTabKey(tab)
                .build();
        this.addEntry(branchs);

        shrubs = SimpleEntrySet.builder(LeavesType.class, "shrub",
                        getModBlock("dark_oak_shrub"),
                        () -> LeavesTypeRegistry.getValue(new class_2960("dark_oak")),
                        l -> new ShrubBlock(Utils.copyPropertySafe(l.leaves).method_50012(class_3619.field_15971)
                                .method_50013().method_9634().method_9618().method_9626(class_2498.field_28694)
                                .method_49229(class_4970.class_2250.field_10657))
                )
                .addCondition(l -> {
                    boolean log = l.getWoodType() != null; //REASON: textures
                    boolean sapling = l.getItemOfThis("sapling") != null; //REASON: recipes
                    return log && sapling;
                })
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("shrubs"), class_7924.field_41254)
                .addTag(modRes("shrub_can_survive_on"), class_7924.field_41254)
                .addTag(modRes("shrubs"), class_7924.field_41197)
                .addRecipe(modRes("dark_oak_shrub"))
                .addRecipe(modRes("dark_oak_sapling_from_dark_oak_shrub"))
                .addTexture(EveryCompat.res("block/dark_oak_shrub_top"))
                .copyParentDrop()
                .setTabKey(tab)
                .build();
        this.addEntry(shrubs);
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        super.registerItemColors(event);
        for (Map.Entry<LeavesType, class_2248> entry : shrubs.blocks.entrySet()) {
            LeavesType type = entry.getKey();
            class_2248 block = entry.getValue();
            event.register((stack, tintIndex) -> {
                if (tintIndex > 0) return 0xFFFFFFFF;
                return event.getColor(new class_1799(type.leaves), tintIndex);
            }, block);
        }
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        super.registerBlockColors(event);
        for (Map.Entry<LeavesType, class_2248> entry : shrubs.blocks.entrySet()) {
            LeavesType type = entry.getKey();
            class_2248 b = entry.getValue();
            event.register((blockState, tintGetter, pos, index) ->
                    event.getColor(type.leaves.method_9564(), tintGetter, pos, index), b);
        }
    }

    @Override
    // Tags
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, sink) -> {
            branchs.blocks.forEach((wood, block) -> {
                SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(modRes("branches_can_survive_on"));
                tagBuilder.add(Utils.getID(wood.log));
                sink.addTag(tagBuilder, class_7924.field_41254);

                //Tagging the planks as ingredient to get painted_planks
                createAndAddCustomTags(new class_2960("planks"), sink, wood.planks);
                createAndAddCustomTags(new class_2960("c:planks"), sink, wood.planks);
            });

        });
    }

    @Override
    // Textures
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {

// Generating branch textures ==========================================================================================
            try (TextureImage branch_side = TextureImage.open(manager, EveryCompat.res("item/oak_branch_side"));
                 TextureImage branch_top = TextureImage.open(manager, EveryCompat.res("item/oak_branch_top"));
                 TextureImage branch_block = TextureImage.open(manager, modRes("block/oak_branch"))
            ) {

                branchs.blocks.forEach((wood, block) -> {
                    try (TextureImage logSide_texture = TextureImage.open(manager, RPUtils.findFirstBlockTextureLocation(manager, wood.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage logTop_texture = TextureImage.open(manager, RPUtils.findFirstBlockTextureLocation(manager, wood.planks))) {

                        class_2960 resLocITEM = EveryCompat.res("item/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                        class_2960 resLocBLOCK = EveryCompat.res("block/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");

                        Respriter respriterSIDE = Respriter.of(branch_side); // ITEM
                        Respriter respriterTOP = Respriter.of(branch_top); // ITEM
                        Respriter respriterBlock = Respriter.of(branch_block); // BLOCK

                        // Recoloring ITEM textures
                        TextureImage recoloredITEM = respriterSIDE.recolorWithAnimationOf(logSide_texture);
                        TextureImage recoloredTOP = respriterTOP.recolorWithAnimationOf(logTop_texture);
                        recoloredITEM.applyOverlay(recoloredTOP);

                        // Recoloring BLOCK texture
                        TextureImage recoloredBLOCK = respriterBlock.recolorWithAnimationOf(logSide_texture);

                        // Block Texture
                        sink.addAndCloseTexture(resLocBLOCK, recoloredBLOCK);
                        // Item Texture
                        sink.addAndCloseTexture(resLocITEM, recoloredITEM);

                    } catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to get Log Texture for {} : {}", block, e);
                    }
                });
            } catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to get Branch Item Texture for ", e);
            }

    // Generating shrub textures ===========================================================================================
            try (
                    // middle is where the log color is located below the leave via dark_oak_shrub_top
                    TextureImage shrubMiddle = TextureImage.open(manager,
                            EveryCompat.res("block/regions_unexplored/dark_oak_shrub_middle"));
                    TextureImage shrubBottom = TextureImage.open(manager, modRes("block/dark_oak_shrub_bottom"))
            ) {

                shrubs.blocks.forEach((leavesType, block) -> {
                    // Modifying BLOCK MODEL
                    String shrubPath = shortenedId() + "/" + leavesType.getAppendableId() + "_shrub";

                    String crossModel = """
                            {
                                "parent": "minecraft:block/cross",
                                "render_type": "cutout",
                                "textures": {
                                    "particle": "[shrub_top]",
                                    "cross_tint": "[shrub_top]",
                                    "cross": "[shrub_middle]"
                                },
                                "elements": [
                                    {   "from": [ 0.8, 0, 8 ],
                                        "to": [ 15.2, 16, 8 ],
                                        "rotation": { "origin": [ 8, 8, 8 ], "axis": "y", "angle": 45, "rescale": true },
                                        "shade": false,
                                        "faces": {
                                            "north": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross" },
                                            "south": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross" }
                                        }
                                    },
                                    {   "from": [ 8, 0, 0.8 ],
                                        "to": [ 8, 16, 15.2 ],
                                        "rotation": { "origin": [ 8, 8, 8 ], "axis": "y", "angle": 45, "rescale": true },
                                        "shade": false,
                                        "faces": {
                                            "west": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross" },
                                            "east": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross" }
                                        }
                                    },
                                    {   "from": [ 0.8, 0, 8 ],
                                        "to": [ 15.2, 16, 8 ],
                                        "rotation": { "origin": [ 8, 8, 8 ], "axis": "y", "angle": 45, "rescale": true },
                                        "shade": false,
                                        "faces": {
                                            "north": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross_tint", "tintindex": 0 },
                                            "south": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross_tint", "tintindex": 0 }
                                        }
                                    },
                                    {   "from": [ 8, 0, 0.8 ],
                                        "to": [ 8, 16, 15.2 ],
                                        "rotation": { "origin": [ 8, 8, 8 ], "axis": "y", "angle": 45, "rescale": true },
                                        "shade": false,
                                        "faces": {
                                            "west": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross_tint", "tintindex": 0 },
                                            "east": { "uv": [ 0, 0, 16, 16 ], "texture": "#cross_tint", "tintindex": 0 }
                                        }
                                    }
                                ]
                            }
                            """;


                    String blockID = "everycomp:block/" + shrubPath;

                    String newModel = crossModel.replace("[shrub_middle]", blockID + "_middle")
                            .replace("[shrub_top]", blockID + "_top");

                    sink.addBytes(EveryCompat.res(shrubPath), newModel.getBytes(), ResType.BLOCK_MODELS);

                    // Modifying ITEM MODEL ============================================================================
                    var itemPath = ResType.ITEM_MODELS.getPath(EveryCompat.res(shrubPath));

                    try (InputStream modelItemStream = manager.method_14486(itemPath)
                            .orElseThrow(FileNotFoundException::new).method_14482()) {

                        JsonObject modelItem = RPUtils.deserializeJson(modelItemStream);

                        modelItem.getAsJsonObject("textures")
                                .addProperty("layer0", blockID + "_top");
                        modelItem.getAsJsonObject("textures")
                                .addProperty("layer1", blockID + "_middle");

                        sink.addJson(EveryCompat.res(shrubPath), modelItem, ResType.ITEM_MODELS);

                    } catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to open the item model file via {} : {}", itemPath, e);
                    }

                    // Generating textures for shrubs ==================================================================
                    try (TextureImage logTexture = TextureImage.open(manager,
                            RPUtils.findFirstBlockTextureLocation(manager, leavesType.getWoodType().log,
                                    SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE))
                    ) {
                        Respriter respriterBottom = Respriter.of(shrubBottom);

                        Respriter respriterMiddle = Respriter.of(shrubMiddle);

                        // Recoloring the log middle & bottom
                        TextureImage recoloredMiddle = respriterMiddle.recolorWithAnimationOf(logTexture);
                        TextureImage recoloredBottom = respriterBottom.recolorWithAnimationOf(logTexture);

                        // Adding to the resource
                        String resLoc = "block/" + shrubPath;
                        sink.addAndCloseTexture(EveryCompat.res(resLoc + "_middle"), recoloredMiddle);
                        sink.addAndCloseTexture(EveryCompat.res(resLoc + "_bottom"), recoloredBottom);

                    } catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to get texture for {} : {}", block.toString(), e);
                    }
                });
            } catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to open textures for: ", e);
            }

        });
    }
}
