package net.mehvahdjukaar.every_compat.modules.fabric.variants;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSet.Builder;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2304;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3708;
import net.minecraft.class_3711;
import net.minecraft.class_3712;
import net.minecraft.class_3713;
import net.minecraft.class_3715;
import net.minecraft.class_3716;
import net.minecraft.class_3717;
import net.minecraft.class_3962;
import net.minecraft.class_4158;
import net.minecraft.class_4481;
import net.minecraft.class_7714;
import net.minecraft.class_7924;
import net.minecraft.world.level.block.*;
import net.xanthian.variantvanillablocks.Initialise;
import net.xanthian.variantvanillablocks.block.*;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;


//SUPPORT: v1.3.6+
//why isn't this in common??
public class VariantVanillaBlocksModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_3708> barrel;
    public final SimpleEntrySet<WoodType, class_4481> beehive;
    public final SimpleEntrySet<WoodType, class_2248> bookshelves;
    public final SimpleEntrySet<WoodType, class_3711> cartography;

    public final SimpleEntrySet<WoodType, class_2248> chests;
    public final SimpleEntrySet<WoodType, class_7714> chiseledBookshelves;
    public final SimpleEntrySet<WoodType, class_3962> composters;
    public final SimpleEntrySet<WoodType, class_2304> craftingTable;
    public final SimpleEntrySet<WoodType, class_3712> fletchingTable;
    public final SimpleEntrySet<WoodType, class_3713> grindstones;
    public final SimpleEntrySet<WoodType, class_3715> lectern;
    public final SimpleEntrySet<WoodType, class_3717> smithingTable;
    public final SimpleEntrySet<WoodType, class_3716> smoker;
    //LOOM?

    // Point-Of-Interest for Beehives -  //!! - remove when the addBlocksToPOI() is fixed & enabled below
    protected final class_2960 poiId = EveryCompat.res("vvb_beehive");
    public final Supplier<class_4158> compatBeeHivePOI = RegHelper.registerPOI(poiId,
            () -> new class_4158(getBeehives(), 1, 1));
    private Set<class_2680> getBeehives() {
        var set = new ImmutableSet.Builder<class_2680>();
        beehive.blocks.values().forEach(b -> set.addAll(b.method_9595().method_11662()));
        return set.build();
    }

    public VariantVanillaBlocksModule(String modID) {
        super(modID, "vvb");
        class_2960 tab = modRes(Initialise.MOD_ID);

        //Barrel
        barrel = SimpleEntrySet.builder(WoodType.class, "barrel",
                        () -> Barrels.OAK_BARREL, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_3708(Utils.copyPropertySafe(class_2246.field_16328))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23800, class_7924.field_41254)
                .addTag(modRes("barrels"), class_7924.field_41254)
                .addTag(new class_2960("c:barrels"), class_7924.field_41254)
                .addTag(new class_2960("c:barrels_wooden"), class_7924.field_41254)
                .addTag(modRes("barrels"), class_7924.field_41197)
                .addTag(new class_2960("c:barrels"), class_7924.field_41197)
                .addTag(new class_2960("c:barrels_wooden"), class_7924.field_41197)
                .addTexture(modRes("block/oak_barrel_bottom"))
                .addTextureM(modRes("block/oak_barrel_side"),
                        EveryCompat.res("block/vanilla_barrel_side_m"))
                .addTextureM(modRes("block/oak_barrel_top"),
                        EveryCompat.res("block/vanilla_barrel_top_m"))
                .addTexture(modRes("block/oak_barrel_top_open"))
                .addTile(() -> class_2591.field_16411)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(barrel);

        beehive = SimpleEntrySet.builder(WoodType.class, "beehive",
                        () -> Beehives.SPRUCE_BEEHIVE,
                        () -> WoodTypeRegistry.getValue("spruce"),
                        w -> new class_4481(Utils.copyPropertySafe(class_2246.field_20422))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_20340, class_7924.field_41254)
                .addTag(modRes("beehives"), class_7924.field_41254)
                .addTag(modRes("beehives"), class_7924.field_41197)
                .addTexture(modRes("block/spruce_beehive_end"))
                .addTexture(modRes("block/spruce_beehive_front"))
                .addTextureM(modRes("block/spruce_beehive_front_honey"),
                        EveryCompat.res("block/spruce_beehive_front_honey_m"))
                .addTextureM(modRes("block/spruce_beehive_side"),
                        EveryCompat.res("block/spruce_beehive_side_m"))
                .addTile(() -> class_2591.field_20431)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beehive);

        bookshelves = SimpleEntrySet.builder(WoodType.class, "bookshelf",
                        () -> Bookshelves.ACACIA_BOOKSHELF,
                        () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new class_2248(Utils.copyPropertySafe(class_2246.field_10504))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_44472, class_7924.field_41254)
                .addTag(modRes("bookshelves"), class_7924.field_41254)
                .addTag(new class_2960("c:bookshelves"), class_7924.field_41254)
                .addTag(modRes("bookshelves"), class_7924.field_41197)
                .addTag(new class_2960("c:bookshelves"), class_7924.field_41197)
                .addTextureM(modRes("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(bookshelves);

        cartography = SimpleEntrySet.builder(WoodType.class, "cartography_table",
                        () -> CartographyTables.OAK_CARTOGRAPHY_TABLE, () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_3711(Utils.copyPropertySafe(class_2246.field_16336)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("cartography_tables"), class_7924.field_41254)
                .addTag(modRes("cartography_tables"), class_7924.field_41197)
                .addTextureM(modRes("block/oak_cartography_table_side1"), EveryCompat.res("block/vanilla_cartography_table_side1_m"))
                .addTextureM(modRes("block/oak_cartography_table_side2"), EveryCompat.res("block/vanilla_cartography_table_side2_m"))
                .addTexture(modRes("block/oak_cartography_table_side3"))
                .addTextureM(modRes("block/oak_cartography_table_top"), EveryCompat.res("block/vanilla_cartography_table_top_m"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(cartography);

        chests = SimpleEntrySet.builder(WoodType.class, "chest",
                        () -> Chests.ACACIA_CHEST,
                        () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new CompatChestBlock(this::getTile, Utils.copyPropertySafe(w.planks))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23800, class_7924.field_41254)
                .addTag(modRes("chests"), class_7924.field_41254)
                .addTag(new class_2960("c:chests_wooden"), class_7924.field_41254)
                .addTag(new class_2960("c:chests"), class_7924.field_41254)
                .addTag(modRes("chests"), class_7924.field_41197)
                .addTag(new class_2960("c:chests_wooden"), class_7924.field_41197)
                .addTag(new class_2960("c:chests"), class_7924.field_41197)
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .addTile(VariantChestBlockEntity::new)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(chests);

        chiseledBookshelves = SimpleEntrySet.builder(WoodType.class, "chiseled_bookshelf",
                        () -> ChiseledBookshelves.ACACIA_CHISELED_BOOKSHELF,
                        () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new class_7714(Utils.copyPropertySafe(w.planks))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("chiseled_bookshelves"), class_7924.field_41254)
                .addTag(modRes("chiseled_bookshelves"), class_7924.field_41197)
                .addTexture(modRes("block/acacia_chiseled_bookshelf_empty"))
                .addTextureM(modRes("block/acacia_chiseled_bookshelf_occupied"),
                        EveryCompat.res("block/vanilla_chiseled_bookshelf_occupied_m"))
                .addTexture(modRes("block/acacia_chiseled_bookshelf_side"))
                .addTexture(modRes("block/acacia_chiseled_bookshelf_top"))
                .addTile(() -> class_2591.field_40329)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(chiseledBookshelves);

        composters = SimpleEntrySet.builder(WoodType.class, "composter",
                        () -> Composters.OAK_COMPOSTER,
                        () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_3962(Utils.copyPropertySafe(class_2246.field_17563))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("composters"), class_7924.field_41254)
                .addTag(modRes("composters"), class_7924.field_41197)
                .addTexture(modRes("block/oak_composter_bottom"))
                .addTexture(modRes("block/oak_composter_side"))
                .addTexture(modRes("block/oak_composter_top"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(composters);

        craftingTable = SimpleEntrySet.builder(WoodType.class, "crafting_table",
                        () -> CraftingTables.SPRUCE_CRAFTING_TABLE,
                        () -> WoodTypeRegistry.getValue("spruce"),
                        w -> new class_2304(Utils.copyPropertySafe(w.planks)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("crafting_tables"), class_7924.field_41254)
                .addTag(modRes("crafting_tables"), class_7924.field_41197)
                //TEXTURE: texture is oak_craftng_table's texture
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_front"), EveryCompat.res("block/vct/spruce_crafting_table_front_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_side"), EveryCompat.res("block/vct/spruce_crafting_table_side_m"))
                .addTexture(EveryCompat.res("block/spruce_crafting_table_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(craftingTable);

        fletchingTable = SimpleEntrySet.builder(WoodType.class, "fletching_table",
                        () -> FletchingTables.OAK_FLETCHING_TABLE,
                        () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_3712(Utils.copyPropertySafe(class_2246.field_16331)) {
                        }
                )
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("fletching_tables"), class_7924.field_41254)
                .addTag(modRes("fletching_tables"), class_7924.field_41197)
                .addTextureM(modRes("block/oak_fletching_table_front"),
                        EveryCompat.res("block/vanilla_fletching_table_front_m"))
                .addTextureM(modRes("block/oak_fletching_table_side"),
                        EveryCompat.res("block/vanilla_fletching_table_side_m"))
                .addTextureM(modRes("block/oak_fletching_table_top"),
                        EveryCompat.res("block/vanilla_fletching_table_top_m"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(fletchingTable);

        grindstones = SimpleEntrySet.builder(WoodType.class, "grindstone",
                        () -> Grindstones.OAK_GRINDSTONE,
                        () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_3713(Utils.copyPropertySafe(class_2246.field_16337)) {
                        }
                )
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("grindstones"), class_7924.field_41254)
                .addTag(modRes("grindstones"), class_7924.field_41197)
                .addTexture(modRes("block/oak_grindstone_pivot"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(grindstones);

        lectern = SimpleEntrySet.builder(WoodType.class, "lectern",
                        () -> Lecterns.ACACIA_LECTERN,
                        () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new class_3715(Utils.copyPropertySafe(class_2246.field_16330)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("lecterns"), class_7924.field_41254)
                .addTag(modRes("lecterns"), class_7924.field_41197)
                .addTextureM(modRes("block/acacia_lectern_base"),
                        EveryCompat.res("block/vanilla_lectern_base_m"))
                .addTextureM(modRes("block/acacia_lectern_front"),
                        EveryCompat.res("block/vanilla_lectern_front_m"))
                .addTexture(modRes("block/acacia_lectern_sides"))
                .addTexture(modRes("block/acacia_lectern_top"))
                .addTile(() -> class_2591.field_16412)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(lectern);

        smithingTable = SimpleEntrySet.builder(WoodType.class, "smithing_table",
                        () -> SmithingTables.OAK_SMITHING_TABLE,
                        () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_3717(Utils.copyPropertySafe(class_2246.field_16329)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("smithing_tables"), class_7924.field_41254)
                .addTag(modRes("smithing_tables"), class_7924.field_41197)
                .addTextureM(modRes("block/oak_smithing_table_bottom"),
                        EveryCompat.res("block/vanilla_smithing_table_bottom_m"))
                .addTextureM(modRes("block/oak_smithing_table_front"),
                        EveryCompat.res("block/vanilla_smithing_table_front_m"))
                .addTextureM(modRes("block/oak_smithing_table_side"),
                        EveryCompat.res("block/vanilla_smithing_table_side_m"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(smithingTable);

        smoker = SimpleEntrySet.builder(WoodType.class, "smoker",
                        () -> Smokers.ACACIA_SMOKER,
                        () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new class_3716(Utils.copyPropertySafe(class_2246.field_16334)) {
                        }
                )
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("smokers"), class_7924.field_41254)
                .addTag(modRes("smokers"), class_7924.field_41197)
                .addTextureM(modRes("block/acacia_smoker_front"),
                        EveryCompat.res("block/vanilla_smoker_front_m"))
                .addTextureM(modRes("block/acacia_smoker_front_on"),
                        EveryCompat.res("block/vanilla_smoker_front_on_m"))
                .addTextureM(modRes("block/acacia_smoker_side"),
                        EveryCompat.res("block/vanilla_smoker_side_m"))
                .addTextureM(modRes("block/acacia_smoker_top"),
                        EveryCompat.res("block/vanilla_smoker_x_m"))
                .addTextureM(modRes("block/acacia_smoker_bottom"),
                        EveryCompat.res("block/vanilla_smoker_x_m"))
                .addTile(() -> class_2591.field_16414)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(smoker);

    }

    //kind of hacy.dont like but we cant reference chests itself while constructing its own object
    // GetTiles
    private class_2591<? extends class_2595> getTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity
    private class VariantChestBlockEntity extends CompatChestBlockEntity {
        public VariantChestBlockEntity(class_2338 pos, class_2680 state) {
            super(chests.getTile(), pos, state);
        }
    }

    @SuppressWarnings("CommentedOutCode")
    @Override
    public void onModSetup() {
        super.onModSetup();

        // POI & ACQUIREABLE_JOB //!! Dont use below until the problem is fixed
        /*
        RegHelper.addBlocksToPOI(PoiTypes.BEEHIVE, beehive.blocks.values());
        RegHelper.addBlocksToPOI(PoiTypes.LIBRARIAN, lectern.blocks.values());
        RegHelper.addBlocksToPOI(PoiTypes.FLETCHER, fletchingTable.blocks.values());
        RegHelper.addBlocksToPOI(PoiTypes.BUTCHER, smoker.blocks.values());
        RegHelper.addBlocksToPOI(PoiTypes.FISHERMAN, barrel.blocks.values());
        RegHelper.addBlocksToPOI(PoiTypes.FARMER, composters.blocks.values());
        RegHelper.addBlocksToPOI(PoiTypes.WEAPONSMITH, grindstones.blocks.values());
        */
    }

    // REGISTRY --------------------------------------------------------------------------------------------------------

    @Override
    @Environment(EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        /*
        apparently due to class verifier issues this is needed since it needs to check if that lambda actually implements that interface and to do so it needs to load the class
        now I have no clue why this isn't needed on the other modules (this is only fabric one so maybe that?)
        could it be that environment here strips stuff less that on common? or that all classes that use this rendered also happen to be de facto fabric classes
        ClientProxy.shutUpClassVerifier(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        this is so dumb and IDK why it's needed. that class should never be loaded since it has environment annotation
        I tried everything, lambdas, double lambdas, anonymous classes...
        */
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
    }


    @Override
    // TEXTURES
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            chests.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia_chest"),
                        EveryCompat.res("model/oak_chest_normal_m"),
                        EveryCompat.res("model/oak_chest_normal_o"),
                        null
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia_chest_left"),
                        EveryCompat.res("model/oak_chest_left_m"),
                        EveryCompat.res("model/oak_chest_left_o"),
                        null
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia_chest_right"),
                        EveryCompat.res("model/oak_chest_right_m"),
                        EveryCompat.res("model/oak_chest_right_o"),
                        null
                );

                // MODEL ITEM
                String path = shortenedId() + "/" + wood.getAppendableId() + "_chest"; // path to json for chest
                JsonObject modelFile;
                class_2960 modelRLoc = EveryCompat.res("models/item/" + path + ".json");

                if (manager.method_14486(modelRLoc).isPresent()) {
                    try (InputStream modelStream = manager.method_14486(modelRLoc).get().method_14482()) {
                        modelFile = RPUtils.deserializeJson(modelStream);
                        String textureID = EveryCompat.MOD_ID + ":chest/" + path;
                        // Editing
                        modelFile.getAsJsonObject("textures").addProperty("chest", textureID);

                        // Add to Resource
                        sink.addJson(EveryCompat.res(path), modelFile, ResType.ITEM_MODELS);
                    } catch (IOException e) {
                        EveryCompat.LOGGER.error("VariantVanillaBlocks: failed to open the model file: {} - {}", modelRLoc, e);
                    }
                }
            });

        });
    }

}
