package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import java.util.Map;
import java.util.Objects;

@SuppressWarnings("unused")
public class Utilities {

    public static boolean doChildrenExistFor(BlockType blockType, String... blockTypes) {
        for (String type : blockTypes) {
            if (Objects.isNull(blockType.getBlockOfThis(type))) return false;
        }
        return true;
    }

    public static boolean doChildrenExistFor(BlockType blockType, SimpleEntrySet<?, ?> entrySet) {
            return Objects.nonNull(entrySet.blocks.get(blockType));
    }

    public static class_2248 getChildrenBlockSafe(String childkey, BlockType blockType) {
        class_2248 block = blockType.getBlockOfThis(childkey);
        class_2248 blockAlt = null;
        if (childkey.contains("_")) {
            String[] split = childkey.split("_");
            blockAlt = blockType.getBlockOfThis(split[split.length - 1]);
        }

        if (Objects.nonNull(block)) return block;
        else if (Objects.nonNull(blockAlt)) return blockAlt;
        else return (class_2248) blockType.mainChild();
    }

    public static class_4970.class_2251 copyChildrenPropertySafe(String childKey, BlockType blockType) {
        return Utils.copyPropertySafe(getChildrenBlockSafe(childKey, blockType));
    }

    /**
     * @param childkey stairs, slab, or other childkeys can be used
     * @param blockType WoodType, LeavesType, or other BlockTypes
     */
    public static class_2680 copyBlockStateSafe(String childkey, BlockType blockType) {
        return getChildrenBlockSafe(childkey, blockType).method_9564();
    }

    /**
     * @param blocks SimpleEntrySet.blocks
     * @param blockType WoodType, LeavesType, or other BlockTypes
     */
    public static class_2680 copyBlockStateSafe(Map<?, class_2248> blocks, BlockType blockType) {
        if (Objects.nonNull(blocks.get(blockType))) return blocks.get(blockType).method_9564();
        else return ((class_2248) blockType.mainChild()).method_9564();
    }

}
