package net.mehvahdjukaar.every_compat.modules.fabric.mcaw;

import net.kikoz.mcwtrpdoors.MacawsTrapdoors;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2533;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.STRIPPED_LOG;

//SUPPORT: v1.1.4+
public class MacawTrapdoorsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> BARK_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BARN_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BARRED_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BEACH_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> CLASSIC_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> COTTAGE_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> FOUR_PANEL_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> GLASS_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> MESH_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> MYSTIC_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> PAPER_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> RANCH_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> SWAMP_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> TROPICAL_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> WAFFLE_TRAPDOORS; // BLOSSOM
    public final SimpleEntrySet<WoodType, class_2248> BARREL_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> WHISPERING_TRAPDOORS;

    public MacawTrapdoorsModule(String modId) {
        super(modId, "mct", EveryCompat.MOD_ID);
        class_5321<class_1761> tab = MacawsTrapdoors.TRAPDOORSGROUP;

        BARK_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "bark_trapdoor",
                        getModBlock("oak_bark_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.log).method_22488()){}
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("bark_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(BARK_TRAPDOORS);

        BARN_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "barn_trapdoor",
                        getModBlock("oak_barn_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks)){}
                )
                .addTexture(modRes("block/barn/oak_barn_trapdoor"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("barn_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(BARN_TRAPDOORS);

        BARRED_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "barred_trapdoor",
                        getModBlock("oak_barred_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTexture(modRes("block/barred/oak_barred_trapdoor"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("barred_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(BARRED_TRAPDOORS);

        BEACH_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "beach_trapdoor",
                        getModBlock("oak_beach_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTextureM(modRes("block/beach/oak_beach_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_beach_trapdoor_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("beach_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(BEACH_TRAPDOORS);

        CLASSIC_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "classic_trapdoor",
                        getModBlock("spruce_classic_trapdoor"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTexture(modRes("block/classic/spruce_classic_trapdoor"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("classic_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(CLASSIC_TRAPDOORS);

        COTTAGE_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "cottage_trapdoor",
                        getModBlock("oak_cottage_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks)) {}
                )
                .addTextureM(modRes("block/cottage/oak_cottage_trapdoor"),
                        EveryCompat.res("block/mcw/trapdoors/oak_cottage_trapdoor_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("cottage_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(COTTAGE_TRAPDOORS);

        FOUR_PANEL_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "four_panel_trapdoor",
                        getModBlock("oak_four_panel_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks)) {}
                )
                .addTexture(modRes("block/four_panel/oak_four_panel_trapdoor"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("four_panel_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(FOUR_PANEL_TRAPDOORS);

        GLASS_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "glass_trapdoor",
                        getModBlock("oak_glass_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTextureM(modRes("block/glass/oak_glass_trapdoor"),
                        EveryCompat.res("block/mcw/trapdoors/oak_glass_trapdoor_m"),
                        PaletteStrategies.PLANKS_REMOVE_DARKEST)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("glass_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(GLASS_TRAPDOORS);

        MESH_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "bamboo_trapdoor",
                        getModBlock("oak_bamboo_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTexture(modRes("block/bamboo/oak_bamboo_trapdoor"), PaletteStrategies.PLANKS_REMOVE_DARKEST)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("bamboo_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(MESH_TRAPDOORS);

        MYSTIC_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "mystic_trapdoor",
                        getModBlock("oak_mystic_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("mystic_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/mystic/oak_mystic_trapdoor"))
                .build();
        this.addEntry(MYSTIC_TRAPDOORS);

        PAPER_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "paper_trapdoor",
                        getModBlock("oak_paper_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks)) {}
                )
                .addTextureM(modRes("block/paper/oak_paper_trapdoor"),
                        EveryCompat.res("block/mcw/trapdoors/oak_paper_trapdoor_m"),
                        PaletteStrategies.PLANKS_REMOVE_DARKEST)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("paper_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(PAPER_TRAPDOORS);

        RANCH_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "ranch_trapdoor",
                        getModBlock("oak_ranch_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.log).method_22488()){}
                )
                .requiresChildren(STRIPPED_LOG) //REASON: textures
                //TEXTURES: log, stripped_log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("ranch_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(RANCH_TRAPDOORS);

        SWAMP_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "swamp_trapdoor",
                        getModBlock("oak_swamp_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTexture(modRes("block/swamp/oak_swamp_trapdoor"), PaletteStrategies.PLANKS_REMOVE_2_DARKEST)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("swamp_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(SWAMP_TRAPDOORS);

        TROPICAL_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "tropical_trapdoor",
                        getModBlock("oak_tropical_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTextureM(modRes("block/tropical/oak_tropical_trapdoor"),
                        EveryCompat.res("block/mcw/trapdoors/oak_tropical_trapdoor_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("tropical_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(TROPICAL_TRAPDOORS);

        WAFFLE_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "blossom_trapdoor",
                        getModBlock("oak_blossom_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTexture(modRes("block/blossom/oak_blossom_trapdoor"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("blossom_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(WAFFLE_TRAPDOORS);

        BARREL_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "barrel_trapdoor",
                        getModBlock("oak_barrel_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("barrel_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTextureM(modRes("block/barrel/oak_barrel_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_barrel_trapdoor_m"))
                .build();
        this.addEntry(BARREL_TRAPDOORS);

        WHISPERING_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "whispering_trapdoor",
                        getModBlock("oak_whispering_trapdoor"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(w.toVanillaOrOak().comp_1300(), Utils.copyPropertySafe(w.planks).method_22488()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("whispering_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTextureM(modRes("block/whispering/oak_whispering_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_whispering_trapdoor_m"))
                .build();
        this.addEntry(WHISPERING_TRAPDOORS);

    }
}
