package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.*;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.item.FuelBlockItem;
import vectorwing.farmersdelight.common.registry.ModItems;

import java.util.Objects;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.api.PaletteStrategies.registerCached;
import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.*;

// SUPPORT: FABRIC-v2.2.7+ | NEOFORGE-v1.2.6+
public class FarmersDelightModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> cabinets;

    public FarmersDelightModule(String modId) {
        super(modId, "fd", EveryCompat.MOD_ID);

        cabinets = SimpleEntrySet.builder(WoodType.class, "cabinet",
                        getModBlock("oak_cabinet"), () -> VanillaWoodTypes.OAK,
                        w -> new CabinetBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren(TRAPDOOR, SLAB) //REASON: recipes
                .addTile(getModTile("cabinet"))
                .addTextureM(modRes("block/oak_cabinet_front"),
                        EveryCompat.res("block/fd/oak_cabinet_front_m"),
                        customPalette)
                .addTexture(modRes("block/oak_cabinet_side"), customPalette)
                .addTexture(modRes("block/oak_cabinet_top"), customPalette)
                .addTexture(modRes("block/oak_cabinet_front_open"), customPalette)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("cabinets/wooden"), class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(modRes("farmersdelight"))
                .setTabMode(TabAddMode.AFTER_SAME_TYPE)
                .defaultRecipe()
                .addCustomItem((w, block, p) -> new FuelBlockItem(block, ModItems.basicItem(), 300))
                .build();
        this.addEntry(cabinets);
    }

    public static final PaletteStrategy customPalette = registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(
            blockType, manager, PLANKS, null, p -> {
                p.reduceDown();
                if (p.size() < 9) {
                    while (p.size() <= 9) {
                        p.increaseInner();
                    }
                } else {
                    while (p.size() >= 9) {
                        p.reduce();
                    }
                }
            })
    );

    @Override
    // RECIPES
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, sink) -> {
            // Creating cutting_board recipes
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;

                //adding compat cutting board recipes for vanilla modded stuff i guess
                createCuttingRecipe(DOOR, woodType.getBlockOfThis(DOOR),
                        woodType, sink, manager);
                createCuttingRecipe(HANGING_SIGN, woodType.getBlockOfThis(HANGING_SIGN),
                        woodType, sink, manager);
                createCuttingRecipe(SIGN, woodType.getBlockOfThis(SIGN),
                        woodType, sink, manager);
                createCuttingRecipe(TRAPDOOR, woodType.getBlockOfThis(TRAPDOOR),
                        woodType, sink, manager);
                createCuttingRecipe(LOG, woodType.getBlockOfThis(LOG),
                        woodType, sink, manager);
                createCuttingRecipe(WOOD, woodType.getBlockOfThis(WOOD),
                        woodType, sink, manager);

            }
        });
    }

    public void createCuttingRecipe(String recipeType, class_2248 input,
                                    WoodType targetType, ResourceSink sink, class_3300 manager) {

        if (Objects.isNull(input)) return;

        String recipeLocation = modRes("cutting/oak_" + recipeType).toString();
        class_1860<?> recipe = RPUtils.readRecipe(manager, recipeLocation);

        if (recipe instanceof CuttingBoardRecipe cr) {

            String path = this.shortenedId() + "/cutting/" + targetType.getAppendableId() + "_" + recipeType;

            class_2371<ChanceResult> oldResult = cr.getRollableResults();
            class_2371<ChanceResult> newResult = class_2371.method_10213(oldResult.size(), ChanceResult.EMPTY);
            for (int i = 0; i < oldResult.size(); i++) {
                ChanceResult r = oldResult.get(i);
                class_1792 critem = r.stack().getItem();
                WoodType originalType = WoodTypeRegistry.INSTANCE.getBlockTypeOf(critem);
                if (originalType == VanillaWoodTypes.OAK) {
                    class_1792 newItem = BlockSetAPI.changeItemType(critem, originalType, targetType);
                    if (newItem != null) {
                        newResult.set(i, new ChanceResult(r.stack().transmuteCopy(newItem), r.chance()));
                        continue;
                    }
                }
                newResult.set(i, r);
            }
            CuttingBoardRecipe newRec = new CuttingBoardRecipe(cr.getGroup(),
                    class_1856.method_8091(input), cr.getTool(), newResult, cr.getSoundEvent());

            class_2960 recipePath = EveryCompat.res(path);
            sink.addRecipe(new class_8786<>(recipePath, newRec));
        }
    }
}
