/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TagUtility {
    public static final class_2960 SILICA_TAG = TagUtility.platformTag("silica_glass", "silica");
    public static final class_2960 GLASS_TAG = TagUtility.platformTag("glass_blocks", "glass");
    public static final class_2960 GLASS_PANE_TAG = TagUtility.platformTag("glass_panes");

    public static class_2960 getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink sink, class_3300 manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        class_2960 RLocLogs = class_2960.method_60654((String)(resLocMOD + "_" + suffixTag));
        class_2960 RLocStems = class_2960.method_60654((String)(resLocMOD + "_" + suffixAlt));
        class_2960 RLocFolders = class_2960.method_60654((String)(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName()));
        class_2960 RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (TagUtility.doTagExistFor(RLocLogs, manager)) {
            return RLocLogs;
        }
        if (TagUtility.doTagExistFor(RLocStems, manager)) {
            return RLocStems;
        }
        if (TagUtility.doTagExistFor(RLocEC, manager)) {
            return RLocEC;
        }
        if (TagUtility.doTagExistFor(RLocFolders, manager)) {
            return RLocFolders;
        }
        TagUtility.createAndAddDefaultTags(RLocEC, sink, blockType, new class_2248[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(class_2960 resLoc, ResourceSink sink, BlockType blockType, class_2248 ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return TagUtility.createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return TagUtility.createAndAddCustomTags(resLoc, sink, blocks);
    }

    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_2248 ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)resLoc);
        for (class_2248 block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41254);
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_1792 ... items) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)resLoc);
        for (class_1792 item : items) {
            if (item == null) continue;
            tagBuilder.addEntry((Object)item);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, String tag, boolean includeBlock, boolean includeItem, ResourceSink pack) {
        TagUtility.addTagToAllBlocks(blocks, nameStone, modId, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)tag)), includeBlock, includeItem, pack);
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, class_6862<class_2248> tag, boolean includeBlock, boolean includeItem, ResourceSink pack) {
        TagUtility.addTagToAllBlocks(blocks, nameStone, modId, tag, includeBlock, includeItem, pack, null);
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, class_6862<class_2248> tag, boolean includeBlock, boolean includeItem, ResourceSink pack, @Nullable String regexBlockId) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                String blockPath = Utils.getID((class_2248)block).method_12832();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!stoneType.getTypeName().equals(nameStone) || regexBlockId != null && !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, class_7924.field_41254);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, class_7924.field_41197);
                }
            }
        }
    }

    public static Pair<class_2960, Boolean> getATagId(String idTag, String idAlt, class_3300 manager) {
        class_2960 RLocId = class_2960.method_60654((String)idTag);
        class_2960 RLocIdAlt = class_2960.method_60654((String)idAlt);
        if (TagUtility.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (TagUtility.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(class_2960 resLoc, class_3300 manager) {
        boolean blockTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("blocks/"))).isPresent();
        boolean itemTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static class_2960 platformTag(String tagPath) {
        return TagUtility.platformTag(tagPath, tagPath);
    }

    public static class_2960 platformTag(String fabric, String neoforge) {
        return PlatHelper.getPlatform().isFabric() ? TagUtility.fabricTag(fabric) : TagUtility.neoforgeTag(neoforge);
    }

    public static class_2960 fabricTag(String tagPath) {
        return class_2960.method_60655((String)"c", (String)tagPath);
    }

    public static class_2960 neoforgeTag(String tagPath) {
        return class_2960.method_60655((String)"neoforge", (String)tagPath);
    }
}

