/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

public class ResourcesUtils {
    private static final JsonObject DUMMY_BLOCKSTATE = new JsonObject();
    protected static final String RES_CHARS = "[a-z,A-Z,\\-,_./]*";
    protected static final Pattern RES_PATTERN;
    private static final Map<String, String> mapOfItem;

    public static <B extends class_2248, T extends BlockType> void generateStandardBlockFiles(class_3300 manager, ResourceSink sink, Map<T, B> blocks, T baseType, BlockTypeResTransformer<T> modelTransformer, BlockTypeResTransformer<T> blockStateTransformer, ModelConfiguration modelConfig) {
        if (blocks.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)blocks.entrySet().stream().findFirst().get();
        class_2248 baseBlock = BlockType.changeBlockType((class_2248)((class_2248)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        if (baseBlock == null) {
            EveryCompat.LOGGER.error("Skipped generating some block assets because oakBlock is null for {}", (Object)Utils.getID((class_2248)((class_2248)first.getValue())));
            return;
        }
        class_2960 baseId = Utils.getID((class_2248)baseBlock);
        HashSet<String> modelsLoc = new HashSet<String>();
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(baseId));
            JsonObject insideBlockstates = RPUtils.deserializeJson((InputStream)new ByteArrayInputStream(oakBlockstate.data));
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)insideBlockstates, s -> s.equals("model")));
            List<StaticResource> oakBlockModels = ResourcesUtils.gatherNonVanillaModels(manager, modelsLoc, modelConfig);
            blocks.forEach((blockType, block) -> {
                class_2960 blockId = Utils.getID((class_2248)block);
                try {
                    StaticResource newBlockState = blockStateTransformer.transform(oakBlockstate, blockId, blockType);
                    Preconditions.checkArgument((newBlockState.location != oakBlockstate.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newBlockState.location)));
                    sink.addResourceIfNotPresent(manager, newBlockState);
                    for (StaticResource model : oakBlockModels) {
                        try {
                            StaticResource newModel = modelTransformer.transform(model, blockId, blockType);
                            Preconditions.checkArgument((newModel.location != model.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newModel.location)));
                            sink.addResourceIfNotPresent(manager, newModel);
                        }
                        catch (Exception e) {
                            EveryCompat.LOGGER.error("Failed to add {}'s models/block file: {}", (Object)Utils.getID((class_2248)block), (Object)e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {}'s blockstate file: {}", block, (Object)e.getMessage());
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find blockstate definition for {}", (Object)baseId);
        }
    }

    private static List<StaticResource> gatherNonVanillaModels(class_3300 manager, Set<String> modelsLoc, ModelConfiguration modelConfig) {
        ArrayList<StaticResource> models = new ArrayList<StaticResource>();
        for (String m : modelsLoc) {
            StaticResource model;
            class_2960 modelRes = class_2960.method_60654((String)m);
            if (modelRes.method_12836().equals("minecraft") && !modelConfig.blockModel().contains(modelRes) && !modelConfig.itemModel().contains(modelRes) || !Objects.nonNull(model = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.MODELS.getPath(m)))) continue;
            models.add(model);
        }
        if (modelConfig.includeInGeneration()) {
            for (class_2960 currentModel : modelConfig.blockModel()) {
                StaticResource model = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.MODELS.getPath(currentModel));
                if (!Objects.nonNull(model)) continue;
                models.add(model);
            }
        }
        return models;
    }

    public static <I extends class_1792, T extends BlockType> void generateStandardItemModels(class_3300 manager, ResourceSink sink, Map<T, I> items, T baseType, BlockTypeResTransformer<T> itemModelTransformer, ModelConfiguration modelConfig) {
        if (items.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)items.entrySet().stream().findFirst().get();
        class_1792 oakItem = BlockType.changeItemType((class_1792)((class_1792)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        if (oakItem == null) {
            EveryCompat.LOGGER.error("Skipped generating some item assets because oakItem is NULL for {}", (Object)Utils.getID((class_1792)((class_1792)first.getValue())));
            return;
        }
        String baseItemName = baseType.getTypeName();
        HashSet<String> modelsLoc = new HashSet<String>();
        try {
            String parent;
            StaticResource oakItemModel = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Utils.getID((class_1792)oakItem)));
            JsonObject json = RPUtils.deserializeJson((InputStream)new ByteArrayInputStream(oakItemModel.data));
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
            if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                itemModelTransformer.replaceItemType(baseItemName);
            }
            items.forEach((blockType, item) -> {
                class_2960 id = Utils.getID((class_1792)item);
                try {
                    StaticResource newRes = itemModelTransformer.transform(oakItemModel, id, blockType);
                    Preconditions.checkArgument((newRes.location != oakItemModel.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newRes.location)));
                    sink.addResourceIfNotPresent(manager, newRes);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} item model json file:", item, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakItem);
        }
        List<StaticResource> oakItemModels = ResourcesUtils.gatherNonVanillaModels(manager, modelsLoc, modelConfig);
        items.forEach((w, b) -> {
            class_2960 id = Utils.getID((class_1792)b);
            for (StaticResource model : oakItemModels) {
                try {
                    StaticResource newModel = itemModelTransformer.transform(model, id, w);
                    assert (newModel.location != model.location) : "ids cant be the same";
                    sink.addResourceIfNotPresent(manager, newModel);
                }
                catch (Exception exception) {
                    EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                }
            }
        });
    }

    @NotNull
    public static <T extends BlockType> BlockTypeResTransformer<T> addBuiltinModelTransformer(BlockTypeResTransformer<T> transformer, T baseType) {
        String oldTypeName = baseType.getTypeName();
        transformer.setIDModifier((text, id, w) -> BlockTypeResTransformer.replaceFullGenericType((String)text, (BlockType)w, (class_2960)id, (String)oldTypeName, null, (int)2));
        if (baseType instanceof LeavesType) {
            LeavesType leavesType = (LeavesType)baseType;
            CompatSpritesHelper.replaceLeavesTextures(transformer, leavesType);
            WoodType woodT = leavesType.getAssociatedWoodType();
            if (woodT != null) {
                CompatSpritesHelper.replaceWoodTextures(transformer, woodT);
            }
        } else if (baseType instanceof WoodType) {
            WoodType woodType = (WoodType)baseType;
            CompatSpritesHelper.replaceWoodTextures(transformer, woodType);
        }
        transformer.replaceGenericType(oldTypeName, "block");
        return transformer;
    }

    public static <B extends class_2248, T extends BlockType> void addBlockResources(class_3300 manager, ResourceSink sink, Map<T, B> blocks, BlockTypeResTransformer<T> modifier, class_2960 ... jsonsLocations) {
        List<StaticResource> original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog((class_3300)manager, (class_2960)s)).toList();
        blocks.forEach((wood, value) -> {
            if (ModEntriesConfigs.isEntryEnabled(wood, value)) {
                for (StaticResource res : original) {
                    try {
                        StaticResource newRes = modifier.transform(res, Utils.getID((class_2248)value), wood);
                        Preconditions.checkArgument((newRes.location != res.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newRes.location)));
                        sink.addResource(newRes);
                    }
                    catch (Exception e) {
                        if (res == null) continue;
                        EveryCompat.LOGGER.error("Failed to generate json resource from {}", (Object)res.location);
                    }
                }
            }
        });
    }

    public static void addLeavesRecipes(String modId, class_3300 manager, ResourceSink pack, Map<LeavesType, class_1792> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, VanillaLeavesTypes.OAK);
    }

    public static <B extends class_1792> void addWoodRecipes(String modId, class_3300 manager, ResourceSink pack, Map<WoodType, B> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, VanillaWoodTypes.OAK);
    }

    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(String modId, class_3300 manager, ResourceSink pack, Map<T, B> blocks, String oakRecipe, T fromType) {
        ResourcesUtils.addBlocksRecipes(manager, pack, blocks, class_2960.method_60655((String)modId, (String)oakRecipe), fromType, 0);
    }

    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(class_3300 manager, ResourceSink pack, Map<T, B> items, class_2960 oakRecipe, T fromType, int index) {
        class_1860 template = RPUtils.readRecipe((class_3300)manager, (class_2960)oakRecipe);
        items.forEach((w, i) -> {
            if (ModEntriesConfigs.isEntryEnabled(w, i)) {
                try {
                    class_2960 id = class_5797.method_36442((class_1935)i);
                    if (index != 0) {
                        id = id.method_48331("_" + index);
                    }
                    class_8786 newR = RPUtils.makeSimilarRecipe((class_1860)template, (BlockType)fromType, (BlockType)w, (class_2960)id);
                    pack.addRecipe(newR);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate recipe @ {} for {}: {}", (Object)oakRecipe, i, (Object)e.getMessage());
                }
            }
        });
    }

    public static <T extends BlockType> class_1856 convertIngredient(class_1856 ingredient, T originalMat, T destinationMat) {
        class_1856 newIng = ingredient;
        for (class_1799 in : ingredient.method_8105()) {
            class_1792 i;
            class_1792 it = in.method_7909();
            if (it == class_1802.field_8077 || (i = BlockType.changeItemType((class_1792)it, originalMat, destinationMat)) == null) continue;
            newIng = class_1856.method_8091((class_1935[])new class_1935[]{i});
            break;
        }
        return newIng;
    }

    public static String convertItemIDinText(String text, BlockType fromType, BlockType toType) {
        Matcher matcher = RES_PATTERN.matcher(text);
        return matcher.replaceAll(m -> {
            Optional item = class_7923.field_41178.method_17966(class_2960.method_12829((String)m.group(1)));
            return item.map(value -> mapOfItem.getOrDefault(((class_1792)item.get()).toString(), "\"" + Utils.getID((class_1792)BlockType.changeItemType((class_1792)value, (BlockType)fromType, (BlockType)toType)).toString() + "\"")).orElseGet(() -> m.group(0));
        });
    }

    static {
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", (JsonElement)t);
        RES_PATTERN = Pattern.compile("\"([a-z,A-Z,\\-,_./]*:[a-z,A-Z,\\-,_./]*)\"");
        mapOfItem = Map.ofEntries(Map.entry("shulker_box", "\"minecraft:shulker_box\""), Map.entry("book", "\"minecraft:book\""), Map.entry("white_upholstery", "\"redeco:white_upholstery\""), Map.entry("light_gray_upholstery", "\"redeco:light_gray_upholstery\""), Map.entry("gray_upholstery", "\"redeco:gray_upholstery\""), Map.entry("black_upholstery", "\"redeco:black_upholstery\""), Map.entry("lime_upholstery", "\"redeco:lime_upholstery\""), Map.entry("green_upholstery", "\"redeco:green_upholstery\""), Map.entry("cyan_upholstery", "\"redeco:cyan_upholstery\""), Map.entry("blue_upholstery", "\"redeco:blue_upholstery\""), Map.entry("light_blue_upholstery", "\"redeco:light_blue_upholstery\""), Map.entry("purple_upholstery", "\"redeco:purple_upholstery\""), Map.entry("magenta_upholstery", "\"redeco:magenta_upholstery\""), Map.entry("pink_upholstery", "\"redeco:pink_upholstery\""), Map.entry("orange_upholstery", "\"redeco:orange_upholstery\""), Map.entry("yellow_upholstery", "\"redeco:yellow_upholstery\""), Map.entry("brown_upholstery", "\"redeco:brown_upholstery\""));
    }
}

