/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.quark;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.ECPlatformStuff;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.modules.botanypots.BotanyPotsHelper;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlock;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.quark.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.modules.quark.CompatTrappedChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.quark.QuarkSimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_3962;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_756;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.building.block.HedgeBlock;
import org.violetmoon.quark.content.building.block.HollowLogBlock;
import org.violetmoon.quark.content.building.block.LeafCarpetBlock;
import org.violetmoon.quark.content.building.block.VariantBookshelfBlock;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.content.building.block.VariantLadderBlock;
import org.violetmoon.quark.content.building.block.VariantTrappedChestBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.quark.content.building.block.WoodPostBlock;
import org.violetmoon.quark.content.building.client.render.be.VariantChestRenderer;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.building.module.LeafCarpetModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.building.module.VariantLaddersModule;
import org.violetmoon.quark.content.building.module.VerticalPlanksModule;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.building.module.WoodenPostsModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.client.SimpleWithoutLevelRenderer;

public class QuarkModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, class_2248> verticalSlabs;
    public final SimpleEntrySet<WoodType, class_2248> bookshelves;
    public final SimpleEntrySet<WoodType, class_2248> posts;
    public final SimpleEntrySet<WoodType, class_2248> strippedPosts;
    public final SimpleEntrySet<WoodType, class_2248> verticalPlanks;
    public final SimpleEntrySet<WoodType, class_2248> ladders;
    public final SimpleEntrySet<WoodType, class_2248> hollowLogs;
    public final SimpleEntrySet<WoodType, VariantChestBlock> chests;
    public final SimpleEntrySet<WoodType, VariantTrappedChestBlock> trappedChests;
    public final SimpleEntrySet<LeavesType, class_2248> hedges;
    public final SimpleEntrySet<LeavesType, class_2248> leafCarpets;
    public static class_2591<class_2595> CHEST_TILE;
    public static class_2591<class_2595> TRAPPED_CHEST_TILE;
    public static final PaletteStrategy bookshelfPalette;

    public QuarkModule(String modId) {
        super(modId, "q", "everycomp");
        class_5321 tab = class_7706.field_40195;
        this.verticalSlabs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "vertical_slab", VerticalSlabsModule.class, this.getModBlock("oak_vertical_slab"), () -> VanillaWoodTypes.OAK, w -> new VerticalSlabBlock(() -> w.getBlockOfThis("slab"), Utils.copyPropertySafe((class_2248)Objects.requireNonNull(w.getBlockOfThis("slab"))).method_9626(w.getSound()))).requiresChildren(new String[]{"slab"})).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("wooden_vertical_slabs"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTag(this.modRes("vertical_slabs"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTag(this.modRes("vertical_slab"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/vertslabs/oak_vertical_slab"))).addRecipe(this.modRes("building/crafting/vertslabs/oak_vertical_slab_revert"))).addCondition(woodType -> !PlatHelper.isModLoaded((String)"v_slab_compat"))).copyParentDrop().build();
        this.addEntry(this.verticalSlabs);
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "bookshelf", VariantBookshelvesModule.class, this.getModBlock("acacia_bookshelf"), () -> VanillaWoodTypes.ACACIA, w -> new VariantBookshelfBlock(this.shortenedId() + "/" + w.getAppendableId(), null, w.canBurn(), w.getSound())).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"), bookshelfPalette)).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(class_2960.method_60654((String)"c:bookshelves"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/acacia_bookshelf"))).copyParentDrop().build();
        this.addEntry(this.bookshelves);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", WoodenPostsModule.class, this.getModBlock("oak_post"), () -> VanillaWoodTypes.OAK, w -> {
            class_2248 fence = w.getBlockOfThis("fence");
            return new WoodPostBlock(null, Objects.requireNonNull(fence), this.shortenedId() + "/" + w.getNamespace() + "/", Objects.requireNonNull(fence).method_9564().method_26231());
        }).requiresChildren(new String[]{"fence", "wood"})).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("posts"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/oak_post"))).setRenderType(RenderLayer.CUTOUT).build();
        this.addEntry(this.posts);
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", "stripped", WoodenPostsModule.class, this.getModBlock("stripped_oak_post"), () -> VanillaWoodTypes.OAK, w -> {
            if (w.getNamespace().equals("malum") || w.getNamespace().equals("twigs")) {
                return null;
            }
            class_2248 fence = w.getBlockOfThis("fence");
            return new WoodPostBlock(null, Objects.requireNonNull(fence), this.shortenedId() + "/" + w.getNamespace() + "/stripped_", Objects.requireNonNull(fence).method_9564().method_26231());
        }).requiresChildren(new String[]{"fence", "stripped_log", "stripped_wood"})).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("posts"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/stripped_oak_post"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.strippedPosts);
        this.verticalPlanks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "planks", "vertical", VerticalPlanksModule.class, this.getModBlock("vertical_oak_planks"), () -> VanillaWoodTypes.OAK, w -> {
            String name = this.shortenedId() + "/" + w.getVariantId("planks", "vertical");
            return new ZetaBlock(name, null, class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_50013().method_51368(class_2766.field_12651).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547));
        }).addCondition(w -> !w.getId().toString().equals("gardens_of_the_dead:whistle_planks"))).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(class_3481.field_15471, new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addRecipe(this.modRes("building/crafting/vertplanks/vertical_oak_planks"))).build();
        this.addEntry(this.verticalPlanks);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "ladder", VariantLaddersModule.class, this.getModBlock("spruce_ladder"), () -> VanillaWoodTypes.SPRUCE, w -> new VariantLadderBlock(this.shortenedId() + "/" + w.getAppendableId(), null, Utils.copyPropertySafe((class_2248)class_2246.field_9983).method_9626(w.getSound()), w.canBurn())).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(class_3481.field_22414, class_7924.field_41254)).addTag(this.modRes("ladders"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTexture(EveryCompat.res("block/spruce_ladder"))).addRecipe(this.modRes("building/crafting/spruce_ladder"))).setRenderType(RenderLayer.TRANSLUCENT).build();
        this.addEntry(this.ladders);
        this.hollowLogs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "log", "hollow", HollowLogsModule.class, this.getModBlock("hollow_oak_log"), () -> VanillaWoodTypes.OAK, w -> new HollowLogBlock(this.shortenedId() + "/" + w.getAppendableId(), w.log, null, w.canBurn())).requiresChildren(new String[]{"stripped_log"})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("hollow_logs"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addRecipe(this.modRes("building/crafting/hollowlogs/hollow_oak_log"))).build();
        this.addEntry(this.hollowLogs);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "chest", VariantChestsModule.class, this.getModBlock("oak_chest", VariantChestBlock.class), () -> VanillaWoodTypes.OAK, w -> new CompatChestBlock((WoodType)w, this.shortenedId() + "/" + w.getAppendableId(), Utils.copyPropertySafe((class_2248)class_2246.field_10034))).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(class_2960.method_60654((String)"c:chests/wooden"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTag(this.modRes("revertable_chests"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTag(class_3481.field_33713, class_7924.field_41254)).addTile(CompatChestBlockTile::new).excludeBlockTypes("twilightforest", new String[]{"dark"})).addRecipe(this.modRes("building/crafting/chests/oak_chest"))).build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "trapped_chest", VariantChestsModule.class, this.getModBlock("oak_trapped_chest", VariantTrappedChestBlock.class), () -> VanillaWoodTypes.OAK, w -> {
            boolean isNamespaceLoaded;
            boolean bl = isNamespaceLoaded = w.getNamespace().equals("twilightforest") || w.getNamespace().equals("blue_skies");
            if (!this.chests.blocks.containsKey(w) && !isNamespaceLoaded) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatTrappedChestBlock((WoodType)w, name, Utils.copyPropertySafe((class_2248)class_2246.field_10380));
        }).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(class_2960.method_60654((String)"forge:chests/trapped"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTag(class_2960.method_60654((String)"forge:chests/wooden"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).addTag(this.modRes("revertable_trapped_chests"), class_7924.field_41197)).addTag(class_3481.field_33713, class_7924.field_41254)).addTile(CompatTrappedChestBlockTile::new).addRecipe(this.modRes("building/crafting/chests/oak_trapped_chest"))).build();
        this.addEntry(this.trappedChests);
        this.hedges = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "hedge", HedgesModule.class, this.getModBlock("oak_hedge"), () -> LeavesTypeRegistry.OAK_TYPE, leavesType -> new HedgeBlock("", null, class_2246.field_10620, leavesType.leaves)).requiresChildren(new String[]{"log"})).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", CompatSpritesHelper.LOOKS_LIKE_LEAF_TEXTURE))).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("hedges"), new class_5321[]{class_7924.field_41254, class_7924.field_41197})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).copyParentTint()).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.hedges);
        this.leafCarpets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "leaf_carpet", LeafCarpetModule.class, this.getModBlock("oak_leaf_carpet"), () -> VanillaLeavesTypes.OAK, leavesType -> {
            String name = this.shortenedId() + "/" + leavesType.getVariantId("%s_leaf_carpet");
            return new LeafCarpetBlock(name, leavesType.leaves, null);
        }).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))).addTag(class_3481.field_33714, class_7924.field_41254)).addTag(class_2960.method_60654((String)"forge:mineable/sickle"), class_7924.field_41254)).addTag(class_2960.method_60654((String)"mynethersdelight:resurgent_soil_plant"), class_7924.field_41254)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/oak_leaf_carpet"))).setRenderType(RenderLayer.CUTOUT_MIPPED).copyParentTint()).build();
        this.addEntry(this.leafCarpets);
    }

    @Override
    public void onModSetup() {
        this.posts.blocks.forEach((w, post) -> {
            class_2248 stripped = (class_2248)this.strippedPosts.blocks.get(w);
            if (stripped != null) {
                ECPlatformStuff.registerStripping(post, stripped);
            }
        });
        this.leafCarpets.blocks.forEach((w, leaf) -> class_3962.field_17566.put(leaf, 0.2f));
    }

    @Override
    public void registerTiles(Registrator<class_2591<?>> registry) {
        super.registerTiles(registry);
        CHEST_TILE = this.chests.getTile(class_2595.class);
        TRAPPED_CHEST_TILE = this.trappedChests.getTile(class_2595.class);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClientSetup() {
        super.onClientSetup();
        QuarkClientModule.initClient(this);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        event.register(CHEST_TILE, context -> new VariantChestRenderer(context, false));
        event.register(TRAPPED_CHEST_TILE, context -> new VariantChestRenderer(context, true));
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept(this::generateChestTextures);
    }

    private void generateChestTextures(class_3300 manager, ResourceSink handler) {
        try (TextureImage normal = TextureImage.open((class_3300)manager, (class_2960)this.modRes("quark_variant_chests/oak/normal"));
             TextureImage normal_m = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/oak_chest_normal_m"));
             TextureImage normal_o = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/oak_chest_normal_o"));
             TextureImage left = TextureImage.open((class_3300)manager, (class_2960)this.modRes("quark_variant_chests/oak/left"));
             TextureImage left_m = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/oak_chest_left_m"));
             TextureImage left_o = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/oak_chest_left_o"));
             TextureImage right = TextureImage.open((class_3300)manager, (class_2960)this.modRes("quark_variant_chests/oak/right"));
             TextureImage right_m = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/oak_chest_right_m"));
             TextureImage right_o = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/oak_chest_right_o"));
             TextureImage left_t = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/trapped_chest_left"));
             TextureImage right_t = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/trapped_chest_right"));
             TextureImage normal_t = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("model/trapped_chest_normal"));){
            Respriter respriterNormal = Respriter.masked((TextureImage)normal, (TextureImage)normal_m);
            Respriter respriterLeft = Respriter.masked((TextureImage)left, (TextureImage)left_m);
            Respriter respriterRight = Respriter.masked((TextureImage)right, (TextureImage)right_m);
            Respriter respriterNormalO = Respriter.of((TextureImage)normal_o);
            Respriter respriterLeftO = Respriter.of((TextureImage)left_o);
            Respriter respriterRightO = Respriter.of((TextureImage)right_o);
            this.trappedChests.blocks.forEach((wood, block) -> {
                CompatTrappedChestBlock b = (CompatTrappedChestBlock)((Object)block);
                try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                    class_2960 trappedRes;
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    McMetaFile meta = plankTexture.getMcMeta();
                    ArrayList<Palette> overlayPalette = new ArrayList<Palette>();
                    for (Palette p : targetPalette) {
                        PaletteColor d1 = p.getDarkest();
                        p.remove(d1);
                        PaletteColor d2 = p.getDarkest();
                        p.remove(d2);
                        HCLColor n1 = new HCLColor(d1.hcl().hue(), d1.hcl().chroma() * 0.75f, d1.hcl().luminance() * 0.4f, d1.hcl().alpha());
                        HCLColor n2 = new HCLColor(d2.hcl().hue(), d2.hcl().chroma() * 0.75f, d2.hcl().luminance() * 0.6f, d2.hcl().alpha());
                        Palette pal = Palette.ofColors(List.of(n1, n2));
                        overlayPalette.add(pal);
                    }
                    class_2960 res = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/normal");
                    if (!handler.alreadyHasTextureAtLocation(manager, res)) {
                        trappedRes = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/trap");
                        this.createChestTextures(handler, normal_t, respriterNormal, respriterNormalO, meta, targetPalette, (List<Palette>)overlayPalette, res, trappedRes, (WoodType)wood);
                    }
                    if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/left"))) {
                        trappedRes = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/trap_left");
                        this.createChestTextures(handler, left_t, respriterLeft, respriterLeftO, meta, targetPalette, (List<Palette>)overlayPalette, res, trappedRes, (WoodType)wood);
                    }
                    if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/right"))) {
                        trappedRes = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/trap_right");
                        this.createChestTextures(handler, right_t, respriterRight, respriterRightO, meta, targetPalette, (List<Palette>)overlayPalette, res, trappedRes, (WoodType)wood);
                    }
                }
                catch (Exception ex) {
                    EveryCompat.LOGGER.error("Failed to generate Chest block texture for for {} : {}", (Object)b, (Object)ex);
                }
            });
        }
        catch (Exception ex) {
            EveryCompat.LOGGER.error("Could not generate any Chest block texture : ", (Throwable)ex);
        }
    }

    private void createChestTextures(ResourceSink sink, TextureImage trappedOverlay, Respriter respriterLeft, Respriter respriterLeftO, McMetaFile baseMeta, List<Palette> basePalette, List<Palette> overlayPalette, class_2960 res, class_2960 trappedRes, WoodType wood) {
        try (TextureImage recoloredBase = respriterLeft.recolorWithAnimation(basePalette, baseMeta);
             TextureImage recoloredOverlay = respriterLeftO.recolorWithAnimation(overlayPalette, baseMeta);){
            TextureOps.applyOverlay((TextureImage)recoloredBase, (TextureImage[])new TextureImage[]{recoloredOverlay});
            try (TextureImage trapped = recoloredBase.makeCopy();){
                if (!wood.getNamespace().equals("blue_skies") || wood.getNamespace().equals("blue_skies") && wood.getTypeName().equals("crystallized")) {
                    sink.addTexture(res, recoloredBase);
                }
                TextureOps.applyOverlay((TextureImage)trapped, (TextureImage[])new TextureImage[]{trappedOverlay});
                sink.addTexture(trappedRes, trapped);
            }
        }
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            if (PlatHelper.isModLoaded((String)"botanypots")) {
                this.hedges.items.forEach((leaves, item) -> {
                    class_1792 leavesItem = leaves.leaves.method_8389();
                    BotanyPotsHelper.cropQuarkHedgeRecipe(this, item, leavesItem, handler, manager, leaves);
                });
            }
            for (Map.Entry entry : this.hedges.blocks.entrySet()) {
                LeavesType leavesType = (LeavesType)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                if (block == null) continue;
                this.generalHedgeRecipe(leavesType, block, handler, manager);
            }
        });
    }

    public void generalHedgeRecipe(LeavesType leavesType, class_2248 block, ResourceSink handler, class_3300 manager) {
        class_2960 recipeLoc = this.modRes("recipes/building/crafting/oak_hedge.json");
        try (InputStream recipeStream = ((class_3298)manager.method_14486(recipeLoc).orElseThrow(() -> new FileNotFoundException("Failed to open recipe @ " + String.valueOf(recipeLoc)))).method_14482();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject underKey = recipe.getAsJsonObject("key");
            JsonObject underResult = recipe.getAsJsonObject("result");
            underKey.getAsJsonObject("L").addProperty("item", Utils.getID((class_2248)leavesType.leaves).toString());
            underKey.getAsJsonObject("W").addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", (BlockType)Objects.requireNonNull(leavesType.getAssociatedWoodType()), handler, manager).toString());
            underResult.addProperty("item", Utils.getID((class_2248)block).toString());
            String path = this.shortenedId() + "/" + leavesType.getNamespace() + "/";
            handler.addJson(EveryCompat.res(path + leavesType.getTypeName() + "_hedge"), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to open the recipe file @ {} : {}", (Object)recipeLoc, (Object)e);
        }
    }

    static {
        bookshelfPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
            PaletteColor l0 = p.getDarkest();
            p.increaseDown();
            p.increaseDown();
            p.increaseDown();
            p.increaseDown();
            p.remove(l0);
        }));
    }

    @Environment(value=EnvType.CLIENT)
    public static class QuarkClientModule {
        private static void initClient(QuarkModule module) {
            for (VariantChestBlock b : module.chests.blocks.values()) {
                QuarkClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.asItem(), (class_756)new SimpleWithoutLevelRenderer(CHEST_TILE, b.defaultBlockState()));
            }
            for (VariantChestBlock b : module.trappedChests.blocks.values()) {
                QuarkClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.asItem(), (class_756)new SimpleWithoutLevelRenderer(TRAPPED_CHEST_TILE, b.defaultBlockState()));
            }
        }
    }
}

