package net.mehvahdjukaar.every_compat.common_classes;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_826;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

@Environment(EnvType.CLIENT)
public class CompatChestBlockRenderer extends class_826<CompatChestBlockEntity> {
    public static final class_2960 CHEST_SHEET = class_2960.method_60656("textures/atlas/chest.png");
    private final Map<WoodType, class_4730> single = new HashMap<>();
    private final Map<WoodType, class_4730> left = new HashMap<>();
    private final Map<WoodType, class_4730> right = new HashMap<>();
    private final Map<WoodType, class_4730> trapped = new HashMap<>();
    private final Map<WoodType, class_4730> trapped_left = new HashMap<>();
    private final Map<WoodType, class_4730> trapped_right = new HashMap<>();

    //assumes standard naming here. Generalize if needed
    public CompatChestBlockRenderer(class_5614.class_5615 context, String shortenedId) {
        super(context);
        for (WoodType w : WoodTypeRegistry.getTypes()) {
            if (HardcodedBlockType.isKnownVanillaWood(w)) continue; // minecraft:pale_oak is from Perfect Parity: The Garden Awakens Edition
            String path = "entity/chest/" + shortenedId + "/" + w.getAppendableId() + "_chest";
            String trapped_path = "entity/chest/" + shortenedId + "/" + w.getAppendableId() + "_trapped_chest";

            single.put(w, new class_4730(CHEST_SHEET, EveryCompat.res(path)));
            left.put(w, new class_4730(CHEST_SHEET, EveryCompat.res(path + "_left")));
            right.put(w, new class_4730(CHEST_SHEET, EveryCompat.res(path + "_right")));
            trapped.put(w, new class_4730(CHEST_SHEET, EveryCompat.res(trapped_path)));
            trapped_left.put(w, new class_4730(CHEST_SHEET, EveryCompat.res(trapped_path + "_left")));
            trapped_right.put(w, new class_4730(CHEST_SHEET, EveryCompat.res(trapped_path + "_right")));
        }
    }

    protected @NotNull class_4730 getMaterial(CompatChestBlockEntity blockEntity, class_2745 chestType) {
        WoodType w = blockEntity.getWoodType();
        if (blockEntity.isTrapped()) {
            return switch (chestType) {
                case field_12574 -> trapped_left.get(w);
                case field_12571 -> trapped_right.get(w);
                default -> trapped.get(w);
            };
        } else {
            return switch (chestType) {
                case field_12574 -> left.get(w);
                case field_12571 -> right.get(w);
                default -> single.get(w);
            };
        }
    }


    //copy pasted from ChestRenderer

    @Override
    public void render(CompatChestBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_1937 level = blockEntity.method_10997();
        boolean flag = level != null;
        class_2680 blockstate = flag ? blockEntity.method_11010() : class_2246.field_10034.method_9564().method_11657(class_2281.field_10768, class_2350.field_11035);
        class_2745 chesttype = blockstate.method_28498(class_2281.field_10770) ? blockstate.method_11654(class_2281.field_10770) : class_2745.field_12569;
        class_2248 flag1 = blockstate.method_26204();
        if (flag1 instanceof class_4739<?> abstractchestblock) {
            boolean flag1x = chesttype != class_2745.field_12569;
            poseStack.method_22903();
            float f = (blockstate.method_11654(class_2281.field_10768)).method_10144();
            poseStack.method_46416(0.5F, 0.5F, 0.5F);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
            poseStack.method_46416(-0.5F, -0.5F, -0.5F);
            class_4732.class_4734<? extends class_2595> neighborcombineresult;
            if (flag) {
                neighborcombineresult = abstractchestblock.method_24167(blockstate, level, blockEntity.method_11016(), true);
            } else {
                neighborcombineresult = class_4732.class_3923::method_24174;
            }

            float f1 = neighborcombineresult.apply(class_2281.method_24166(blockEntity)).get(partialTick);
            f1 = 1.0F - f1;
            f1 = 1.0F - f1 * f1 * f1;
            int i = neighborcombineresult.apply(new class_4737<>()).applyAsInt(packedLight);
            class_4730 material = this.getMaterial(blockEntity, chesttype);
            class_4588 vertexconsumer = material.method_24145(buffer, class_1921::method_23576);
            if (flag1x) {
                if (chesttype == class_2745.field_12574) {
                    this.method_22749(poseStack, vertexconsumer, this.field_20820, this.field_20822, this.field_20821, f1, i, packedOverlay);
                } else {
                    this.method_22749(poseStack, vertexconsumer, this.field_21479, this.field_21481, this.field_21480, f1, i, packedOverlay);
                }
            } else {
                this.method_22749(poseStack, vertexconsumer, this.field_20817, this.field_20819, this.field_20818, f1, i, packedOverlay);
            }

            poseStack.method_22909();
        }
    }
    private void method_22749(class_4587 poseStack, class_4588 consumer, class_630 lidPart, class_630 lockPart, class_630 bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lidPart.field_3654 = -(lidAngle * 1.5707964F);
        lockPart.field_3654 = lidPart.field_3654;
        lidPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        lockPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
    }

    public static void register(ClientHelper.BlockEntityRendererEvent event, class_2591<CompatChestBlockEntity> tile, String s) {
        event.register(tile, c -> new CompatChestBlockRenderer(c, s));
    }

}
