package net.mehvahdjukaar.every_compat.misc;

import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5489;

public class ErrorMessageScreen extends class_437 {
    private final class_437 lastScreen;
    private final class_2561 text;
    private int ticksUntilEnable;
    private class_5489 message;

    private class_4185 exitButton;

    public ErrorMessageScreen(class_437 screen, int ticksUntilEnable,
                              class_2561 title, class_2561 text) {
        super(title);
        this.message = class_5489.field_26528;
        this.lastScreen = screen;
        this.ticksUntilEnable = ticksUntilEnable;
        this.text = text;
    }

    @Override
    public @NotNull class_2561 method_25435() {
        return class_5244.method_37111(super.method_25435(), text);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.exitButton = this.method_37063(class_4185.method_46430(class_2561.method_43471("menu.quit"), (pressed) -> {
            method_25419();
        }).method_46434((this.field_22789 - 150) / 2, this.field_22790 * 5 / 6, 150, 20).method_46431());
        this.exitButton.field_22763 = false;

        this.message = class_5489.method_30890(this.field_22793, text, this.field_22789 - 50);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 30, 16777215);
        this.message.method_30888(graphics, this.field_22789 / 2, 55);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (--this.ticksUntilEnable <= 0) {
            this.exitButton.field_22763 = true;
        }
    }

    @Override
    public boolean method_25422() {
        return this.ticksUntilEnable <= 0;
    }

    @Override
    public void method_25419() {
        throw new RuntimeException("Every Compat encountered an error loading a module. Look at error below.");
    }

    // static stuff
    private static final class_2561 TITLE = class_2561.method_43471("gui.everycomp.error_screen.title")
            .method_27692(class_124.field_1061).method_27692(class_124.field_1067);

    public static ErrorMessageScreen create(class_437 screen, List<String> mods) {
        return new ErrorMessageScreen(screen, 40, TITLE,
                class_2561.method_43469("gui.everycomp.error_screen.message",
                        class_2561.method_43470(String.join(", ", mods)).method_27692(class_124.field_1065)));
    }

}
