package net.mehvahdjukaar.every_compat.modules.fabric.mcaw;

import net.kikoz.mcwlights.MacawsLights;
import net.kikoz.mcwlights.init.BlockInit;
import net.kikoz.mcwlights.objects.LightBaseShort;
import net.kikoz.mcwlights.objects.TikiTorch;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import java.util.function.ToIntFunction;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.FENCE;
import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.SLAB;

//SUPPORT: v1.1.0+
public class MacawLightsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> soul_tiki_torches;
    public final SimpleEntrySet<WoodType, class_2248> tiki_torches;
    public final SimpleEntrySet<WoodType, class_2248> ceiling_fan_lights;

    public MacawLightsModule(String modId) {
        super(modId, "mcl");
        class_5321<class_1761> tab = MacawsLights.LIGHTSGROUP;

        soul_tiki_torches = SimpleEntrySet.builder(WoodType.class, "tiki_torch", "soul",
                        () -> BlockInit.SOUL_OAK_TIKI_TORCH, () -> VanillaWoodTypes.OAK,
                        w -> new TikiTorch(class_4970.class_2251.method_9637()
                                .method_9631(blockOffLightValue(10))
                                .method_9629(1.5F, 2.5F)
                                .method_31710(class_3620.field_15996)
                                .method_9626(class_2498.field_11547)
                                .method_22488(),
                                class_2398.field_22246
                        )
                )
                .requiresChildren(FENCE) //REASON: recipes
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(soul_tiki_torches);

        tiki_torches = SimpleEntrySet.builder(WoodType.class, "tiki_torch",
                        () -> BlockInit.OAK_TIKI_TORCH, () -> VanillaWoodTypes.OAK,
                        w -> new TikiTorch(class_4970.class_2251.method_9637()
                                .method_9631(blockOffLightValue(15))
                                .method_9629(1.5F, 2.5F)
                                .method_31710(class_3620.field_15996)
                                .method_9626(class_2498.field_11547)
                                .method_22488(),
                                class_2398.field_11240
                        )
                )
                .requiresChildren(FENCE) //REASON: recipes
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(tiki_torches);

        ceiling_fan_lights = SimpleEntrySet.builder(WoodType.class, "ceiling_fan_light",
                        () -> BlockInit.OAK_CEILING_FAN_LIGHT, () -> VanillaWoodTypes.OAK,
                        w -> new LightBaseShort(class_4970.class_2251.method_9637()
                                .method_9631(blockOffLightValue(15))
                                .method_31710(class_3620.field_15996)
                                .method_9629(1.5F, 2.5F)
                                .method_9626(class_2498.field_11547)
                                .method_22488()
                        )
                )
                .requiresChildren(SLAB) //REASON: recipes
                .addTextureM(modRes("block/oak_ceiling_fan"), EveryCompat.res("block/mcw/lights/ceiling_fan_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(ceiling_fan_lights);
    }

    // METHODS
    private static ToIntFunction<class_2680> blockOffLightValue(int lightLevel) {
        return (state) -> (Boolean)state.method_11654(class_2741.field_12548) ? lightLevel : 0;
    }
}
