package net.mehvahdjukaar.every_compat.modules.fabric.mcaw;

import net.kikoz.mcwroofs.MacawsRoofs;
import net.kikoz.mcwroofs.init.BlockInit;
import net.kikoz.mcwroofs.objects.roofs.*;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

//SUPPORT: v2.3.1+
public class MacawRoofsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> ATTIC_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> LOWER_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> STEEP_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> TOP_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> UPPER_LOWER_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> UPPER_STEEP_ROOFS;

    public final SimpleEntrySet<WoodType, class_2248> PLANKS_ATTIC_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> PLANKS_LOWER_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> PLANKS_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> PLANKS_STEEP_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> PLANKS_TOP_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> PLANKS_UPPER_LOWER_ROOFS;
    public final SimpleEntrySet<WoodType, class_2248> PLANKS_UPPER_STEEP_ROOFS;

    public MacawRoofsModule(String modId) {
        super(modId, "mcr");
        class_5321<class_1761> tab = MacawsRoofs.ROOFGROUP;

        ATTIC_ROOFS = SimpleEntrySet.builder(WoodType.class, "attic_roof",
                        () -> BlockInit.OAK_ATTIC_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new RoofGlass(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(ATTIC_ROOFS);

        LOWER_ROOFS = SimpleEntrySet.builder(WoodType.class, "lower_roof",
                        () -> BlockInit.OAK_LOWER_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new BaseRoof(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(LOWER_ROOFS);

        ROOFS = SimpleEntrySet.builder(WoodType.class, "roof",
                        () -> BlockInit.OAK_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new BaseRoof(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(ROOFS);

        STEEP_ROOFS = SimpleEntrySet.builder(WoodType.class, "steep_roof",
                        () -> BlockInit.OAK_STEEP_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new SteepRoof(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(STEEP_ROOFS);

        TOP_ROOFS = SimpleEntrySet.builder(WoodType.class, "top_roof",
                        () -> BlockInit.OAK_TOP_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new RoofTopNew(Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(TOP_ROOFS);

        UPPER_LOWER_ROOFS = SimpleEntrySet.builder(WoodType.class, "upper_lower_roof",
                        () -> BlockInit.OAK_UPPER_LOWER_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new Lower(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(UPPER_LOWER_ROOFS);

        UPPER_STEEP_ROOFS = SimpleEntrySet.builder(WoodType.class, "upper_steep_roof",
                        () -> BlockInit.OAK_UPPER_STEEP_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new Steep(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.log))
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(UPPER_STEEP_ROOFS);

        PLANKS_ATTIC_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_attic_roof",
                        () -> BlockInit.OAK_PLANKS_ATTIC_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new RoofGlass(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_ATTIC_ROOFS);

        PLANKS_LOWER_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_lower_roof",
                        () -> BlockInit.OAK_PLANKS_LOWER_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new BaseRoof(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_LOWER_ROOFS);

        PLANKS_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_roof",
                        () -> BlockInit.OAK_PLANKS_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new BaseRoof(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_ROOFS);

        PLANKS_STEEP_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_steep_roof",
                        () -> BlockInit.OAK_PLANKS_STEEP_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new SteepRoof(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_STEEP_ROOFS);

        PLANKS_TOP_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_top_roof",
                        () -> BlockInit.OAK_PLANKS_TOP_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new RoofTopNew(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_TOP_ROOFS);

        PLANKS_UPPER_LOWER_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_upper_lower_roof",
                        () -> BlockInit.OAK_PLANKS_UPPER_LOWER_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new Lower(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_UPPER_LOWER_ROOFS);

        PLANKS_UPPER_STEEP_ROOFS = SimpleEntrySet.builder(WoodType.class, "planks_upper_steep_roof",
                        () -> BlockInit.OAK_PLANKS_UPPER_STEEP_ROOF, () -> VanillaWoodTypes.OAK,
                        w -> new Steep(class_2246.field_10161.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.SOLID)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(PLANKS_UPPER_STEEP_ROOFS);
    }
}
