package net.mehvahdjukaar.every_compat.common_classes;


import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;

public class CompatChestItem extends BlockItem implements ICustomItemRendererProvider {

    public CompatChestItem(Block block, Properties properties) {
        super(block, properties);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public Supplier<ItemStackRenderer> getRendererFactory() {
        return () -> ClientProxy.getItemStackRenderer(this);
    }

    private static class ClientProxy {
        public static @NotNull ItemStackRenderer getItemStackRenderer(CompatChestItem compatChestItem) {
            ChestBlock block = (ChestBlock) compatChestItem.m_40614_();
            return new ItemStackRenderer() {
                final BlockEntityRenderDispatcher renderer = Minecraft.m_91087_().m_167982_();
                final CompatChestBlockEntity dummy = (CompatChestBlockEntity) block
                        .m_142194_(BlockPos.f_121853_, block.m_49966_());

                @Override
                public void m_108829_(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
                    renderer.m_112272_(dummy, poseStack, multiBufferSource, i, i1);
                }
            };
        }
    }


}

