package net.mehvahdjukaar.every_compat.misc;

import I;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map.Entry;

@Environment(EnvType.CLIENT)
public abstract class BlockTypeCycleItemRenderer<T extends BlockType> extends ItemStackRenderer {

    private final List<String> childKeys = new ArrayList<>();
    private final List<T> moddedTypes = new ArrayList<>();
    private final Class<T> typeClass;
    private ItemStack currentStack = Items.f_42127_.m_7968_();
    private int lastIndex = 0;
    private int lastTime = 0;
    private int typeIndex = 0;
    private boolean initialized;

    public BlockTypeCycleItemRenderer(Class<T> tClass) {
        super();
        this.typeClass = tClass;
    }

    private void initialize() {
        BlockTypeRegistry<T> reg = BlockSetAPI.getTypeRegistry(typeClass);
        if (reg == null) return;
        for (var c : reg.getDefaultType().getChildren()) {
            if (c.getKey().contains(":") && !childKeys.contains(c.getKey()) && c.getValue() instanceof ItemLike) {
                childKeys.add(c.getKey());
            }
        }
        for (var w : reg.getValues()) {
            if (!w.isVanilla()) moddedTypes.add(w);
        }
        if (moddedTypes.isEmpty()) childKeys.clear();
        Collections.shuffle(moddedTypes);
    }

    @Override
    public void m_108829_(ItemStack stack, ItemDisplayContext transformType,
                             PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {

        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        ItemStack item = getAnyItem();

        var itemRenderer = Minecraft.m_91087_().m_91291_();

        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5D, 0.5D, 0.5D);
        BakedModel bakedmodel = itemRenderer.m_174264_(item, null, null, 0);
        itemRenderer.m_115143_(item, transformType, false, matrixStack, buffer, combinedLight, combinedOverlay, bakedmodel);
        if (!bakedmodel.m_7539_()) Lighting.m_84930_();
        //forces rendering now with flat lighting
        if (buffer instanceof MultiBufferSource.BufferSource bu) {
            bu.m_109911_();
        }
        Lighting.m_84931_();
        matrixStack.m_85849_();

    }


    public ItemStack getAnyItem() {
        int size = childKeys.size();
        if (size == 0) return Items.f_42127_.m_7968_();
        int time = (int) (Util.m_137550_() / 350L);
        int tm = time % (size+1);
        if (tm != lastTime) {

            ItemLike v = null;
            do {
                var l = (this.lastIndex + 1) % size;
                // this.woodIndex = (this.woodIndex + 1);
                if (l < lastIndex || size == 1) this.typeIndex = (this.typeIndex + 1) % moddedTypes.size();
                this.lastIndex = l;
                String key = childKeys.get(lastIndex);
                var vv = moddedTypes.get(typeIndex % moddedTypes.size()).getChild(key);
                if (vv instanceof ItemLike il) {
                    v = il;
                }
            } while (v == null);

            this.currentStack = v.m_5456_().m_7968_();
        }
        this.lastTime = tm;
        return currentStack;
    }
}
