package net.mehvahdjukaar.every_compat.misc;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class ErrorMessageScreen extends Screen {
    private final Screen lastScreen;
    private final Component text;
    private int ticksUntilEnable;
    private MultiLineLabel message;

    private Button exitButton;

    public ErrorMessageScreen(Screen screen, int ticksUntilEnable,
                              Component title, Component text) {
        super(title);
        this.message = MultiLineLabel.f_94331_;
        this.lastScreen = screen;
        this.ticksUntilEnable = ticksUntilEnable;
        this.text = text;
    }

    @Override
    public @NotNull Component m_142562_() {
        return CommonComponents.m_267603_(super.m_142562_(), text);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.exitButton = this.m_142416_(Button.m_253074_(Component.m_237115_("menu.quit"), (pressed) -> {
            m_7379_();
        }).m_252987_((this.f_96543_ - 150) / 2, this.f_96544_ * 5 / 6, 150, 20).m_253136_());
        this.exitButton.f_93623_ = false;

        this.message = MultiLineLabel.m_94341_(this.f_96547_, text, this.f_96543_ - 50);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 30, 16777215);
        this.message.m_6276_(graphics, this.f_96543_ / 2, 55);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (--this.ticksUntilEnable <= 0) {
            this.exitButton.f_93623_ = true;
        }
    }

    @Override
    public boolean m_6913_() {
        return this.ticksUntilEnable <= 0;
    }

    @Override
    public void m_7379_() {
        throw new RuntimeException("Every Compat encountered an error loading a module. Look at error below.");
    }

    // static stuff
    private static final Component TITLE = Component.m_237115_("gui.everycomp.error_screen.title")
            .m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);

    public static ErrorMessageScreen create(Screen screen, List<String> mods) {
        return new ErrorMessageScreen(screen, 40, TITLE,
                Component.m_237110_("gui.everycomp.error_screen.message",
                        Component.m_237113_(String.join(", ", mods)).m_130940_(ChatFormatting.GOLD)));
    }

}
