package net.mehvahdjukaar.every_compat.modules.forge.abnormal;

import com.google.gson.JsonObject;
import com.teamabnormals.blueprint.common.block.BlueprintBeehiveBlock;
import com.teamabnormals.blueprint.common.block.LeafPileBlock;
import com.teamabnormals.blueprint.core.registry.BlueprintBlockEntityTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.*;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;
import static net.mehvahdjukaar.every_compat.common_classes.TagUtility.getATagOrCreateANew;

//SUPPORT: v3.0.0+
public class WoodworksModule extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> chiseled_bookshelves;
    public final SimpleEntrySet<WoodType, Block> boards;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> beehives;
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> leafPiles;

    public WoodworksModule(String modId) {
        super(modId, "abnww");
        ResourceKey<CreativeModeTab> tab = CreativeModeTabs.f_256788_;

        bookshelves = SimpleEntrySet.builder(WoodType.class, "bookshelf",
                        getModBlock("acacia_bookshelf"),
                        () -> VanillaWoodTypes.ACACIA,
                        woodType -> new Block(Utils.copyPropertySafe(woodType.log)
                                .m_60978_(1.5F)
                        )
                )
                .addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_278384_, Registries.f_256747_)
                .addTag(Tags.Blocks.BOOKSHELVES, Registries.f_256747_)
                .addTag(new ResourceLocation("blueprint:wooden_bookshelves"), Registries.f_256747_, Registries.f_256913_)
                .addTag(Tags.Items.BOOKSHELVES, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .build();
        this.addEntry(bookshelves);

        chiseled_bookshelves = SimpleEntrySet.builder(WoodType.class, "bookshelf", "chiseled",
                        getModBlock("chiseled_acacia_bookshelf"),
                        () -> VanillaWoodTypes.ACACIA,
                        woodType -> new ChiseledBookShelfBlock(Utils.copyPropertySafe(woodType.log)
                                .m_60978_(1.5F)
                        )
                )
                .addTexture(modRes("block/chiseled_acacia_bookshelf_empty"))
                .addTextureM(modRes("block/chiseled_acacia_bookshelf_occupied"),
                        EveryCompat.res("block/acacia_chiseled_bookshelf_occupied_m"))
                .addTexture(modRes("block/chiseled_acacia_bookshelf_side"))
                .addTexture(modRes("block/chiseled_acacia_bookshelf_top"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(new ResourceLocation("blueprint:wooden_chiseled_bookshelves"), Registries.f_256747_)
                .addTag(new ResourceLocation("blueprint:wooden_chiseled_bookshelves"), Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .build();
        this.addEntry(chiseled_bookshelves);

        boards = SimpleEntrySet.builder(WoodType.class, "boards",
                        WoodworksBlocks.OAK_BOARDS, () -> VanillaWoodTypes.OAK,
                        woodType -> new RotatedPillarBlock(Utils.copyPropertySafe(woodType.planks)
                                .m_60913_(2.0F, 3.0F))
                )
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("wooden_boards"), Registries.f_256747_)
                .addTag(modRes("wooden_boards"), Registries.f_256913_)
                .addTexture(modRes("block/oak_boards"))
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .build();
        this.addEntry(boards);

        ladders = SimpleEntrySet.builder(WoodType.class, "ladder",
                        getModBlock("spruce_ladder"),
                        () -> VanillaWoodTypes.SPRUCE,
                        woodType -> new LadderBlock(Utils.copyPropertySafe(Blocks.f_50155_)
                                .m_60978_(0.4F)
                                .m_60955_()
                                .m_278166_(PushReaction.DESTROY))
                )
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .addTexture(EveryCompat.res("block/spruce_ladder"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_201924_, Registries.f_256747_)
                .addTag(BlockTags.f_13082_, Registries.f_256747_)
                .addTag(new ResourceLocation("forge:ladders"), Registries.f_256747_)
                .addTag(new ResourceLocation("blueprint:wooden_ladders"), Registries.f_256747_)
                .addTag(new ResourceLocation("quark:ladders"), Registries.f_256747_)
                .addTag(new ResourceLocation("forge:ladders"), Registries.f_256913_)
                .addTag(new ResourceLocation("blueprint:wooden_ladders"), Registries.f_256913_)
                .addTag(new ResourceLocation("quark:ladders"), Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(ladders);

        beehives = SimpleEntrySet.builder(WoodType.class, "beehive",
                        getModBlock("spruce_beehive"),
                        () -> VanillaWoodTypes.SPRUCE,
                        woodType -> new BlueprintBeehiveBlock(Utils.copyPropertySafe(woodType.log)
                                .m_60978_(0.6F)
                        )
                )
                .addTile(BlueprintBlockEntityTypes.BEEHIVE)
                .addTextureM(EveryCompat.res("block/spruce_beehive_front_honey"), EveryCompat.res("block/spruce_beehive_front_honey_m"))
                .addTextureM(EveryCompat.res("block/spruce_beehive_front"), EveryCompat.res("block/spruce_beehive_front_m"))
                .addTextureM(EveryCompat.res("block/spruce_beehive_side"), EveryCompat.res("block/spruce_beehive_side_m"))
                .addTexture(EveryCompat.res("block/spruce_beehive_end"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13072_, Registries.f_256747_)
                .addTag(new ResourceLocation("blueprint:wooden_beehives"), Registries.f_256747_, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(beehives);

        chests = SimpleEntrySet.builder(WoodType.class, "chest",
                        getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK,
                        woodType -> new CompatChestBlock(this::getChestTile,
                                Utils.copyPropertySafe(woodType.planks).m_60978_(2.5F)
                        )
                )
                .setTabKey(tab)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13088_, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS_WOODEN, Registries.f_256747_)
                .addTag(Tags.Items.CHESTS, Registries.f_256913_)
                .addTag(Tags.Items.CHESTS_WOODEN, Registries.f_256913_)
                .addTag(new ResourceLocation("blueprint:wooden_chests"), Registries.f_256913_, Registries.f_256747_)
                .addTag(new ResourceLocation("quark","revertable_chests"), Registries.f_256913_)
                .addTag(new ResourceLocation("quark","boatable_chests"), Registries.f_256913_)
                .addTile(abwwChestBlockEntity::new)
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(chests);

        trappedChests = SimpleEntrySet.builder(WoodType.class, "chest", "trapped",
                        getModBlock("trapped_oak_chest"), () -> VanillaWoodTypes.OAK,
                        woodType -> new CompatTrappedChestBlock(this::getTrappedTile,
                                Utils.copyPropertySafe(woodType.planks).m_60978_(2.5F)
                        )
                )
                .setTabKey(tab)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13088_, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS_WOODEN, Registries.f_256747_)
                .addTag(Tags.Blocks.CHESTS_TRAPPED, Registries.f_256747_)
                .addTag(new ResourceLocation("blueprint:wooden_trapped_chests"), Registries.f_256747_)

                .addTag(Tags.Items.CHESTS, Registries.f_256913_)
                .addTag(Tags.Items.CHESTS_WOODEN, Registries.f_256913_)
                .addTag(Tags.Items.CHESTS_TRAPPED, Registries.f_256913_)
                .addTag(new ResourceLocation("blueprint:wooden_trapped_chests"), Registries.f_256913_)
                .addTile(abwwTrappedBlockEntity::new)
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(trappedChests);


        leafPiles = SimpleEntrySet.builder(LeavesType.class, "leaf_pile",
                        WoodworksBlocks.OAK_LEAF_PILE, () -> VanillaLeavesTypes.OAK,
                        leavesType -> {
                            if (leavesType.getWoodType() == null) return null;
                            return new LeafPileBlock(Utils.copyPropertySafe(leavesType.leaves)
                                    .m_60978_(0.2F)
                                    .m_278183_()
                                    .m_278166_(PushReaction.DESTROY)
                            );
                        }
                )
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves",
                        "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))
                .addTag(BlockTags.f_144281_, Registries.f_256747_)
                .addTag(modRes("leaf_piles"), Registries.f_256747_, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .copyParentTint()
                .build();
        this.addEntry(leafPiles);
    }

    // GetTile -----------------------------------------------------------------------------------------------------------
    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return trappedChests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity -----------------------------------------------------------------------------------------------------------
    private class abwwChestBlockEntity extends CompatChestBlockEntity {
        public abwwChestBlockEntity(BlockPos pos, BlockState state) {
            super(chests.getTile(), pos, state);
        }
    }

    private class abwwTrappedBlockEntity extends CompatChestBlockEntity {
        public abwwTrappedBlockEntity(BlockPos pos, BlockState state) {
            super(trappedChests.getTile(), pos, state);
        }
    }

    // Registry --------------------------------------------------------------------------------------------------------
    @Override
    @OnlyIn(Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        CompatChestBlockRenderer.register(event, trappedChests.getTile(CompatChestBlockEntity.class), shortenedId());
    }

    @Override
    // Recipes
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, sink) -> {
            bookshelves.items.forEach((wood, item) -> {
                // The generation of ladders get skipped due to some mods already have ladders and will be used as an alt
                Item getLadder = ladders.items.get(wood);
                Item ladder = (getLadder != null) ? getLadder : BuiltInRegistries.f_257033_.m_7745_(
                        ResourceLocation.fromNamespaceAndPath(wood.getNamespace(), wood.getTypeName() +"_ladder"));

                // sawmill recipes - from LOGS
                sawmillRecipe("oak_planks_from_oak_logs_sawing", wood.log.m_5456_(), wood.planks.m_5456_(),
                        sink, manager, wood);
                sawmillRecipe("oak_boards_from_oak_logs_sawing", wood.log.m_5456_(), boards.items.get(wood),
                        sink, manager, wood);
                sawmillRecipe("spruce_ladder_from_spruce_logs_sawing", wood.log.m_5456_(), ladder,
                        sink, manager, wood);
                createRecipeIfNotNull("oak_button_from_oak_logs_sawing", true, "button",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_door_from_oak_logs_sawing", true, "door",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_fence_from_oak_logs_sawing", true, "fence",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_fence_gate_from_oak_logs_sawing", true, "fence_gate",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_pressure_plate_from_oak_logs_sawing", true, "pressure_plate",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_sign_from_oak_logs_sawing", true, "sign",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_slab_from_oak_logs_sawing", true, "slab",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_stairs_from_oak_logs_sawing", true, "stairs",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_trapdoor_from_oak_logs_sawing", true, "trapdoor",
                        sink, manager, wood);

                // - from PLANKS
                sawmillRecipe("oak_boards_from_oak_planks_sawing", wood.planks.m_5456_(), boards.items.get(wood),
                        sink, manager, wood);
                sawmillRecipe("spruce_ladder_from_spruce_planks_sawing", wood.planks.m_5456_(), ladder,
                        sink, manager, wood);
                createRecipeIfNotNull("oak_button_from_oak_planks_sawing", false, "button",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_fence_from_oak_planks_sawing", false, "fence",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_slab_from_oak_planks_sawing", false, "slab",
                        sink, manager, wood);
                createRecipeIfNotNull("oak_stairs_from_oak_planks_sawing", false, "stairs",
                        sink, manager, wood);
            });
        });
    }

    public void createRecipeIfNotNull(String recipeName, boolean usingLog, String output,
                                      ResourceSink sink, ResourceManager manager, WoodType wood) {
        Item input = (usingLog) ? wood.log.m_5456_() : wood.planks.m_5456_();

        if (Objects.nonNull(wood.getItemOfThis(output))) {
            sawmillRecipe(recipeName, input, wood.getItemOfThis(output), sink, manager, wood);
        } else if (Objects.nonNull(wood.getBlockOfThis(output))) {
            sawmillRecipe(recipeName, input, wood.getBlockOfThis(output).m_5456_(), sink, manager, wood);
        }
    }

    public void sawmillRecipe(String recipeName, Item input, Item output,
                              ResourceSink sink, ResourceManager manager, WoodType wood) {

        ResourceLocation recipeLocation = modRes("recipes/" + recipeName + ".json"); // get Recipe JSON

        try (InputStream recipeStream = manager.m_213713_(recipeLocation)
                .orElseThrow(() -> new FileNotFoundException("File Not Found: " + recipeLocation)).m_215507_()) {
            JsonObject recipe = RPUtils.deserializeJson(recipeStream);

            // VARIABLES
            JsonObject foundRecipe = recipe.getAsJsonArray("recipes")
                    .get(0).getAsJsonObject().getAsJsonObject("recipe");

            JsonObject getIngredient = foundRecipe.getAsJsonObject("ingredient");

            // Editing the JSON recipe
            if (getIngredient.has("tag")) {
                getIngredient.addProperty("tag",
                        getATagOrCreateANew("logs", "caps", wood, sink, manager).toString());
            } else { // getIngredient.has("item")
                getIngredient.addProperty("item", Utils.getID(input).toString());
            }
            foundRecipe.addProperty("result", Utils.getID(output).toString());

            // filenameBuilder: <woodType>_<blockType>_from_<woodType>_<logs|planks>_sawing
            String[] nameSplit = recipeName.split("_(?!gate|plate)");
            String filenameBuilder = "_" + nameSplit[1] + "_from_" + wood.getTypeName() + "_" + nameSplit[4] + "_sawing";

            sink.addJson(EveryCompat.res(this.shortenedId() + "/" + wood.getAppendableId() + filenameBuilder), recipe, ResType.RECIPES);

        } catch (Exception e) {
            EveryCompat.LOGGER.error("Error while creating recipes for woodwork sawmill: ", e);
        }

    }



    // Textures
    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) -> {
            trappedChests.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak/normal"),
                        EveryCompat.res("model/oak_chest_normal_m"),
                        EveryCompat.res("model/oak_chest_normal_o"),
                        EveryCompat.res("model/trapped_chest_normal")
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak/normal_left"),
                        EveryCompat.res("model/oak_chest_left_m"),
                        EveryCompat.res("model/oak_chest_left_o"),
                        EveryCompat.res("model/trapped_chest_left")
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak/normal_right"),
                        EveryCompat.res("model/oak_chest_right_m"),
                        EveryCompat.res("model/oak_chest_right_o"),
                        EveryCompat.res("model/trapped_chest_right")
                );
            });
        });
    }

}
