package net.mehvahdjukaar.every_compat.modules.forge.pokecube;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pokecube.core.init.ItemGenerator;
import pokecube.legends.init.BlockInit;
import pokecube.legends.init.LegendsCreativeTabs;
import pokecube.legends.recipes.LegendsDistorticRecipeSerializer;

import java.util.ArrayList;
import java.util.List;


public class PokecubeLegendsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> distorticPlanks;
    public final SimpleEntrySet<WoodType, Block> distorticStairs;
    public final SimpleEntrySet<WoodType, Block> DISTORTICSLABS;

    public PokecubeLegendsModule(String modId) {
        super(modId, "pcl");
        var tab = LegendsCreativeTabs.BUILDING_BLOCKS_TAB;
        TemplateRecipeManager.registerTemplate(modRes("legends_recipe"), MirrorRecipeTemplate::new);

        distorticPlanks = SimpleEntrySet.builder(WoodType.class, "planks", "distortic",
                        BlockInit.DISTORTIC_OAK_PLANKS, () -> VanillaWoodTypes.OAK,
                        w -> new Block(Utils.copyPropertySafe(w.planks)))
                .addRecipe(modRes("dimensions/distorted_world/distortic_planks/distortic_oak_planks"))
                .addTag(modRes("legends_planks"), Registries.f_256747_)
                .addTag(modRes("legends_planks"), Registries.f_256913_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13090_, Registries.f_256747_)
                .addTag(ItemTags.f_13168_, Registries.f_256913_)
                .addTexture(modRes("block/distortic_oak_planks"))
                .setTab(tab)
                .build();

        this.addEntry(distorticPlanks);

        distorticStairs = SimpleEntrySet.builder(WoodType.class, "stairs", "distortic",
                        BlockInit.DISTORTIC_OAK_STAIRS, () -> VanillaWoodTypes.OAK,
                        w -> new ItemGenerator.GenericStairs(w.planks.m_49966_(), Utils.copyPropertySafe(w.planks)))
                .addRecipe(modRes("dimensions/distorted_world/distortic_planks/distortic_oak_stairs"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13096_, Registries.f_256747_)
                .addTag(ItemTags.f_13174_, Registries.f_256913_)
                .addTexture(modRes("block/distortic_oak_planks"))
                .setTab(tab)
                .build();

        this.addEntry(distorticStairs);

        DISTORTICSLABS = SimpleEntrySet.builder(WoodType.class, "slab", "distortic",
                        BlockInit.DISTORTIC_OAK_SLAB, () -> VanillaWoodTypes.OAK,
                        w -> new SlabBlock(Utils.copyPropertySafe(w.planks)))
                .addRecipe(modRes("dimensions/distorted_world/distortic_planks/distortic_oak_slab"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13097_, Registries.f_256747_)
                .addTag(ItemTags.f_13175_, Registries.f_256913_)
                .addTexture(modRes("block/distortic_oak_planks"))
                .setTab(tab)
                .build();

        this.addEntry(DISTORTICSLABS);
    }

    public static class MirrorFinishedRecipe implements FinishedRecipe {

        private final Ingredient ingredient;
        private final ItemStack result;
        private final Block block;
        private final ResourceLocation id;
        public final ResourceKey<Level> dimId;
        private final Advancement.Builder advancement;
        protected final ResourceLocation advancementId;
//        public final String group;


        public MirrorFinishedRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, Block block, Advancement.Builder advancement, ResourceLocation advancementId, ResourceLocation dimId) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.block = block;
            this.dimId = ResourceKey.m_135785_(Registries.f_256858_, dimId);
            this.advancement = advancement;
            this.advancementId = advancementId;
//            this.group = group;
        }


        public void m_7917_(JsonObject json) {
//            if (!this.group.isEmpty()) {
//                json.addProperty("group", this.group);
//            }
            json.addProperty("id", this.id.toString());

            json.add("ingredient", ingredient.m_43942_());

            json.addProperty("result", Utils.getID(result.m_41720_()).toString());
            json.addProperty("count", result.m_41613_());
        }

        @Override
        public @NotNull ResourceLocation m_6445_() {
            return id;
        }

        @Override
        public @NotNull RecipeSerializer<?> m_6637_() {
            return LegendsDistorticRecipeSerializer.SERIALIZER_DISTORTIC;
        }

        @Nullable
        @Override
        public JsonObject m_5860_() {
            return advancement.m_138400_();
        }

        @Nullable
        @Override
        public ResourceLocation m_6448_() {
            return advancementId;
        }
    }

    public class MirrorRecipeTemplate implements IRecipeTemplate<MirrorFinishedRecipe> {

        private final List<Object> conditions = new ArrayList<>();

        public final Block block;
        public final Ingredient input;
        public final ItemStack result;
        public final JsonElement inputElement;
        public final ResourceLocation blockId;
        public final ResourceLocation dimID;
        public final String group;

        public MirrorRecipeTemplate(JsonObject json) {
            var g = json.get("group");
            this.group = g == null ? "" : g.getAsString();

            this.inputElement = GsonHelper.m_13885_(json, "input") ? GsonHelper.m_13933_(json, "input") : GsonHelper.m_13930_(json, "input");
            this.result = ShapedRecipe.m_151274_(GsonHelper.m_13930_(json, "output"));
            this.blockId = new ResourceLocation(GsonHelper.m_13906_(json, "blockId"));
            this.dimID = new ResourceLocation(GsonHelper.m_13906_(json, "dimId"));
            this.block = ForgeRegistries.BLOCKS.getValue(blockId);
            this.input = Ingredient.m_43917_((JsonElement)inputElement);
        }

        @Override
        public <T extends BlockType> MirrorFinishedRecipe createSimilar(
                T originalMat, T destinationMat, Item unlockItem, String id) {
            ItemLike newRes = BlockType.changeItemType(this.result.m_41720_(), originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                        this.result, originalMat, destinationMat));
            }
            ItemStack newResult = new ItemStack(newRes);
            if (this.result.m_41782_()) newResult.m_41751_(this.result.m_41784_().m_6426_());
            if (id == null) id = Utils.getID(newRes.m_5456_()).toString();

            Ingredient newIng = ResourcesUtils.convertIngredient(this.input, originalMat, destinationMat);

            Advancement.Builder advancement = Advancement.Builder.m_138353_();

            advancement.m_138386_("has_planks", InventoryChangeTrigger.TriggerInstance.m_43199_(unlockItem));
            var res = new ResourceLocation(id);
            return new MirrorFinishedRecipe(res, newIng, newResult, block, advancement,
                    modRes("recipes/" + "pokecube_legends/" + "distortic_planks" + "/" + res.m_135815_()), dimID);
        }

        @Override
        public void addCondition(Object condition) {
            this.conditions.add(condition);
        }

        @Override
        public List<Object> getConditions() {
            return conditions;
        }
    }
}
