package net.mehvahdjukaar.every_compat.modules.lieonlion;

import io.github.lieonlion.lolmct.block.MoreCraftingTableBlock;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;

// SUPPORT: v1.2.7+
// NOTE: More Crafting Table is developed by LieOnLion and has both FORGE & FABRIC
public class MoreCraftingTablesModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> craftingTable;

    public MoreCraftingTablesModule(String modId) {
        super(modId, "lolmct");
        ResourceKey<CreativeModeTab> tab = CreativeModeTabs.f_256791_;

        String namespace = (PlatHelper.getPlatform().isForge()) ? "forge" : "c";

        craftingTable = SimpleEntrySet.builder(WoodType.class, "crafting_table",
                        getModBlock("spruce_crafting_table"),
                        () -> VanillaWoodTypes.SPRUCE,
                        w -> new MoreCraftingTableBlock(w.planks.m_284356_()))
                //TEXTURE: texture is oak_craftng_table's texture
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_front"), EveryCompat.res("block/lolmct/spruce_crafting_table_front_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_side"), EveryCompat.res("block/lolmct/spruce_crafting_table_side_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_top"), EveryCompat.res("block/lolmct/spruce_crafting_table_top_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(new ResourceLocation(namespace,"workbench"), Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:crafting_tables"), Registries.f_256747_)
                .addTag(new ResourceLocation("lieonstudio:crafting_tables"), Registries.f_256913_)
                .addTag(new ResourceLocation(namespace,"workbench"), Registries.f_256913_)
                .addTag(new ResourceLocation("quad:fuel/wood"), Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(craftingTable);
    }
}
