/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends DynClientResourcesGenerator {
    private static ClientDynamicResourcesHandler INSTANCE;
    private boolean firstInit = false;

    public static ClientDynamicResourcesHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientDynamicResourcesHandler();
        }
        return INSTANCE;
    }

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(EveryCompat.res("generated_pack")));
        if (PlatHelper.isModLoaded((String)"quark")) {
            ((DynamicTexturePack)this.getPack()).addNamespaces(new String[]{"quark"});
        }
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return EveryCompat.LOGGER;
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        EveryCompat.forAllModules(m -> m.addTranslations(this, lang));
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        if (!this.firstInit) {
            CompatSpritesHelper.addHardcodedSprites();
            this.firstInit = true;
        }
        if (!ECConfigs.GENERATE_DYNAMIC_CLIENT.get().booleanValue()) {
            return;
        }
        PaletteStrategies.clearCache();
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicClientResources(tasks::add));
        int minBatches = Runtime.getRuntime().availableProcessors();
        int maxBatches = tasks.size() / Runtime.getRuntime().availableProcessors();
        int batchSize = Math.max(minBatches, maxBatches);
        EveryCompat.LOGGER.info("Starting dynamic resources generation tasks: {} in batches of {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask subtask : subList) {
                    try {
                        subtask.accept(resourceManager, resourceSink);
                    }
                    catch (Throwable e) {
                        EveryCompat.LOGGER.error("Error while generating dynamic resource for task {}", (Object)subtask, (Object)e);
                    }
                }
            });
        }
    }
}

