/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BlockTypeCycleItemRenderer<T extends BlockType>
extends ItemStackRenderer {
    private final List<String> childKeys = new ArrayList<String>();
    private final List<T> moddedTypes = new ArrayList<T>();
    private final Class<T> typeClass;
    private ItemStack currentStack = Items.f_42127_.m_7968_();
    private int lastIndex = 0;
    private int lastTime = 0;
    private int typeIndex = 0;
    private boolean initialized;

    public BlockTypeCycleItemRenderer(Class<T> tClass) {
        this.typeClass = tClass;
    }

    private void initialize() {
        BlockTypeRegistry reg = BlockSetAPI.getTypeRegistry(this.typeClass);
        if (reg == null) {
            return;
        }
        for (Map.Entry c : reg.getDefaultType().getChildren()) {
            if (!((String)c.getKey()).contains(":") || this.childKeys.contains(c.getKey()) || !(c.getValue() instanceof ItemLike)) continue;
            this.childKeys.add((String)c.getKey());
        }
        for (BlockType w : reg.getValues()) {
            if (w.isVanilla()) continue;
            this.moddedTypes.add(w);
        }
        if (this.moddedTypes.isEmpty()) {
            this.childKeys.clear();
        }
        Collections.shuffle(this.moddedTypes);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        ItemStack item = this.getAnyItem();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        BakedModel bakedmodel = itemRenderer.m_174264_(item, null, null, 0);
        itemRenderer.m_115143_(item, transformType, false, matrixStack, buffer, combinedLight, combinedOverlay, bakedmodel);
        if (!bakedmodel.m_7539_()) {
            Lighting.m_84930_();
        }
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bu = (MultiBufferSource.BufferSource)buffer;
            bu.m_109911_();
        }
        Lighting.m_84931_();
        matrixStack.m_85849_();
    }

    public ItemStack getAnyItem() {
        int size = this.childKeys.size();
        if (size == 0) {
            return Items.f_42127_.m_7968_();
        }
        int time = (int)(Util.m_137550_() / 350L);
        int tm = time % (size + 1);
        if (tm != this.lastTime) {
            ItemLike v = null;
            do {
                ItemLike il;
                int l;
                if ((l = (this.lastIndex + 1) % size) < this.lastIndex || size == 1) {
                    this.typeIndex = (this.typeIndex + 1) % this.moddedTypes.size();
                }
                this.lastIndex = l;
                String key = this.childKeys.get(this.lastIndex);
                Object vv = ((BlockType)this.moddedTypes.get(this.typeIndex % this.moddedTypes.size())).getChild(key);
                if (!(vv instanceof ItemLike)) continue;
                v = il = (ItemLike)vv;
            } while (v == null);
            this.currentStack = v.m_5456_().m_7968_();
        }
        this.lastTime = tm;
        return this.currentStack;
    }
}

