/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

public class RecipeUtility {
    public static void stonecuttingWithTagRecipe(Block output, ResourceLocation recipeLoc, ResourceLocation tagResLoc, ResourceLocation newRecipeLoc, ResourceSink sink, ResourceManager manager) {
        if (Objects.nonNull(output)) {
            try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLoc).orElseThrow(() -> new FileNotFoundException("File Not Found: " + recipeLoc))).m_215507_();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
                recipe.getAsJsonObject("ingredient").addProperty("tag", tagResLoc.toString());
                recipe.addProperty("result", Utils.getID((Block)output).toString());
                sink.addJson(newRecipeLoc, (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate the recipe @ {} : {}", (Object)recipeLoc, (Object)e);
            }
        }
    }

    public static void createRecipeWithTag(ResourceLocation recipeLoc, ResourceLocation newRecipeLoc, String oldTagIngredient, String newTagIngredient, Object newResult, ResourceSink sink, ResourceManager manager) {
        if (Objects.nonNull(newResult)) {
            try (InputStream recipeStream = ((Resource)manager.m_213713_(ResType.RECIPES.getPath(recipeLoc)).orElseThrow(() -> new FileNotFoundException("File Not Found: " + recipeLoc))).m_215507_();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
                RecipeUtility.parseAndModifyRecipe(recipe, oldTagIngredient, newTagIngredient, Utils.getID((Object)newResult).toString());
                sink.addJson(newRecipeLoc, (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate the recipe @ {} : {}", (Object)recipeLoc, (Object)e);
            }
        }
    }

    public static void parseAndModifyRecipe(Object object, String oldIngredient, String newIngredien, String newResult) {
        block21: {
            block20: {
                if (!(object instanceof JsonObject)) break block20;
                JsonObject jsonObject = (JsonObject)object;
                Iterator iterator = jsonObject.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    switch (key = (String)iterator.next()) {
                        case "ingredients": 
                        case "ingredient": 
                        case "results": {
                            if (jsonObject.get(key).isJsonArray()) {
                                RecipeUtility.parseAndModifyRecipe(jsonObject.getAsJsonArray(key), oldIngredient, newIngredien, newResult);
                                break;
                            }
                            RecipeUtility.parseAndModifyRecipe(jsonObject.getAsJsonObject(key), oldIngredient, newIngredien, newResult);
                            break;
                        }
                        case "result": {
                            jsonObject.addProperty("result", newResult);
                            break;
                        }
                        case "tag": {
                            if (!jsonObject.get("tag").getAsString().equals(oldIngredient)) break;
                            jsonObject.addProperty("tag", newIngredien);
                            break;
                        }
                        case "item": {
                            if (jsonObject.get("item").getAsString().equals(oldIngredient)) {
                                jsonObject.addProperty("item", newIngredien);
                                break;
                            }
                            jsonObject.addProperty("item", newResult);
                        }
                    }
                }
                break block21;
            }
            if (!(object instanceof JsonArray)) break block21;
            JsonArray jsonArray = (JsonArray)object;
            for (int idx = 0; idx < jsonArray.size(); ++idx) {
                JsonObject jsonObject = jsonArray.get(idx).getAsJsonObject();
                if (jsonObject.has("tag") && jsonObject.get("tag").getAsString().equals(oldIngredient)) {
                    jsonObject.addProperty("tag", newIngredien);
                    continue;
                }
                if (jsonObject.has("item") && jsonObject.get("item").getAsString().equals(oldIngredient)) {
                    jsonObject.addProperty("item", newIngredien);
                    continue;
                }
                if (!jsonObject.has("item")) continue;
                jsonObject.addProperty("item", newResult);
            }
        }
    }
}

