/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

public class TextureUtility {
    public static String modifyTexturePath(String baseTexturePath, String prefix, String shortenedId, String oldTypeName, BlockType blockType) {
        String infix = shortenedId + "/" + blockType.getNamespace() + "/";
        return prefix + infix + baseTexturePath.substring(prefix.length()).replace(oldTypeName, blockType.getTypeName());
    }

    public static void generateLogTexture(ResourceLocation baseTextureLoc, ResourceLocation logMaskLoc, ResourceLocation planksMaskLoc, String shortenedId, String oldTypeName, PaletteStrategy logPaletteStrategy, ResourceSink sink, ResourceManager manager) {
        try (TextureImage mainTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)baseTextureLoc);
             TextureImage logMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)logMaskLoc);
             TextureImage planksMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                String newPath = TextureUtility.modifyTexturePath(baseTextureLoc.m_135815_(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newPath, () -> {
                    try {
                        PaletteStrategy.PaletteAndAnimation logPalette = logPaletteStrategy.getPaletteAndAnimation((BlockType)woodType, manager);
                        PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_STANDARD.getPaletteAndAnimation((BlockType)woodType, manager);
                        Respriter planksResprite = Respriter.masked((TextureImage)mainTexture, (TextureImage)logMask);
                        TextureImage recoloredInner = planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                        Respriter logResprite = Respriter.masked((TextureImage)recoloredInner, (TextureImage)planksMask);
                        return logResprite.recolorWithAnimation(logPalette.palette(), logPalette.animation());
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate log texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                        return mainTexture;
                    }
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate log texture: ", (Throwable)e);
        }
    }

    public static void applyLogAndswapPlanksTexture(ResourceLocation baseTextureLoc, ResourceLocation logMaskLoc, ResourceLocation planksMaskLoc, String shortenedId, String oldTypeName, ResourceSink sink, ResourceManager manager) {
        try (TextureImage mainTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)baseTextureLoc);
             TextureImage logMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)logMaskLoc);
             TextureImage planksMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                String newPath = TextureUtility.modifyTexturePath(baseTextureLoc.m_135815_(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newPath, () -> {
                    TextureImage textureImage;
                    block8: {
                        TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)woodType.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                        try {
                            PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_REMOVE_DARKEST.getPaletteAndAnimation((BlockType)woodType, manager);
                            TextureImage croppedTexture = logTexture.makeCopyWithMetadata(logTexture.getMcMeta());
                            TextureOps.applyMask((TextureImage)croppedTexture, (TextureImage)planksMask);
                            TextureOps.applyOverlay((TextureImage)mainTexture, (TextureImage[])new TextureImage[]{croppedTexture});
                            Respriter planksResprite = Respriter.masked((TextureImage)mainTexture, (TextureImage)logMask);
                            textureImage = planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                            if (logTexture == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (logTexture != null) {
                                    try {
                                        logTexture.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                EveryCompat.LOGGER.error("Failed to apply overlays & generate texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                                return mainTexture;
                            }
                        }
                        logTexture.close();
                    }
                    return textureImage;
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate texture with logOverlay: ", (Throwable)e);
        }
    }

    public static void applyLogAndGenerateTexture(ResourceLocation baseTextureLoc, ResourceLocation maskLoc, String shortenedId, String oldTypeName, ResourceSink sink, ResourceManager manager) {
        try (TextureImage mainTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)baseTextureLoc);
             TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)maskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                String newPath = TextureUtility.modifyTexturePath(baseTextureLoc.m_135815_(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newPath, () -> {
                    TextureImage textureImage;
                    block8: {
                        TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)woodType.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                        try {
                            TextureImage logOverlay = logTexture.makeCopy();
                            TextureOps.applyMask((TextureImage)logOverlay, (TextureImage)mask);
                            TextureImage finishedTexture = mainTexture.makeCopy();
                            TextureOps.applyOverlay((TextureImage)finishedTexture, (TextureImage[])new TextureImage[]{logOverlay});
                            textureImage = finishedTexture;
                            if (logTexture == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (logTexture != null) {
                                    try {
                                        logTexture.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                EveryCompat.LOGGER.error("Failed to apply overlays to texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                                return mainTexture;
                            }
                        }
                        logTexture.close();
                    }
                    return textureImage;
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate texture: ", (Throwable)e);
        }
    }

    public record Quartet<L extends String, ML extends String, MR extends String, R extends PaletteStrategy>(L baseTexture, ML logMask, MR planksMask, R logPaletteStrategy) {
        public static <A extends String, B extends String, C extends String, D extends PaletteStrategy> Quartet<A, B, C, D> of(A baseTexture, B logMask, C planksMask, D paletteStrategy) {
            return new Quartet<A, B, C, D>(baseTexture, logMask, planksMask, paletteStrategy);
        }
    }
}

