/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ECNetworking {
    private static int lastInd = 0;

    public static void init() {
        NetworkHelper.addNetworkRegistration(ECNetworking::registerMessages, (int)3);
    }

    private static void registerMessages(NetworkHelper.RegisterMessagesEvent event) {
        event.registerBidirectional(S2CModVersionCheckMessage.CODEC);
        event.registerClientBound(S2CBlockStateCheckMessage.CODEC);
    }

    public static void sendPacket(ServerPlayer s) {
        if (ECConfigs.DEBUG_PACKET.get().booleanValue() || PlatHelper.isDev()) {
            lastInd = 0;
            EveryCompat.LOGGER.warn("Starting Blockstate Map validity check:");
            while (lastInd < Block.BLOCK_STATE_REGISTRY.size()) {
                NetworkHelper.sendToClientPlayer((ServerPlayer)s, (CustomPacketPayload)new S2CBlockStateCheckMessage());
            }
        }
    }

    public static class S2CModVersionCheckMessage
    implements Message {
        public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, S2CModVersionCheckMessage> CODEC = Message.makeType((ResourceLocation)EveryCompat.res("mod_version_check"), S2CModVersionCheckMessage::new);
        private final Map<String, String> mods = new HashMap<String, String>();

        public S2CModVersionCheckMessage() {
            for (String m : EveryCompat.getDependencies()) {
                String v = PlatHelper.getModVersion((String)m);
                if (v == null) continue;
                this.mods.put(m, v);
            }
        }

        public S2CModVersionCheckMessage(RegistryFriendlyByteBuf buf) {
            this.mods.putAll(buf.readMap(buf1 -> buf.readUtf(), buf1 -> buf.readUtf()));
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeMap(this.mods, (buf1, s) -> buf.writeUtf(s), (buf1, s) -> buf.writeUtf(s));
        }

        public void handle(Message.Context context) {
            for (Map.Entry<String, String> m : this.mods.entrySet()) {
                String clientVersion = PlatHelper.getModVersion((String)m.getKey());
                String serverVersion = m.getValue();
                if (Objects.equals(serverVersion, clientVersion)) continue;
                context.disconnect((Component)Component.literal((String)("EveryCompat has detected that server has mismatched mod versions for mod " + m.getKey() + ": requested version " + serverVersion + ", actual version " + clientVersion)));
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CODEC.type();
        }
    }

    public static class S2CBlockStateCheckMessage
    implements Message {
        public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, S2CBlockStateCheckMessage> CODEC = Message.makeType((ResourceLocation)EveryCompat.res("blockstate_check"), S2CBlockStateCheckMessage::new);

        public S2CBlockStateCheckMessage(RegistryFriendlyByteBuf buf) {
            int start = buf.readVarInt();
            int size = buf.readVarInt();
            boolean mismatched = false;
            for (int i = start; i < start + size; ++i) {
                try {
                    BlockState exp;
                    BlockState b;
                    CompoundTag nbt = buf.readNbt();
                    if (nbt == null) {
                        boolean bl = true;
                    }
                    if ((b = Utils.readBlockState((CompoundTag)nbt, null)) != (exp = (BlockState)Block.BLOCK_STATE_REGISTRY.byId(i))) {
                        if (!mismatched) {
                            EveryCompat.LOGGER.error("Found blockstate id mismatch from {}at id {}. Was expecting: {}", (Object)b, (Object)i, (Object)exp);
                        }
                        mismatched = true;
                        continue;
                    }
                    if (mismatched) {
                        EveryCompat.LOGGER.error("to{}at id {}", (Object)b, (Object)i);
                    }
                    mismatched = false;
                    continue;
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read blockstate in id map: ", (Throwable)e);
                    break;
                }
            }
            buf.release();
        }

        public S2CBlockStateCheckMessage() {
        }

        public void write(RegistryFriendlyByteBuf buf) {
            FriendlyByteBuf dummy = new FriendlyByteBuf(Unpooled.buffer());
            int start = lastInd;
            int i = lastInd;
            while (i < Block.BLOCK_STATE_REGISTRY.size()) {
                ++lastInd;
                CompoundTag nbt = NbtUtils.writeBlockState((BlockState)Block.stateById((int)i));
                dummy.writeNbt((Tag)nbt);
                if ((double)dummy.writerIndex() > 943718.4) break;
                ++i;
            }
            buf.writeVarInt(start);
            buf.writeVarInt(lastInd - start);
            buf.writeBytes((ByteBuf)dummy);
            dummy.release();
        }

        public void handle(Message.Context context) {
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CODEC.type();
        }
    }
}

