package net.mehvahdjukaar.every_compat.fabric;

import net.fabricmc.api.ModInitializer;
import net.mehvahdjukaar.every_compat.EveryCompatCommon;
import net.mehvahdjukaar.every_compat.modules.fabric.beautify_decorate.BeautifyRefabricatedModule;
import net.mehvahdjukaar.every_compat.modules.fabric.bewitchment.BewitchmentModule;
import net.mehvahdjukaar.every_compat.modules.fabric.building_but_better.BuildingButBetterModule;
import net.mehvahdjukaar.every_compat.modules.fabric.clutter.ClutterModule;
import net.mehvahdjukaar.every_compat.modules.fabric.create.CreateModule;
import net.mehvahdjukaar.every_compat.modules.fabric.dramatic_doors.DramaticDoorsMacawModule;
import net.mehvahdjukaar.every_compat.modules.fabric.dramatic_doors.DramaticDoorsModule;
import net.mehvahdjukaar.every_compat.modules.fabric.excessive_building.ExcessiveBuildingModule;
import net.mehvahdjukaar.every_compat.modules.fabric.exlines.AwningModule;
import net.mehvahdjukaar.every_compat.modules.fabric.infinitybuttons.InfinityButtonsModule;
import net.mehvahdjukaar.every_compat.modules.fabric.lauchs.LauchsShuttersModule;
import net.mehvahdjukaar.every_compat.modules.fabric.lightmans_currency.LightmansCurrencyModule;
import net.mehvahdjukaar.every_compat.modules.fabric.mcaw.*;
import net.mehvahdjukaar.every_compat.modules.fabric.mrcrayfish.MightyMailModule;
import net.mehvahdjukaar.every_compat.modules.fabric.red_bits.RedBitsModule;
import net.mehvahdjukaar.every_compat.modules.fabric.regions_unexplored.RegionsUnexploredModule;
import net.mehvahdjukaar.every_compat.modules.fabric.storage_delight.StorageDelightModule;
import net.mehvahdjukaar.every_compat.modules.fabric.wilder_wild.WilderWildModule;
import net.mehvahdjukaar.every_compat.modules.fabric.wooden_hoppers.WoodenHoppersModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;

import static net.mehvahdjukaar.every_compat.EveryCompat.addIfLoaded;
import static net.mehvahdjukaar.every_compat.configs.UnsafeDisablerConfigs.INCLUDE_ALL_WOOD_MODULES;

public class EveryCompatFabric extends EveryCompatCommon implements ModInitializer {

    @Override
    public void onInitialize() {
        this.initialize();

        if (PlatHelper.getPhysicalSide().isClient()) {
            EveryCompatFabricClient.init();

        }
    }

    @Override
    protected void addModules() {
        super.addModules();

//!!================================================ Add Modules ==================================================== \\

        if (INCLUDE_ALL_WOOD_MODULES.get()) {

            // ========================================= MACAW's ======================================================== \\
            addIfLoaded("mcwbridges", () -> MacawBridgesModule::new);
            addIfLoaded("mcwdoors", () -> MacawDoorsModule::new);
            addIfLoaded("mcwfences", () -> MacawFencesModule::new);
            addIfLoaded("mcwlights", () -> MacawLightsModule::new);
            addIfLoaded("mcwpaths", () -> MacawPathsModule::new);
            addIfLoaded("mcwroofs", () -> MacawRoofsModule::new);
            addIfLoaded("mcwtrpdoors", () -> MacawTrapdoorsModule::new);
            addIfLoaded("mcwwindows", () -> MacawWindowsModule::new);
            addIfLoaded("mcwfurnitures", () -> MacawFurnitureModule::new);
            addIfLoaded("mcwstairs", () -> MacawStairsModule::new);

            // ========================================= GENERAL ======================================================== \\
            addIfLoaded("bbb", () -> BuildingButBetterModule::new);
            addIfLoaded("beautify", () -> BeautifyRefabricatedModule::new);
            addIfLoaded("bewitchment", () -> BewitchmentModule::new);
            addIfLoaded("clutter", () -> ClutterModule::new);
            addIfLoaded("create", () -> CreateModule::new);
            addIfLoaded("dramaticdoors", () -> DramaticDoorsModule::new);
            addIfLoaded("excessive_building", () -> ExcessiveBuildingModule::new);
            addIfLoaded("exlineawnings", () -> AwningModule::new);
            addIfLoaded("infinitybuttons", () -> InfinityButtonsModule::new);
            addIfLoaded("lightmanscurrency", () -> LightmansCurrencyModule::new);
            addIfLoaded("mighty_mail", () -> MightyMailModule::new);
            addIfLoaded("redbits", () -> RedBitsModule::new);
            addIfLoaded("regions_unexplored", () -> RegionsUnexploredModule::new);
            addIfLoaded("storagedelight", () -> StorageDelightModule::new);
            addIfLoaded("shutter", () -> LauchsShuttersModule::new);
            addIfLoaded("wilderwild", () -> WilderWildModule::new);
            addIfLoaded("woodenhoppers", () -> WoodenHoppersModule::new);

            if (PlatHelper.isModLoaded("mcwdoors")) addIfLoaded("dramaticdoors", () -> DramaticDoorsMacawModule::new);

        }

// ============================================== DISABLED FOR A REASON ============================================= \\
//        addModule("twilightforest", () -> TwilightForestModule::new); //!! NOT AVAILABLE
//        addModule("architects_palette", () -> ArchitectsPaletteModule::new); //!! NOT AVAILABLE

    }
}
