package net.mehvahdjukaar.every_compat.modules.fabric.mcaw;

import net.kikoz.mcwtrpdoors.MacawsTrapdoors;
import net.kikoz.mcwtrpdoors.init.BlockInit;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2533;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7924;


//SUPPORT: v1.1.2+
public class MacawTrapdoorsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> BARK_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BARN_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BARRED_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BEACH_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> CLASSIC_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> COTTAGE_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> FOUR_PANEL_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> GLASS_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> MESH_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> MYSTIC_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> PAPER_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> RANCH_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> SWAMP_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> TROPICAL_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> WAFFLE_TRAPDOORS;
    public final SimpleEntrySet<WoodType, class_2248> BARREL_TRAPDOORS;

    public MacawTrapdoorsModule(String modId) {
        super(modId, "mct");

        var tab = MacawsTrapdoors.TRAPDOORSGROUP;

        BARK_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "bark_trapdoor",
                        () -> BlockInit.OAK_BARK_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.log).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                //TEXTURES: log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("bark_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(BARK_TRAPDOORS);

        BARN_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "barn_trapdoor",
                        () -> BlockInit.OAK_BARN_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("barn_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/barn/oak_barn_trapdoor"))
                .build();
        this.addEntry(BARN_TRAPDOORS);

        BARRED_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "barred_trapdoor",
                        () -> BlockInit.OAK_BARRED_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("barred_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/barred/oak_barred_trapdoor"))
                .build();
        this.addEntry(BARRED_TRAPDOORS);

        BEACH_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "beach_trapdoor",
                        () -> BlockInit.OAK_BEACH_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("beach_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTextureM(modRes("block/beach/oak_beach_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_beach_trapdoor_m"))
                .build();
        this.addEntry(BEACH_TRAPDOORS);

        CLASSIC_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "classic_trapdoor",
                        () -> BlockInit.SPRUCE_CLASSIC_TRAPDOOR, () -> VanillaWoodTypes.SPRUCE,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("classic_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/classic/spruce_classic_trapdoor"))
                .build();
        this.addEntry(CLASSIC_TRAPDOORS);

        COTTAGE_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "cottage_trapdoor",
                        () -> BlockInit.OAK_COTTAGE_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks),w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("cottage_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTextureM(modRes("block/cottage/oak_cottage_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_cottage_trapdoor_m"))
                .build();
        this.addEntry(COTTAGE_TRAPDOORS);

        FOUR_PANEL_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "four_panel_trapdoor",
                        () -> BlockInit.OAK_FOUR_PANEL_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks),w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("four_panel_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/four_panel/oak_four_panel_trapdoor"))
                .build();
        this.addEntry(FOUR_PANEL_TRAPDOORS);

        GLASS_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "glass_trapdoor",
                        () -> BlockInit.OAK_GLASS_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("glass_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .createPaletteFromPlanks(p -> p.remove(p.getDarkest()))
                .addTextureM(modRes("block/glass/oak_glass_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_glass_trapdoor_m"))
                .build();
        this.addEntry(GLASS_TRAPDOORS);

        MESH_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "bamboo_trapdoor",
                        () -> BlockInit.OAK_BAMBOO_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("bamboo_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .addTexture(modRes("block/bamboo/oak_bamboo_trapdoor"))
                .createPaletteFromPlanks(p -> p.remove(p.getDarkest()))
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(MESH_TRAPDOORS);

        MYSTIC_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "mystic_trapdoor",
                        () -> BlockInit.OAK_MYSTIC_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("mystic_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/mystic/oak_mystic_trapdoor"))
                .build();
        this.addEntry(MYSTIC_TRAPDOORS);

        PAPER_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "paper_trapdoor",
                        () -> BlockInit.OAK_PAPER_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks),w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("paper_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .createPaletteFromPlanks(p -> p.remove(p.getDarkest()))
                .addTextureM(modRes("block/paper/oak_paper_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_paper_trapdoor_m"))
                .build();
        this.addEntry(PAPER_TRAPDOORS);

        RANCH_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "ranch_trapdoor",
                        () -> BlockInit.OAK_RANCH_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.log).method_22488(),w.toVanillaOrOak().comp_1300()){}
                )
                .requiresChildren("stripped_log") //REASON: textures
                //TEXTURES: log, stripped_log
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("ranch_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(RANCH_TRAPDOORS);

        SWAMP_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "swamp_trapdoor",
                        () -> BlockInit.OAK_SWAMP_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("swamp_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .createPaletteFromPlanks(this::swampTrapdoorPalette)
                .addTexture(modRes("block/swamp/oak_swamp_trapdoor"))
                .build();
        this.addEntry(SWAMP_TRAPDOORS);

        TROPICAL_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "tropical_trapdoor",
                        () -> BlockInit.OAK_TROPICAL_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("tropical_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTextureM(modRes("block/tropical/oak_tropical_trapdoor"), EveryCompat.res("block/mcw/trapdoors/oak_tropical_trapdoor_m"))
                .build();
        this.addEntry(TROPICAL_TRAPDOORS);

        WAFFLE_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "blossom_trapdoor",
                        () -> BlockInit.OAK_BLOSSOM_TRAPDOOR, () -> VanillaWoodTypes.OAK,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTexture(modRes("block/blossom/oak_blossom_trapdoor"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("blossom_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT)
                .defaultRecipe()
                .build();
        this.addEntry(WAFFLE_TRAPDOORS);

        BARREL_TRAPDOORS = SimpleEntrySet.builder(WoodType.class, "barrel_trapdoor",
                        () -> BlockInit.SPRUCE_BARREL_TRAPDOOR, () -> VanillaWoodTypes.SPRUCE,
                        w -> new class_2533(Utils.copyPropertySafe(w.planks).method_22488(), w.toVanillaOrOak().comp_1300()){}
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15487, class_7924.field_41254)
                .addTag(class_3481.field_15491, class_7924.field_41254)
                .addTag(modRes("barrel_trapdoors"), class_7924.field_41254)
                .addTag(class_3489.field_15548, class_7924.field_41197)
                .addTag(class_3489.field_15550, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT)
                .addTexture(modRes("block/barrel/spruce_barrel_trapdoor"))
                .build();
        this.addEntry(BARREL_TRAPDOORS);

    }

    private void swampTrapdoorPalette(Palette p) {
        p.remove(p.getDarkest());
        p.remove(p.getDarkest());
    }
}
