package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_7924;
import vectorwing.farmersdelight.common.block.CabinetBlock;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;

// SUPPORT: FABRIC-v2.4.0+ | FORGE-v1.2.8+
public class FarmersDelightModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> cabinets;

    public FarmersDelightModule(String modId) {
        super(modId, "fd");

        cabinets = SimpleEntrySet.builder(WoodType.class, "cabinet",
                        getModBlock("oak_cabinet"), () -> VanillaWoodTypes.OAK,
                        w -> new CabinetBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("trapdoor", "slab") //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("cabinets/wooden"), class_7924.field_41197)
                .defaultRecipe()
                .addTile(getModTile("cabinet"))
                .setTabKey(modRes("farmersdelight"))
                .setTabMode(TabAddMode.AFTER_SAME_TYPE)
                .createPaletteFromPlanks(p -> {
                    p.reduceDown();
                    if (p.size() < 9) {
                        while (p.size() <= 9) {
                            p.increaseInner();
                        }
                    }
                    else {
                        while (p.size() >= 9) {
                            p.reduce();
                        }
                    }
                })
                .addTextureM(modRes("block/oak_cabinet_front"), EveryCompat.res("block/fd/oak_cabinet_front_m"))
                .addTexture(modRes("block/oak_cabinet_side"))
                .addTexture(modRes("block/oak_cabinet_top"))
                .addTexture(modRes("block/oak_cabinet_front_open"))
                .build();
        this.addEntry(cabinets);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        executor.accept((manager, handler) -> {
            // Creating cutting_board recipes
            cabinets.items.forEach(((woodType, item) -> {

                createCuttingRecipe("door", woodType.getBlockOfThis("door"), woodType.planks,
                        woodType, handler, manager);
                createCuttingRecipe("hanging_sign", woodType.getBlockOfThis("hanging_sign"), woodType.planks,
                        woodType, handler, manager);
                createCuttingRecipe("sign", woodType.getBlockOfThis("sign"), woodType.planks,
                        woodType, handler, manager);
                createCuttingRecipe("trapdoor", woodType.getBlockOfThis("trapdoor"), woodType.planks,
                        woodType, handler, manager);
                createCuttingRecipe("log", woodType.log, woodType.getBlockOfThis("stripped_log"),
                        woodType, handler, manager);
                createCuttingRecipe("wood", woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"),
                        woodType, handler, manager);

            }));
        });
    }

    public void createCuttingRecipe(String recipeType, class_2248 input, class_2248 output,
                                    WoodType woodType, ResourceSink handler, class_3300 manager) {

        if (Objects.nonNull(input) && Objects.nonNull(output)) {
        class_2960 recipeLocation = modRes("recipes/cutting/oak_"+recipeType+".json");

            try (InputStream recipeStream = manager.method_14486(recipeLocation)
                    .orElseThrow(() -> new FileNotFoundException(recipeLocation.toString())).method_14482()) {
                JsonObject recipe = RPUtils.deserializeJson(recipeStream);

                // EDITING RECIPE
                JsonObject getItem = recipe.getAsJsonArray("ingredients").get(0).getAsJsonObject();
                getItem.addProperty("item", Utils.getID(input).toString());

                JsonObject getResult = recipe.getAsJsonArray("result").get(0).getAsJsonObject();
                getResult.addProperty("item", Utils.getID(output).toString());

                // Adding to ResourceLocation
                String path = this.shortenedId() + "/cutting/" + woodType.getAppendableId() +"_"+recipeType;

                handler.addJson(EveryCompat.res(path), recipe, ResType.RECIPES);
            } catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate the cutting recipe for {} - {}", Utils.getID(output), e);
            }
        }
    }
}
