/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

public class TagUtility {
    public static ResourceLocation getATagOrCreateANew(String suffixTag, String suffixAlt, WoodType wood, ServerDynamicResourcesHandler handler, ResourceManager manager) {
        String resLocMOD = wood.getNamespace() + ":" + wood.getTypeName();
        ResourceLocation RLocLogs = ResourceLocation.parse((String)(resLocMOD + "_" + suffixTag));
        ResourceLocation RLocStems = ResourceLocation.parse((String)(resLocMOD + "_" + suffixAlt));
        ResourceLocation RLocFolders = ResourceLocation.parse((String)(wood.getNamespace() + ":" + suffixTag + "/" + wood.getTypeName()));
        ResourceLocation RLocEC = EveryCompat.res(wood.getAppendableId() + "_" + suffixTag);
        if (manager.getResource(ResType.TAGS.getPath(RLocLogs.withPrefix("blocks/"))).isPresent()) {
            return RLocLogs;
        }
        if (manager.getResource(ResType.TAGS.getPath(RLocStems.withPrefix("blocks/"))).isPresent()) {
            return RLocStems;
        }
        if (manager.getResource(ResType.TAGS.getPath(RLocEC.withPrefix("blocks/"))).isPresent()) {
            return RLocEC;
        }
        if (manager.getResource(ResType.TAGS.getPath(RLocFolders.withPrefix("blocks/"))).isPresent()) {
            return RLocFolders;
        }
        TagUtility.createAndAddDefaultTags(RLocEC, handler, wood);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(ResourceLocation resLoc, ServerDynamicResourcesHandler handler, WoodType wood) {
        return TagUtility.createAndAddCustomTags(resLoc, handler, wood.log, wood.getBlockOfThis("stripped_log"), wood.getBlockOfThis("wood"), wood.getBlockOfThis("stripped_wood"));
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ServerDynamicResourcesHandler handler, Block ... blocks) {
        boolean containsSomething = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Block block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            containsSomething = true;
        }
        if (containsSomething) {
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, Registries.BLOCK);
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, Registries.ITEM);
        }
        return containsSomething;
    }
}

