/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.beautiful_campfires;

import com.arcanc.bc.content.BlockDatabase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.ToIntFunction;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class BeautifulCampfiresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, CampfireBlock> campfires;
    public final SimpleEntrySet<WoodType, CampfireBlock> soul_campfires;

    public BeautifulCampfiresModule(String modId) {
        super(modId, "bc");
        ResourceKey tab = CreativeModeTabs.FUNCTIONAL_BLOCKS;
        this.campfires = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "campfire", () -> BlockDatabase.CAMPFIRE_ACACIA, () -> WoodTypeRegistry.getValue((ResourceLocation)ResourceLocation.parse((String)"acacia")), w -> new CampfireBlock(true, 1, this.copyProperties(15))).addTile(() -> BlockEntityType.CAMPFIRE).addTextureM(this.modRes("item/acacia_campfire"), EveryCompat.res("item/bc/campfire_m"))).addTextureM(this.modRes("item/acacia_soul_campfire"), EveryCompat.res("item/bc/campfire_m"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.CAMPFIRES, Registries.BLOCK)).setTabKey(tab)).build();
        this.addEntry(this.campfires);
        this.soul_campfires = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "soul_campfire", () -> BlockDatabase.SOUL_CAMPFIRE_ACACIA, () -> WoodTypeRegistry.getValue((ResourceLocation)ResourceLocation.parse((String)"acacia")), w -> new CampfireBlock(true, 2, this.copyProperties(10))).addTile(() -> BlockEntityType.CAMPFIRE).createPaletteFromChild("log")).addTextureM(this.modRes("block/acacia_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"))).addTextureM(this.modRes("block/acacia_soul_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.CAMPFIRES, Registries.BLOCK)).addTag(BlockTags.PIGLIN_REPELLENTS, Registries.BLOCK)).setTabKey(tab)).build();
        this.addEntry(this.soul_campfires);
    }

    public BlockBehaviour.Properties copyProperties(int pLightValue) {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(BeautifulCampfiresModule.litBlockEmission(pLightValue)).noOcclusion().ignitedByLava();
    }

    @NotNull
    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? pLightValue : 0;
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        ResourceLocation campfireLoc = this.modRes("acacia_campfire");
        ResourceLocation soulCampfireLoc = this.modRes("acacia_soul_campfire");
        this.campfires.blocks.forEach((wood, block) -> {
            this.createRecipe("campfire", (WoodType)wood, (Block)block, campfireLoc, handler, manager);
            this.createRecipe("soul_campfire", (WoodType)wood, (Block)this.soul_campfires.blocks.get(wood), soulCampfireLoc, handler, manager);
        });
    }

    public void createRecipe(String recipeName, WoodType woodType, Block output, ResourceLocation recipeLoc, ServerDynamicResourcesHandler handler, ResourceManager manager) {
        try (InputStream recipeStream = ((Resource)manager.getResource(ResType.RECIPES.getPath(recipeLoc)).orElseThrow(() -> new FileNotFoundException("Failed to open the recipe @ " + String.valueOf(recipeLoc)))).open();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            recipe.getAsJsonObject("key").getAsJsonObject("L").addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", woodType, handler, manager).toString());
            recipe.getAsJsonObject("result").addProperty("item", Utils.getID((Block)output).toString());
            ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(this.shortenedId() + "/" + woodType.getAppendableId() + "_" + recipeName), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to generate the recipe @ {} : {}", (Object)recipeLoc, (Object)e);
        }
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        String campfirePath = "block/acacia_campfire_log";
        ResourceLocation campfireImage = this.modRes(campfirePath);
        ResourceLocation targetLogMask = EveryCompat.res("block/bc/campfire_log_m");
        ResourceLocation targetPlankMask = EveryCompat.res("block/bc/campfire_plank_m");
        try (TextureImage textureImage = TextureImage.open((ResourceManager)manager, (ResourceLocation)campfireImage);
             TextureImage targetLogImage = TextureImage.open((ResourceManager)manager, (ResourceLocation)targetLogMask);
             TextureImage targetPlankImage = TextureImage.open((ResourceManager)manager, (ResourceLocation)targetPlankMask);){
            this.campfires.blocks.forEach((wood, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));
                     TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log));){
                    ResourceLocation newResLoc = EveryCompat.res(BlockTypeResTransformer.replaceTypeNoNamespace((String)campfirePath, (BlockType)wood, (ResourceLocation)id, (String)"acacia"));
                    Respriter respriterLog = Respriter.masked((TextureImage)textureImage, (TextureImage)targetLogImage);
                    TextureImage recoloredLog = respriterLog.recolorWithAnimationOf(logTexture);
                    Respriter respriterPlank = Respriter.masked((TextureImage)recoloredLog, (TextureImage)targetPlankImage);
                    TextureImage finishedImage = respriterPlank.recolorWithAnimationOf(plankTexture);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(newResLoc, finishedImage);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to open log/plank texture file: ", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to open texture file: ", (Throwable)e);
        }
    }
}

