/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.commons.lang3.function.TriFunction;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.item.FuelBlockItem;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FarmersDelightModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> cabinets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cabinet", this.getModBlock("oak_cabinet"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CabinetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL))).addCustomItem((TriFunction<WoodType, Block, Item.Properties, Item>)((TriFunction)(w, block, p) -> new FuelBlockItem(block, ModItems.basicItem(), 300))).addTag(this.modRes("cabinets"), Registries.ITEM)).addTag(this.modRes("cabinets/wooden"), Registries.ITEM)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).defaultRecipe().addTile(this.getModTile("cabinet")).setTabKey(this.modRes("farmersdelight"))).setTabMode(TabAddMode.AFTER_SAME_TYPE)).createPaletteFromPlanks(Palette::increaseDown)).addTexture(EveryCompat.res("block/oak_cabinet_front"))).addTexture(EveryCompat.res("block/oak_cabinet_side"))).addTexture(EveryCompat.res("block/oak_cabinet_top"))).addTextureM(EveryCompat.res("block/oak_cabinet_front_open"), EveryCompat.res("block/oak_cabinet_front_open_m"))).build();

    public FarmersDelightModule(String modId) {
        super(modId, "fd");
        this.addEntry(this.cabinets);
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        for (WoodType woodType : WoodTypeRegistry.getTypes()) {
            if (woodType.isVanilla()) continue;
            this.createCuttingRecipe("door", woodType.getBlockOfThis("door"), woodType.planks, woodType, handler, manager);
            this.createCuttingRecipe("hanging_sign", woodType.getBlockOfThis("hanging_sign"), woodType.planks, woodType, handler, manager);
            this.createCuttingRecipe("sign", woodType.getBlockOfThis("sign"), woodType.planks, woodType, handler, manager);
            this.createCuttingRecipe("trapdoor", woodType.getBlockOfThis("trapdoor"), woodType.planks, woodType, handler, manager);
            this.createCuttingRecipe("log", woodType.log, woodType.getBlockOfThis("stripped_log"), woodType, handler, manager);
            this.createCuttingRecipe("wood", woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"), woodType, handler, manager);
        }
    }

    public void createCuttingRecipe(String recipeType, Block input, Block output, WoodType woodType, ServerDynamicResourcesHandler handler, ResourceManager manager) {
        if (Objects.nonNull(input) && Objects.nonNull(output)) {
            ResourceLocation recipeLocation = ResType.RECIPES.getPath(this.modRes("cutting/oak_" + recipeType));
            try (InputStream recipeStream = ((Resource)manager.getResource(recipeLocation).orElseThrow(() -> new FileNotFoundException(recipeLocation.toString()))).open();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
                JsonObject underIngredients = recipe.getAsJsonArray("ingredients").get(0).getAsJsonObject();
                underIngredients.addProperty("item", Utils.getID((Block)input).toString());
                JsonObject underResult = recipe.getAsJsonArray("result").get(0).getAsJsonObject().getAsJsonObject("item");
                underResult.addProperty("id", Utils.getID((Block)output).toString());
                String path = this.shortenedId() + "/cutting/" + woodType.getAppendableId() + "_" + recipeType;
                ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(path), (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                handler.getLogger().error("Failed to generate the cutting recipe for {} - {}", (Object)Utils.getID((Block)output), (Object)e);
            }
        }
    }
}

