/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.abnormal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamabnormals.blueprint.common.block.BlueprintBeehiveBlock;
import com.teamabnormals.blueprint.common.block.LeafPileBlock;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

public class WoodworksModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> chiseled_bookshelves;
    public final SimpleEntrySet<WoodType, Block> boards;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> beehives;
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> leafPiles;

    public WoodworksModule(String modId) {
        super(modId, "abnww");
        ResourceKey tab = CreativeModeTabs.BUILDING_BLOCKS;
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", this.getModBlock("acacia_bookshelf"), () -> WoodTypeRegistry.getValue((ResourceLocation)ResourceLocation.parse((String)"acacia")), w -> new Block(WoodworksBlocks.WoodworksProperties.ACACIA_WOOD.bookshelf())).setTabKey(tab)).copyParentDrop().addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(Tags.Blocks.BOOKSHELVES, Registries.BLOCK)).addTag(Tags.Items.BOOKSHELVES, Registries.ITEM)).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).defaultRecipe().build();
        this.addEntry(this.bookshelves);
        this.chiseled_bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", "chiseled", this.getModBlock("chiseled_acacia_bookshelf"), () -> WoodTypeRegistry.getValue((ResourceLocation)ResourceLocation.parse((String)"acacia")), w -> new ChiseledBookShelfBlock(WoodworksBlocks.WoodworksProperties.ACACIA_WOOD.chiseledBookshelf())).setTabKey(tab)).copyParentDrop().addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(Tags.Blocks.BOOKSHELVES, Registries.BLOCK)).addTag(Tags.Items.BOOKSHELVES, Registries.ITEM)).addTexture(this.modRes("block/chiseled_acacia_bookshelf_empty"))).addTextureM(this.modRes("block/chiseled_acacia_bookshelf_occupied"), EveryCompat.res("block/acacia_chiseled_bookshelf_occupied_m"))).addTexture(this.modRes("block/chiseled_acacia_bookshelf_side"))).addTexture(this.modRes("block/chiseled_acacia_bookshelf_top"))).defaultRecipe().build();
        this.addEntry(this.chiseled_bookshelves);
        this.boards = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "boards", this.getModBlock("oak_boards"), () -> WoodTypeRegistry.OAK_TYPE, w -> new RotatedPillarBlock(Utils.copyPropertySafe((Block)w.planks))).setTabKey(tab)).copyParentDrop().addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTexture(this.modRes("block/oak_boards"))).defaultRecipe().build();
        this.addEntry(this.boards);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "ladder", this.getModBlock("spruce_ladder"), () -> WoodTypeRegistry.getValue((ResourceLocation)ResourceLocation.parse((String)"spruce")), w -> new LadderBlock(WoodworksBlocks.WoodworksProperties.SPRUCE_WOOD.ladder())).setTabKey(tab)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.CLIMBABLE, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"quark:ladders"), Registries.BLOCK)).addTag(ResourceLocation.parse((String)"quark:ladders"), Registries.ITEM)).defaultRecipe().addTexture(EveryCompat.res("block/spruce_ladder"))).build();
        this.addEntry(this.ladders);
        this.beehives = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "beehive", this.getModBlock("spruce_beehive"), () -> WoodTypeRegistry.getValue((ResourceLocation)ResourceLocation.parse((String)"spruce")), w -> new BlueprintBeehiveBlock(WoodworksBlocks.WoodworksProperties.OAK_WOOD.beehive())).setTabKey(tab)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.BEEHIVES, Registries.BLOCK)).defaultRecipe().addTile(this.getModTile("beehive")).addTextureM(EveryCompat.res("block/spruce_beehive_front_honey"), EveryCompat.res("block/spruce_beehive_front_honey_m"))).addTextureM(EveryCompat.res("block/spruce_beehive_front"), EveryCompat.res("block/spruce_beehive_front_m"))).addTextureM(EveryCompat.res("block/spruce_beehive_side"), EveryCompat.res("block/spruce_beehive_side_m"))).addTexture(EveryCompat.res("block/spruce_beehive_end"))).build();
        this.addEntry(this.beehives);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", this.getModBlock("oak_chest"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CompatChestBlock(this::getChestTile, WoodworksBlocks.WoodworksProperties.OAK_WOOD.chest())).setTabKey(tab)).addTag(Tags.Blocks.CHESTS_WOODEN, Registries.BLOCK)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(Tags.Items.CHESTS_WOODEN, Registries.ITEM)).addTag(ResourceLocation.parse((String)"quark:revertable_chests"), Registries.ITEM)).addTag(ResourceLocation.parse((String)"quark:boatable_chests"), Registries.ITEM)).addTile((x$0, x$1) -> new abwwChestBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).defaultRecipe().build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", "trapped", this.getModBlock("trapped_oak_chest"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CompatTrappedChestBlock(this::getTrappedTile, WoodworksBlocks.WoodworksProperties.OAK_WOOD.chest())).setTabKey(tab)).addTag(Tags.Blocks.CHESTS_TRAPPED, Registries.BLOCK)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(Tags.Items.CHESTS_TRAPPED, Registries.ITEM)).addTile((x$0, x$1) -> new abwwTrappedBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).defaultRecipe().build();
        this.addEntry(this.trappedChests);
        this.leafPiles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "leaf_pile", this.getModBlock("oak_leaf_pile"), () -> LeavesTypeRegistry.OAK_TYPE, w -> {
            if (w.getWoodType() == null) {
                return null;
            }
            return new LeafPileBlock(WoodworksBlocks.WoodworksProperties.OAK_WOOD.leafPile());
        }).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))).addTag(BlockTags.MINEABLE_WITH_HOE, Registries.BLOCK)).addTag(this.modRes("leaf_piles"), Registries.BLOCK)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).copyParentDrop().defaultRecipe().copyParentTint()).build();
        this.addEntry(this.leafPiles);
    }

    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return this.trappedChests.getTile(CompatChestBlockEntity.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
        CompatChestBlockRenderer.register(event, this.trappedChests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        this.bookshelves.items.forEach((wood, item) -> {
            Item getLadder = (Item)this.ladders.items.get(wood);
            Item ladder = getLadder != null ? getLadder : (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)wood.getNamespace(), (String)(wood.getTypeName() + "_ladder")));
            this.sawmillRecipe("oak_planks_from_oak_logs_sawing", wood.log.asItem(), wood.planks.asItem(), handler, manager, (WoodType)wood);
            this.sawmillRecipe("oak_boards_from_oak_logs_sawing", wood.log.asItem(), (Item)this.boards.items.get(wood), handler, manager, (WoodType)wood);
            this.sawmillRecipe("spruce_ladder_from_spruce_logs_sawing", wood.log.asItem(), ladder, handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_button_from_oak_logs_sawing", true, "button", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_door_from_oak_logs_sawing", true, "door", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_fence_from_oak_logs_sawing", true, "fence", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_fence_gate_from_oak_logs_sawing", true, "fence_gate", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_pressure_plate_from_oak_logs_sawing", true, "pressure_plate", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_sign_from_oak_logs_sawing", true, "sign", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_slab_from_oak_logs_sawing", true, "slab", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_stairs_from_oak_logs_sawing", true, "stairs", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_trapdoor_from_oak_logs_sawing", true, "trapdoor", handler, manager, (WoodType)wood);
            this.sawmillRecipe("oak_boards_from_oak_planks_sawing", wood.planks.asItem(), (Item)this.boards.items.get(wood), handler, manager, (WoodType)wood);
            this.sawmillRecipe("spruce_ladder_from_spruce_planks_sawing", wood.planks.asItem(), ladder, handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_button_from_oak_planks_sawing", false, "button", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_fence_from_oak_planks_sawing", false, "fence", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_slab_from_oak_planks_sawing", false, "slab", handler, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_stairs_from_oak_planks_sawing", false, "stairs", handler, manager, (WoodType)wood);
        });
    }

    public void createRecipeIfNotNull(String recipeName, boolean usingLog, String output, ServerDynamicResourcesHandler handler, ResourceManager manager, WoodType wood) {
        Item input;
        Item item = input = usingLog ? wood.log.asItem() : wood.planks.asItem();
        if (Objects.nonNull(wood.getItemOfThis(output))) {
            this.sawmillRecipe(recipeName, input, wood.getItemOfThis(output), handler, manager, wood);
        } else if (Objects.nonNull(wood.getBlockOfThis(output))) {
            this.sawmillRecipe(recipeName, input, wood.getBlockOfThis(output).asItem(), handler, manager, wood);
        }
    }

    public void sawmillRecipe(String recipeName, Item input, Item output, ServerDynamicResourcesHandler handler, ResourceManager manager, WoodType wood) {
        ResourceLocation recipeLocation = this.modRes("recipes/" + recipeName + ".json");
        JsonObject recipe = null;
        try (InputStream recipeStream = ((Resource)manager.getResource(recipeLocation).get()).open();){
            recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject getRecipe = recipe.getAsJsonArray("recipes").get(0).getAsJsonObject().getAsJsonObject("recipe");
            JsonObject getIngredient = getRecipe.getAsJsonObject("ingredient");
            if (getIngredient.has("tag")) {
                getIngredient.addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", wood, handler, manager).toString());
            } else {
                getIngredient.addProperty("item", Utils.getID((Item)input).toString());
            }
            getRecipe.addProperty("result", Utils.getID((Item)output).toString());
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Woodworks Module/sawmill_recipe() - failed to open the recipe: {0}", (Throwable)e);
        }
        String[] nameSplit = recipeName.split("_(?!gate|plate)");
        String filenameBuilder = "_" + nameSplit[1] + "_from_" + wood.getTypeName() + "_" + nameSplit[4] + "_sawing";
        ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(this.shortenedId() + "/" + wood.getAppendableId() + filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        this.trappedChests.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(handler, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak/normal"), EveryCompat.res("model/oak_chest_normal_m"), EveryCompat.res("model/oak_chest_normal_o"), EveryCompat.res("model/trapped_chest_normal"));
            CompatChestTexture.generateChestTexture(handler, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak/normal_left"), EveryCompat.res("model/oak_chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), EveryCompat.res("model/trapped_chest_left"));
            CompatChestTexture.generateChestTexture(handler, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak/normal_right"), EveryCompat.res("model/oak_chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), EveryCompat.res("model/trapped_chest_right"));
        });
    }

    private class abwwTrappedBlockEntity
    extends CompatChestBlockEntity {
        public abwwTrappedBlockEntity(WoodworksModule woodworksModule, BlockPos pos, BlockState state) {
            super(woodworksModule.trappedChests.getTile(), pos, state);
        }
    }

    private class abwwChestBlockEntity
    extends CompatChestBlockEntity {
        public abwwChestBlockEntity(WoodworksModule woodworksModule, BlockPos pos, BlockState state) {
            super(woodworksModule.chests.getTile(), pos, state);
        }
    }
}

