/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.lieonlion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

public class MoreChestVariantsModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", this.getModBlock("oak_chest"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe((Block)Blocks.CHEST).mapColor(MapColor.WOOD))).addTile((x$0, x$1) -> new MoreChestBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(this.modRes("chests/wooden"), Registries.BLOCK)).addTag(this.modRes("chests/normal"), Registries.BLOCK)).addTag(Tags.Blocks.CHESTS, Registries.BLOCK)).addTag(Tags.Blocks.CHESTS_WOODEN, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"quad:cats_on_blocks/sit"), Registries.BLOCK)).addTag(ResourceLocation.parse((String)"quad:fuel/wood"), Registries.ITEM)).addTag(Tags.Items.CHESTS_WOODEN, Registries.ITEM)).addTag(Tags.Items.CHESTS, Registries.ITEM)).addTag(this.modRes("chests/normal"), Registries.ITEM)).addTag(this.modRes("chests/wooden"), Registries.ITEM)).setTabKey(CreativeModeTabs.FUNCTIONAL_BLOCKS)).defaultRecipe().build();
    public final SimpleEntrySet<WoodType, Block> trappedChests;

    public MoreChestVariantsModule(String modID) {
        super(modID, "lolmcv");
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "trapped_chest", this.getModBlock("oak_trapped_chest"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe((Block)Blocks.TRAPPED_CHEST).mapColor(MapColor.WOOD))).addTile((x$0, x$1) -> new MoreTrappedBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(this.modRes("chests/wooden"), Registries.BLOCK)).addTag(this.modRes("chests/trapped"), Registries.BLOCK)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(Tags.Blocks.CHESTS, Registries.BLOCK)).addTag(Tags.Blocks.CHESTS_WOODEN, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"quad:fuel/wood"), Registries.ITEM)).addTag(this.modRes("chests/trapped"), Registries.ITEM)).addTag(this.modRes("chests/wooden"), Registries.ITEM)).addTag(Tags.Items.CHESTS_WOODEN, Registries.ITEM)).addTag(Tags.Items.CHESTS, Registries.ITEM)).setTabKey(CreativeModeTabs.REDSTONE_BLOCKS)).defaultRecipe().build();
        this.addEntry(this.trappedChests);
    }

    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return this.trappedChests.getTile(CompatChestBlockEntity.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
        CompatChestBlockRenderer.register(event, this.trappedChests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        this.trappedChests.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(handler, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak"), EveryCompat.res("entity/mcv_chest_normal_m"), EveryCompat.res("entity/mcv_chest_normal_o"), EveryCompat.res("entity/mcv_trapped_normal_o"), 0);
            CompatChestTexture.generateChestTexture(handler, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak_left"), EveryCompat.res("entity/mcv_chest_left_m"), EveryCompat.res("entity/mcv_chest_left_o"), EveryCompat.res("entity/mcv_trapped_left_o"), 0);
            CompatChestTexture.generateChestTexture(handler, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak_right"), EveryCompat.res("entity/mcv_chest_right_m"), EveryCompat.res("entity/mcv_chest_right_o"), EveryCompat.res("entity/mcv_trapped_right_o"), 0);
            String path = this.shortenedId() + "/" + wood.getAppendableId() + "_chest";
            String trapped_path = this.shortenedId() + "/" + wood.getAppendableId() + "_trapped_chest";
            this.customModel(path, handler, manager);
            this.customModel(trapped_path, handler, manager);
        });
    }

    public void customModel(String path, ClientDynamicResourcesHandler handler, ResourceManager manager) {
        ResourceLocation modelRLoc = EveryCompat.res("models/block/" + path + ".json");
        if (manager.getResource(modelRLoc).isPresent()) {
            try (InputStream modelStream = ((Resource)manager.getResource(modelRLoc).get()).open();){
                JsonObject modelFile = RPUtils.deserializeJson((InputStream)modelStream);
                String textureID = "everycomp:entity/chest/" + path;
                modelFile.getAsJsonObject("textures").addProperty("wood_type", textureID);
                ((DynamicTexturePack)handler.dynamicPack).addJson(EveryCompat.res(path), (JsonElement)modelFile, ResType.BLOCK_MODELS);
            }
            catch (IOException e) {
                handler.getLogger().error("MoreChestVariantsModule: failed to open the model file: {} - {}", (Object)modelRLoc, (Object)e);
            }
        }
    }

    private class MoreTrappedBlockEntity
    extends CompatChestBlockEntity {
        public MoreTrappedBlockEntity(MoreChestVariantsModule moreChestVariantsModule, BlockPos pos, BlockState state) {
            super(moreChestVariantsModule.trappedChests.getTile(), pos, state);
        }
    }

    private class MoreChestBlockEntity
    extends CompatChestBlockEntity {
        public MoreChestBlockEntity(MoreChestVariantsModule moreChestVariantsModule, BlockPos pos, BlockState state) {
            super(moreChestVariantsModule.chests.getTile(), pos, state);
        }
    }
}

