/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.valhelsia;

import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import java.util.List;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.valhelsia.valhelsia_core.api.common.block.StrippableRotatedPillarBlock;

public class ValhelsiaStructuresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> cutPosts;
    public final SimpleEntrySet<WoodType, Block> cutStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> bundledStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> bundledPosts;

    public ValhelsiaStructuresModule(String modId) {
        super(modId, "vs");
        ResourceLocation tab = this.modRes("main");
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", this.getModBlock("oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> new PostBlock(Utils.copyPropertySafe((Block)w.log))).addTag(this.modRes("posts"), Registries.BLOCK)).addTag(this.modRes("posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.posts);
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "stripped", this.getModBlock("stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            Block stripped = w.getBlockOfThis("stripped_log");
            if (stripped == null) {
                return null;
            }
            return new PostBlock(Utils.copyPropertySafe((Block)w.log));
        }).addTag(this.modRes("stripped_posts"), Registries.BLOCK)).addTag(this.modRes("stripped_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.strippedPosts);
        this.cutPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut", this.getModBlock("cut_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CutPostBlock(ValhelsiaStructuresModule.cutPostProperties(w))).addTag(this.modRes("cut_posts"), Registries.BLOCK)).addTag(this.modRes("cut_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutPosts);
        this.cutStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut_stripped", this.getModBlock("cut_stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            Block stripped = w.getBlockOfThis("stripped_log");
            if (stripped == null) {
                return null;
            }
            return new CutPostBlock(ValhelsiaStructuresModule.cutPostProperties(w));
        }).addTag(this.modRes("cut_stripped_posts"), Registries.BLOCK)).addTag(this.modRes("cut_stripped_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutStrippedPosts);
        this.bundledStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled_stripped", this.getModBlock("bundled_stripped_oak_posts"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            Block stripped = w.getBlockOfThis("stripped_log");
            if (stripped == null) {
                return null;
            }
            return new RotatedPillarBlock(ValhelsiaStructuresModule.bundledPostProperties(w));
        }).addTag(this.modRes("cut_stripped_posts"), Registries.BLOCK)).addTag(this.modRes("cut_stripped_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledStrippedPosts);
        this.bundledPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled", this.getModBlock("bundled_oak_posts"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            if (this.bundledStrippedPosts.blocks.get(w) == null) {
                return null;
            }
            return new StrippableRotatedPillarBlock(() -> (Block)this.bundledStrippedPosts.blocks.get(w), ValhelsiaStructuresModule.bundledPostProperties(w));
        }).addTag(this.modRes("cut_stripped_posts"), Registries.BLOCK)).addTag(this.modRes("cut_stripped_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledPosts);
    }

    public static BlockBehaviour.Properties cutPostProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(state -> ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getAxis() == Direction.Axis.Y ? woodType.planks.defaultMapColor() : woodType.log.defaultMapColor()).strength(2.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties bundledPostProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.WOOD : MapColor.PODZOL);
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        try {
            this.posts.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = logTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    handler.getLogger().error("Failed to generate Post block texture for for {} : {}", block, (Object)e);
                }
            });
            this.posts.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/stripped_oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = logTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    handler.getLogger().error("Failed to generate Stripped Post block texture for for {} : {}", block, (Object)e);
                }
            });
        }
        catch (Exception ex) {
            handler.getLogger().error("Could not generate any Table block texture : ", (Throwable)ex);
        }
        try (TextureImage BPTopInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_inner_m"));
             TextureImage BPTopOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_outer_m"));
             TextureImage logInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/log_top_inner_m"));
             TextureImage logOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/log_top_outer_m"));){
            this.bundledPosts.blocks.forEach((w, block) -> {
                String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_" + w.getTypeName() + "_posts";
                this.createTexture(newPath, w.log, logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_oak_posts"), this.modRes("block/bundled_posts/bundled_oak_posts_top"), handler, manager, (Block)block);
            });
            this.bundledStrippedPosts.blocks.forEach((w, block) -> {
                String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_stripped_" + w.getTypeName() + "_posts";
                this.createTexture(newPath, w.getBlockOfThis("stripped_log"), logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_stripped_oak_posts"), this.modRes("block/bundled_posts/bundled_stripped_oak_posts_top"), handler, manager, (Block)block);
            });
        }
        catch (Exception e) {
            handler.getLogger().error("Failed to open bundled_posts texture: ", (Throwable)e);
        }
    }

    private void createTexture(String newPath, Block getLogBlock, TextureImage logInnerMask, TextureImage logOuterMask, TextureImage BPTopInnerMask, TextureImage BPTopOuterMask, ResourceLocation getLogSide, ResourceLocation getLogTop, ClientDynamicResourcesHandler handler, ResourceManager manager, Block block) {
        try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
             TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));
             TextureImage TextureSide = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogSide);
             TextureImage TextureTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogTop);){
            AnimationMetadataSection metaSide = logSide_texture.getMetadata();
            List targetSide = Palette.fromAnimatedImage((TextureImage)logSide_texture);
            Respriter respriterSide = Respriter.of((TextureImage)TextureSide);
            TextureImage recoloredSIDE = respriterSide.recolorWithAnimation(targetSide, metaSide);
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(newPath), recoloredSIDE);
            AnimationMetadataSection metaTop = logTop_texture.getMetadata();
            List targetTopInner = Palette.fromAnimatedImage((TextureImage)logTop_texture, (TextureImage)logOuterMask, (float)0.0f);
            List targetTopOuter = Palette.fromAnimatedImage((TextureImage)logTop_texture, (TextureImage)logInnerMask, (float)0.0f);
            Respriter innerTopResp = Respriter.masked((TextureImage)TextureTop, (TextureImage)BPTopOuterMask);
            TextureImage recoloredwithInner = innerTopResp.recolorWithAnimation(targetTopInner, metaTop);
            Respriter outerTopResp = Respriter.masked((TextureImage)recoloredwithInner, (TextureImage)BPTopInnerMask);
            TextureImage recoloredwithOuter = targetTopOuter.size() < 3 ? outerTopResp.recolorWithAnimationOf(logTop_texture) : outerTopResp.recolorWithAnimation(targetTopOuter, metaTop);
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(newPath + "_top"), recoloredwithOuter);
        }
        catch (Exception e) {
            handler.getLogger().error("Failed to generate the texture for {} : {}", (Object)block, (Object)e);
        }
    }

    private void createTopTexture(TextureImage original, TextureImage newImage) {
        original.forEachFramePixel((i, x, y) -> {
            int localX = x - original.getFrameStartX(i.intValue());
            int localY = y - original.getFrameStartX(i.intValue());
            if (localX >= 5 && localX <= 10 && localY >= 5 && localY <= 10) {
                newImage.getImage().setPixelRGBA(x - 3, y - 3, original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
            } else if (localX >= 14 && localY > 0 && localY <= 7) {
                newImage.getImage().setPixelRGBA(x - 6, y.intValue(), original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
                newImage.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
            } else if (localY >= 14 && localX > 0 && localX <= 7) {
                newImage.getImage().setPixelRGBA(x.intValue(), y - 6, original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
                newImage.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
            } else if (localX >= 14 && localY >= 14) {
                newImage.getImage().setPixelRGBA(x - 6, y - 6, original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
            } else if (localX >= 10 || localY >= 10) {
                newImage.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
            }
        });
    }
}

