/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EveryCompatAPI;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.AllWoodItem;
import net.mehvahdjukaar.every_compat.modules.another_furniture.AnotherFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.camp_chair.CampChairModule;
import net.mehvahdjukaar.every_compat.modules.chipped.ChippedModule;
import net.mehvahdjukaar.every_compat.modules.decorative_blocks.DecorativeBlocksModule;
import net.mehvahdjukaar.every_compat.modules.exline.BarkCarpetsModule;
import net.mehvahdjukaar.every_compat.modules.friendsandfoes.FriendsAndFoesModule;
import net.mehvahdjukaar.every_compat.modules.furnish.FurnishModule;
import net.mehvahdjukaar.every_compat.modules.handcrafted.HandcraftedModule;
import net.mehvahdjukaar.every_compat.modules.hearth_and_home.HearthAndHomeModule;
import net.mehvahdjukaar.every_compat.modules.mrcrayfish.RefurbishedFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.table_top_craft.TableTopCraftModule;
import net.mehvahdjukaar.every_compat.modules.twigs.TwigsModule;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EveryCompat {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, CompatModule> ACTIVE_MODULES = new LinkedHashMap<String, CompatModule>();
    public static final List<CompatMod> COMPAT_MODS = new ArrayList<CompatMod>();
    public static final Map<Class<? extends BlockType>, Set<String>> ENTRY_TYPES = new HashMap<Class<? extends BlockType>, Set<String>>();
    public static class_1761 MOD_TAB = null;
    public static final Supplier<AllWoodItem> ALL_WOODS = RegHelper.registerItem((class_2960)EveryCompat.res("all_woods"), AllWoodItem::new);
    private int prevRegSize;
    public static final ChannelHandler CHANNEL = ChannelHandler.createChannel((class_2960)EveryCompat.res("network"));
    private static int lastInd;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        ACTIVE_MODULES.values().forEach(action);
    }

    protected void commonInit() {
        EarlyConfigs.init();
        ServerDynamicResourcesHandler.INSTANCE.register();
        if (PlatformHelper.getEnv().isClient()) {
            ClientDynamicResourcesHandler.INSTANCE.register();
        }
        this.addOtherCompatMod("compatoplenty", "biomesoplenty", List.of("twigs", "farmersdelight", "quark", "woodworks"));
        this.addOtherCompatMod("compat_makeover", "biomemakeover", List.of("habitat", "farmersdelight", "quark", "decorative_blocks"));
        this.addOtherCompatMod("decorative_compat", "biomesoplenty", List.of("decorative_blocks"));
        this.addOtherCompatMod("abnormals_delight", "autumnity", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "upgrade_aquatic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "endergetic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "atmospheric", List.of("farmersdelight"));
        this.addOtherCompatMod("storagedrawersunlimited", "biomesoplenty", List.of("storagedrawers"));
        this.addOtherCompatMod("macawsbridgesbop", "biomesoplenty", List.of("mcwbridges"));
        this.addOtherCompatMod("macawbridgesbyg", "byg", List.of("mcwbridges"));
        this.addOtherCompatMod("mcwfencesbop", "biomesoplenty", List.of("mcwfences"));
        this.addOtherCompatMod("mcwfencesbyg", "byg", List.of("mcwfences"));
        this.addOtherCompatMod("macawsroofsbop", "biomesoplenty", List.of("mcwroofs"));
        this.addOtherCompatMod("macawsroofsbyg", "byg", List.of("mcwroofs"));
        EveryCompat.addOtherCompatMod("mcwbyg", List.of("biomeswevegone", "byg"), "mcwbridges", "mcwroofs", "mcwfences", "mcwfurnitures", "mcwstairs");
        EveryCompat.addOtherCompatMod("mcwbiomesoplenty", "biomesoplenty", "mcwbridges", "mcwroofs", "mcwfences", "mcwfurnitures", "mcwstairs");
        EveryCompat.addOtherCompatMod("mcwmoddinglegacy", List.of("blue_skies", "premium_wood"), "mcwbridges", "mcwroofs", "mcwfences", "mcwfurnitures", "mcwstairs");
        this.addOtherCompatMod("abnormals_delight", "atmospheric", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "autumnity", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "endergetic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "environmental", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "upgrade_aquatic", List.of("farmersdelight"));
        this.addModule("another_furniture", () -> AnotherFurnitureModule::new);
        this.addModule("barkcarpets", () -> BarkCarpetsModule::new);
        this.addModule("campchair", () -> CampChairModule::new);
        this.addModule("chipped", () -> ChippedModule::new);
        this.addModule("decorative_blocks", () -> DecorativeBlocksModule::new);
        this.addModule("friendsandfoes", () -> FriendsAndFoesModule::new);
        this.addModule("furnish", () -> FurnishModule::new);
        this.addModule("handcrafted", () -> HandcraftedModule::new);
        this.addModule("hnh", () -> HearthAndHomeModule::new);
        this.addModule("twigs", () -> TwigsModule::new);
        this.addModule("table_top_craft", () -> TableTopCraftModule::new);
        this.addModule("refurbished_furniture", () -> RefurbishedFurnitureModule::new);
        EveryCompat.forAllModules(m -> LOGGER.info("Loaded {}", (Object)m.toString()));
        BlockSetAPI.addDynamicBlockRegistration(this::registerWoodStuff, WoodType.class);
        BlockSetAPI.addDynamicBlockRegistration(this::registerLeavesStuff, LeavesType.class);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerItems((Registrator<class_1792>)r), WoodType.class, (class_2378)class_2378.field_11142);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerTiles(r), WoodType.class, (class_2378)class_2378.field_11137);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerEntities(r), WoodType.class, (class_2378)class_2378.field_11145);
    }

    private static void addOptional(String blockId, String textureId, String texturePath) {
        class_2378.field_11146.method_17966(new class_2960(blockId)).ifPresent(b -> TextureCache.registerSpecialTextureForBlock((class_1935)b, (String)textureId, (class_2960)new class_2960(texturePath)));
    }

    public static <T extends BlockType> void addEntryType(Class<T> type, String childId) {
        ENTRY_TYPES.computeIfAbsent(type, t -> new HashSet()).add(childId);
    }

    private void addOtherCompatMod(String compatModId, String fromModId, List<String> supportedModId) {
        COMPAT_MODS.add(new CompatMod(compatModId, List.of(fromModId), supportedModId));
    }

    public static void addOtherCompatMod(String compatModId, List<String> fromModId, String ... supportedModId) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, supportedModId);
        COMPAT_MODS.add(new CompatMod(compatModId, fromModId, list));
    }

    public static void addOtherCompatMod(String compatModId, String fromModId, String ... supportedModId) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, supportedModId);
        COMPAT_MODS.add(new CompatMod(compatModId, List.of(fromModId), list));
    }

    protected void addModule(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (PlatformHelper.isModLoaded((String)modId)) {
            CompatModule module = moduleFactory.get().apply(modId);
            EveryCompatAPI.registerModule(module);
        }
    }

    private void addTab() {
        MOD_TAB = PlatformHelper.createModTab((class_2960)EveryCompat.res(MOD_ID), () -> ALL_WOODS.get().method_7854(), (boolean)true).method_7753("item_search.png");
    }

    public void commonSetup() {
        if (PlatformHelper.isModLoaded((String)"chipped")) {
            LOGGER.warn("Chipped is installed. The mod on its own adds a ludicrous amount of blocks. With Every Compat this can easily explode. You have been warned");
        }
        int newSize = class_2378.field_11146.method_10204();
        int am = newSize - this.prevRegSize;
        float p = (float)am / (float)newSize * 100.0f;
        LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)am, (Object)String.format("%.2f", Float.valueOf(p)));
        if (p > 33.0f) {
            CompatModule bloated = ACTIVE_MODULES.values().stream().max(Comparator.comparing(CompatModule::bloatAmount)).get();
            LOGGER.error("Every Compat registered blocks make up more than one third of your registered blocks, taking up memory and load time.");
            LOGGER.error("You might want to uninstall some mods, biggest offender was {} ({} blocks)", (Object)bloated.getModId().toUpperCase(Locale.ROOT), (Object)bloated.bloatAmount());
        }
        EveryCompat.forAllModules(CompatModule::onModSetup);
    }

    public void registerWoodStuff(Registrator<class_2248> event, Collection<WoodType> woods) {
        WoodConfigs.init();
        if (EarlyConfigs.TAB_ENABLED.get().booleanValue()) {
            this.addTab();
        }
        this.prevRegSize = class_2378.field_11146.method_10204();
        LOGGER.info("Registering Compat Wood Blocks");
        EveryCompat.forAllModules(m -> m.registerWoodBlocks(event, woods));
    }

    public void registerLeavesStuff(Registrator<class_2248> event, Collection<LeavesType> leaves) {
        LOGGER.info("Registering Compat Leaves Blocks");
        EveryCompat.forAllModules(m -> m.registerLeavesBlocks(event, leaves));
    }

    protected void registerItems(Registrator<class_1792> event) {
        EveryCompat.forAllModules(m -> m.registerItems(event));
    }

    protected void registerTiles(Registrator<class_2591<?>> event) {
        EveryCompat.forAllModules(m -> m.registerTiles(event));
    }

    protected void registerEntities(Registrator<class_1299<?>> event) {
        EveryCompat.forAllModules(m -> m.registerEntities(event));
    }

    public static void sendPacket(class_3222 s) {
        if (EarlyConfigs.DEBUG_PACKET.get().booleanValue() || PlatformHelper.isDev()) {
            lastInd = 0;
            LOGGER.warn("Starting Blockstate Map validity check:");
            while (lastInd < class_2248.field_10651.method_10204()) {
                CHANNEL.sendToClientPlayer(s, (Message)new S2CBlockStateCheckMessage());
            }
        }
    }

    static {
        CHANNEL.register(NetworkDir.PLAY_TO_CLIENT, S2CBlockStateCheckMessage.class, S2CBlockStateCheckMessage::new);
        lastInd = 0;
    }

    public record CompatMod(String modId, List<String> woodFrom, List<String> blocksFrom) {
    }

    public static class S2CBlockStateCheckMessage
    implements Message {
        public S2CBlockStateCheckMessage(class_2540 buf) {
            int start = buf.method_10816();
            int size = buf.method_10816();
            boolean mismatched = false;
            for (int i = start; i < start + size; ++i) {
                try {
                    class_2680 exp;
                    class_2680 b;
                    class_2487 nbt = buf.method_10798();
                    if (nbt == null) {
                        boolean bl = true;
                    }
                    if ((b = class_2512.method_10681((class_2487)nbt)) != (exp = (class_2680)class_2248.field_10651.method_10200(i))) {
                        if (!mismatched) {
                            LOGGER.error("Found blockstate id mismatch from " + b + "at id " + i + ". Was expecting: " + exp);
                        }
                        mismatched = true;
                        continue;
                    }
                    if (mismatched) {
                        LOGGER.error("to" + b + "at id " + i);
                    }
                    mismatched = false;
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to read blockstate in id map: ", (Throwable)e);
                    break;
                }
            }
            buf.release();
        }

        public S2CBlockStateCheckMessage() {
        }

        public void writeToBuffer(class_2540 buf) {
            class_2540 dummy = new class_2540(Unpooled.buffer());
            int start = lastInd;
            int i = lastInd;
            while (i < class_2248.field_10651.method_10204()) {
                ++lastInd;
                class_2487 nbt = class_2512.method_10686((class_2680)class_2248.method_9531((int)i));
                dummy.method_10794(nbt);
                if ((double)dummy.writerIndex() > 943718.4) break;
                ++i;
            }
            buf.method_10804(start);
            buf.method_10804(lastInd - start);
            buf.writeBytes((ByteBuf)dummy);
            dummy.release();
        }

        public void handle(ChannelHandler.Context context) {
        }
    }
}

