/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1079;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends class_2248, I extends class_1792>
extends EntrySet<T, B, I> {
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final Supplier<class_1761> tab;
    protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
    protected final Set<Supplier<class_2960>> recipeLocations = new HashSet<Supplier<class_2960>>();
    protected final Set<Pair<class_2960, @Nullable class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
    @Nullable
    protected final @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraTransform;
    protected final Predicate<T> condition;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<class_1761> tab, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, Predicate<T> condition) {
        super((String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name);
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.baseType = baseType;
        this.type = type;
        this.extraTransform = extraTransform;
        this.paletteSupplier = paletteSupplier;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
    }

    public abstract boolean isDisabled();

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new class_2960(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected class_1761 getTab(T w, B b) {
        return WoodConfigs.isEntryEnabled(w, b) ? (EveryCompat.MOD_TAB != null ? EveryCompat.MOD_TAB : this.tab.get()) : null;
    }

    @Override
    public void generateTags(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        if (this.isDisabled()) {
            return;
        }
        if (!this.tags.isEmpty()) {
            for (Map.Entry<class_2960, Set<class_5321<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)tb.getKey());
                for (Map.Entry<T, class_1935> entry : this.getMainEntryMap().entrySet()) {
                    if (!WoodConfigs.isEntryEnabled((BlockType)entry.getKey(), (Object)entry.getValue())) continue;
                    builder.addEntry((Object)entry.getValue());
                }
                for (class_5321 class_53212 : tb.getValue()) {
                    pack.addTag(builder, class_53212);
                }
            }
        }
    }

    @Override
    public void generateRecipes(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        if (this.isDisabled()) {
            return;
        }
        int i = 0;
        for (Supplier<class_2960> r : this.recipeLocations) {
            class_2960 res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(CompatModule module, DynClientResourcesProvider handler, class_3300 manager) {
        if (this.isDisabled()) {
            return;
        }
        if (this.textures.isEmpty()) {
            return;
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try {
            HashMap respriters = new HashMap();
            for (Pair<class_2960, class_2960> pair : this.textures) {
                class_2960 textureId = (class_2960)pair.getFirst();
                try {
                    Respriter r;
                    TextureImage main = TextureImage.open((class_3300)manager, (class_2960)textureId);
                    images.add(main);
                    class_2960 m = (class_2960)pair.getSecond();
                    if (m != null) {
                        TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)m);
                        images.add(main);
                        r = Respriter.masked((TextureImage)main, (TextureImage)mask);
                    } else {
                        r = Respriter.of((TextureImage)main);
                    }
                    respriters.put(textureId, r);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read block texture at: {}", pair, (Object)e);
                }
            }
            for (Map.Entry entry : this.getMainEntryMap().entrySet()) {
                class_1935 b = (class_1935)entry.getValue();
                BlockType w = (BlockType)entry.getKey();
                class_2960 blockId = Utils.getID((Object)b);
                List targetPalette = null;
                class_1079 animation = null;
                if (this.paletteSupplier != null) {
                    Pair<List<Palette>, class_1079> pal = this.paletteSupplier.apply(w, manager);
                    animation = (class_1079)pal.getSecond();
                    targetPalette = (List)pal.getFirst();
                } else {
                    class_1935 m = w.mainChild();
                    class_2248 mainBlock = null;
                    if (m instanceof class_2248) {
                        class_2248 bb;
                        mainBlock = bb = (class_2248)m;
                    } else if (m instanceof class_1747) {
                        class_1747 bii = (class_1747)m;
                        mainBlock = bii.method_7711();
                    }
                    if (mainBlock == null) {
                        throw new UnsupportedOperationException("You need to provide a palette supplier for non wood type based blocks");
                    }
                    try (TextureImage plankTexture22 = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)mainBlock));){
                        targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture22);
                        animation = plankTexture22.getMetadata();
                    }
                    catch (Exception plankTexture22) {
                        // empty catch block
                    }
                }
                if (targetPalette == null) {
                    EveryCompat.LOGGER.error("Could not get texture palette for block {} : ", (Object)b);
                    continue;
                }
                class_1079 finalAnimation = animation;
                List finalTargetPalette = targetPalette;
                int oldSize = ((Palette)finalTargetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    if (oldSize != ((Palette)finalTargetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    String oldPath = ((class_2960)re.getKey()).method_12832();
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)w, (class_2960)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    Respriter respriter = (Respriter)re.getValue();
                    if (this.type == WoodType.class) {
                        module.addWoodTexture((WoodType)w, handler, manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                        continue;
                    }
                    handler.addTextureIfNotPresent(manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {} : ", (Object)module.modRes(this.getName()), (Object)e);
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    protected abstract Map<T, ? extends class_1935> getMainEntryMap();

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends class_2248, I extends class_1792> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<class_1761> tab = () -> class_1761.field_7928;
        @Nullable
        protected @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> palette = null;
        protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
        protected final Set<Supplier<class_2960>> recipes = new HashSet<Supplier<class_2960>>();
        protected final Set<Pair<class_2960, @Nullable class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL addCondition(Predicate<T> condition) {
            this.condition = condition;
            return (BL)this;
        }

        public BL setTab(Supplier<class_1761> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL addTag(class_2960 location, class_5321<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return (BL)this;
        }

        public BL addTag(class_6862<?> tag, class_5321<?> registry) {
            this.addTag(tag.comp_327(), registry);
            return (BL)this;
        }

        public BL addRecipe(class_2960 resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(class_2960 resourceLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)resourceLocation, null));
            return (BL)this;
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)textureLocation, (Object)maskLocation));
            return (BL)this;
        }

        public BL setPalette(BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteProvider) {
            this.palette = paletteProvider;
            return (BL)this;
        }

        public BL createPaletteFromOak(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks", null);
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.createPaletteFromChild(paletteTransform, childKey, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE);
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide) {
            return this.setPalette((w, m) -> {
                Pair pair;
                block18: {
                    if (whichSide != null) {
                        Pair pair2;
                        block17: {
                            TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)m, (class_2248)w.getBlockOfThis(childKey), (Predicate)whichSide));
                            try {
                                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                                targetPalette.forEach(paletteTransform);
                                pair2 = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                                if (plankTexture == null) break block17;
                            }
                            catch (Throwable targetPalette) {
                                try {
                                    if (plankTexture != null) {
                                        try {
                                            plankTexture.close();
                                        }
                                        catch (Throwable throwable) {
                                            targetPalette.addSuppressed(throwable);
                                        }
                                    }
                                    throw targetPalette;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                                }
                            }
                            plankTexture.close();
                        }
                        return pair2;
                    }
                    TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)m, (class_2248)w.getBlockOfThis(childKey)));
                    try {
                        List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                        targetPalette.forEach(paletteTransform);
                        pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                        if (plankTexture == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (plankTexture != null) {
                                try {
                                    plankTexture.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                        }
                    }
                    plankTexture.close();
                }
                return pair;
            });
        }
    }
}

