/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public abstract class CompatModule {
    protected final String modId;

    protected CompatModule(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public abstract String shortenedId();

    public String toString() {
        return "EveryCompat " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public class_2960 modRes(String string) {
        return new class_2960(this.modId, string);
    }

    public List<String> getAlreadySupportedMods() {
        return List.of();
    }

    public void onModInit() {
    }

    public void onModSetup() {
    }

    public void onClientInit() {
    }

    public void onClientSetup() {
    }

    public void registerWoodBlocks(Registrator<class_2248> registry, Collection<WoodType> woodTypes) {
    }

    public void registerLeavesBlocks(Registrator<class_2248> registry, Collection<LeavesType> leavesTypes) {
    }

    public void registerItems(Registrator<class_1792> registry) {
    }

    public void registerTiles(Registrator<class_2591<?>> registry) {
    }

    public void registerEntities(Registrator<class_1299<?>> registry) {
    }

    public boolean isEntryAlreadyRegistered(String blockId, BlockType blockType, class_2378<?> registry) {
        LeavesType lt;
        WoodType wt;
        Boolean hardcoded;
        if (blockType.isVanilla()) {
            return true;
        }
        String blockName = blockId.substring(blockId.lastIndexOf("/") + 1);
        String blockTypeFrom = blockType.getNamespace();
        String slashConvention = blockTypeFrom + "/" + blockName;
        String underscoreConvention = blockTypeFrom + "_" + blockName;
        if (blockType instanceof WoodType ? (hardcoded = HardcodedBlockType.isWoodBlockAlreadyRegistered(blockName, wt = (WoodType)blockType, this.modId, this.shortenedId())) != null : blockType instanceof LeavesType && (hardcoded = HardcodedBlockType.isLeavesBlockAlreadyRegistered(blockName, lt = (LeavesType)blockType, this.modId, this.shortenedId())) != null) {
            return hardcoded;
        }
        if (this.getAlreadySupportedMods().contains(blockTypeFrom)) {
            return true;
        }
        if (blockTypeFrom.equals(this.modId)) {
            return true;
        }
        if (registry.method_10250(new class_2960(this.modId, blockName)) || registry.method_10250(new class_2960(this.modId, underscoreConvention))) {
            return true;
        }
        if (registry.method_10250(new class_2960(blockTypeFrom, blockName))) {
            return true;
        }
        for (EveryCompat.CompatMod c : EveryCompat.COMPAT_MODS) {
            String compatModId = c.modId();
            if (!c.woodFrom().contains(blockTypeFrom) || !c.blocksFrom().contains(this.modId)) continue;
            if (registry.method_10250(new class_2960(compatModId, blockName))) {
                return true;
            }
            if (registry.method_10250(new class_2960(compatModId, slashConvention))) {
                return true;
            }
            if (!registry.method_10250(new class_2960(compatModId, underscoreConvention))) continue;
            return true;
        }
        return false;
    }

    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, class_3300 manager) {
    }

    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, class_3300 manager) {
    }

    public void registerBlockEntityRenderers(ClientPlatformHelper.BlockEntityRendererEvent event) {
    }

    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
    }

    public void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
    }

    public void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
    }

    @Nullable
    protected final <T extends class_2248> T getModBlock(String id, Class<T> blockClass) {
        return (T)((class_2248)class_2378.field_11146.method_10223(this.modRes(id)));
    }

    @Nullable
    protected final class_2248 getModBlock(String id) {
        return (class_2248)class_2378.field_11146.method_10223(this.modRes(id));
    }

    @Nullable
    protected final class_1792 getModItem(String id) {
        return (class_1792)class_2378.field_11142.method_10223(this.modRes(id));
    }

    @Nullable
    protected final <T extends class_2591<?>> T getModTile(String id, Class<T> blockClass) {
        return (T)((class_2591)class_2378.field_11137.method_10223(this.modRes(id)));
    }

    @Nullable
    protected final class_2591<?> getModTile(String id) {
        return (class_2591)class_2378.field_11137.method_10223(this.modRes(id));
    }

    public void addWoodTexture(WoodType wood, DynClientResourcesProvider handler, class_3300 manager, String path, Supplier<TextureImage> textureSupplier) {
        handler.addTextureIfNotPresent(manager, path, () -> {
            TextureImage t = (TextureImage)textureSupplier.get();
            this.maybeFlowerAzalea(t, manager, wood);
            return t;
        });
        handler.addTextureIfNotPresent(manager, path, () -> {
            TextureImage t = (TextureImage)textureSupplier.get();
            this.maybeBrimwood(t, manager, path, wood);
            return t;
        });
    }

    protected void maybeFlowerAzalea(TextureImage image, class_3300 manager, WoodType woodType) {
        WoodType azalea;
        if (woodType.getId().toString().equals("ecologics:flowering_azalea") && (azalea = WoodTypeRegistry.getValue((class_2960)new class_2960("ecologics:azalea"))) != null) {
            try (TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)azalea.planks));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, mask});
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("failed to apply azalea overlay: ", (Throwable)e);
            }
        }
    }

    protected void maybeBrimwood(TextureImage image, class_3300 manager, String path, WoodType woodType) {
        WoodType brimwood;
        if (woodType.getId().toString().equals("regions_unexplored:brimwood") && (brimwood = WoodTypeRegistry.getValue((class_2960)new class_2960("regions_unexplored:brimwood"))) != null && !path.contains("chest")) {
            try (TextureImage lavaOverlay = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_planks_lava"));
                 TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_planks"));){
                String type;
                Respriter respriter = switch (type = path.substring(path.lastIndexOf("brimwood_") + 9)) {
                    case "barrel_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_barrel_side_m")));
                    case "barrel_top" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_barrel_top_m")));
                    case "beehive_front_honey" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_beehive_front_honey_m")));
                    case "beehive_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_beehive_side_m")));
                    case "bookshelf" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_bookshelf_m")));
                    case "cartography_table_side1" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_cartography_table_side1_m")));
                    case "cartography_table_side2" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_cartography_table_side2_m")));
                    case "cartography_table_top" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_cartography_table_top_m")));
                    case "chiseled_bookshelf_occupied" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_chiseled_bookshelf_occupied_m")));
                    case "crafting_table_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_crafting_table_front_m")));
                    case "crafting_table_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_crafting_table_side_m")));
                    case "fletching_table_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_fletching_table_front_m")));
                    case "fletching_table_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_fletching_table_side_m")));
                    case "fletching_table_top" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_fletching_table_top_m")));
                    case "lectern_base" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_lectern_base_m")));
                    case "lectern_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_lectern_front_m")));
                    case "smithing_table_bottom" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_smithing_table_bottom_m")));
                    case "smithing_table_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_smithing_table_front_m")));
                    case "smithing_table_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_smithing_table_side_m")));
                    case "smoker_bottom" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_smoker_bottom_m")));
                    case "smoker_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_smoker_front_m")));
                    case "smoker_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/brimwood_smoker_side_m")));
                    default -> Respriter.of((TextureImage)image);
                };
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                if (path.contains("stairs") || path.contains("planks") || path.contains("slab") || path.contains("beehive") || path.contains("composter_bottom") || path.contains("composter_side") || path.contains("lectern_side") || path.contains("lectern_top") || path.contains("bookshelf_side") || path.contains("bookshelf_top") || path.contains("boards")) {
                    image.applyOverlayOnExisting(new TextureImage[]{temp, lavaOverlay});
                } else {
                    image.applyOverlayOnExisting(new TextureImage[]{temp});
                }
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("failed to open the texture for: ", (Throwable)e);
            }
        }
    }

    public <T extends BlockType, B extends class_2248> Function<T, @Nullable B> ifHasChild(Function<T, B> supplier, String ... children) {
        return w -> {
            for (String v : children) {
                if (w.getChild(v) != null) continue;
                return null;
            }
            return (class_2248)supplier.apply(w);
        };
    }

    public abstract int bloatAmount();

    public void stitchAtlasTextures(ClientPlatformHelper.AtlasTextureEvent event) {
    }
}

