/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1079;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemOnlyEntrySet<T extends BlockType, I extends class_1792>
extends AbstractSimpleEntrySet<T, class_2248, I> {
    protected final Supplier<@Nullable I> baseItem;
    protected final Function<T, @Nullable I> itemFactory;

    public ItemOnlyEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, I> itemFactory, Supplier<@Nullable I> baseItem, Supplier<T> baseType, Supplier<class_1761> tab, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, Predicate<T> condition) {
        super(type, name, prefix, baseType, tab, paletteSupplier, extraTransform, condition);
        this.itemFactory = itemFactory;
        this.baseItem = baseItem;
    }

    @Override
    protected Map<T, ? extends class_1935> getMainEntryMap() {
        return this.items;
    }

    @Override
    public boolean isDisabled() {
        return this.getBaseItem() == null;
    }

    public I getBaseItem() {
        return (I)((class_1792)this.baseItem.get());
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.items.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("item_type." + module.getModId() + "." + this.typeName), (BlockType)w, (class_1792)v));
    }

    @Override
    public void registerBlocks(CompatModule module, Registrator<class_2248> registry, Collection<T> woodTypes) {
    }

    @NotNull
    public String getItemName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(CompatModule module, Registrator<class_1792> registry) {
        BlockTypeRegistry typeRegistry = BlockSetAPI.getTypeRegistry((Class)this.type);
        for (BlockType w : typeRegistry.getValues()) {
            class_1792 item;
            String name = this.getItemName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (module.isEntryAlreadyRegistered(name, w, (class_2378<?>)class_2378.field_11146) || !this.condition.test(w) || (item = (class_1792)this.itemFactory.apply(w)) == null) continue;
            this.items.put(w, item);
            registry.register(EveryCompat.res(fullName), (Object)item);
            w.addChild(this.getChildKey(module), (Object)item);
            Object object = w.getChild(this.getChildKey(module));
        }
    }

    @Override
    public void registerTiles(CompatModule module, Registrator<class_2591<?>> registry) {
        I base = this.getBaseItem();
        if (base == null || base == class_1802.field_8162) {
            throw new UnsupportedOperationException("Base block cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        ((BlockType)this.baseType.get()).addChild(this.getChildKey(module), base);
    }

    @Override
    public void setRenderLayer() {
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, class_3300 manager) {
    }

    @Override
    public void generateModels(CompatModule module, DynClientResourcesProvider handler, class_3300 manager) {
        if (this.isDisabled()) {
            return;
        }
        ResourcesUtils.addItemModels(module.getModId(), manager, handler, this.items, (BlockType)this.baseType.get(), this.extraTransform);
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, ClientPlatformHelper.BlockEntityRendererEvent event) {
    }

    public static <T extends BlockType, I extends class_1792> Builder<T, I> builder(Class<T> type, String name, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, null, baseType, baseItem, itemSupplier);
    }

    public static <T extends BlockType, I extends class_1792> Builder<T, I> builder(Class<T> type, String name, String prefix, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, prefix, baseType, baseItem, itemSupplier);
    }

    public static class Builder<T extends BlockType, I extends class_1792>
    extends AbstractSimpleEntrySet.Builder<Builder<T, I>, T, class_2248, I> {
        protected final Supplier<@Nullable I> baseItem;
        protected final Function<T, I> itemFactory;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<I> baseItem, Function<T, I> itemFactory) {
            super(type, name, prefix, baseType);
            this.baseItem = baseItem;
            this.itemFactory = itemFactory;
        }

        public ItemOnlyEntrySet<T, I> build() {
            ItemOnlyEntrySet<T, I> e = new ItemOnlyEntrySet<T, I>(this.type, this.name, this.prefix, this.itemFactory, this.baseItem, this.baseType, this.tab, this.palette, this.extraModelTransform, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }
    }
}

