/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.minecraft.class_1079;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class CompatChestTexture {
    public static void generateChestTexture(ClientDynamicResourcesHandler handler, class_3300 manager, WoodType wood, class_2248 block, class_2960 normalPath, class_2960 trappedPath, class_2960 normalRLoc, class_2960 maskRLoc, class_2960 overlayRLoc, class_2960 trappedORLoc) {
        CompatChestTexture.generateChestTexture(handler, manager, wood, block, normalPath, trappedPath, normalRLoc, maskRLoc, overlayRLoc, trappedORLoc, 2);
    }

    public static void generateChestTexture(ClientDynamicResourcesHandler handler, class_3300 manager, WoodType wood, class_2248 block, class_2960 normalPath, class_2960 trappedPath, class_2960 normalRLoc, class_2960 maskRLoc, class_2960 overlayRLoc, class_2960 trappedOverlayRLoc, int removeDarkest) {
        try (TextureImage normalTexture = TextureImage.open((class_3300)manager, (class_2960)normalRLoc);
             TextureImage normalMask = TextureImage.open((class_3300)manager, (class_2960)maskRLoc);
             TextureImage normalOverlay = TextureImage.open((class_3300)manager, (class_2960)overlayRLoc);){
            TextureImage trapOverlay = trappedOverlayRLoc != null ? TextureImage.open((class_3300)manager, (class_2960)trappedOverlayRLoc) : null;
            Respriter respriterNormal = Respriter.masked((TextureImage)normalTexture, (TextureImage)normalMask);
            Respriter respriterOverlay = Respriter.of((TextureImage)normalOverlay);
            try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                List plankPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                if (wood.getId().toString().equals("regions_unexplored:brimwood")) {
                    plankPalette.forEach(p -> {
                        p.remove(p.getLightest());
                        p.remove(p.getLightest());
                        p.remove(p.getLightest());
                        p.remove(p.getLightest());
                    });
                }
                class_1079 plankMeta = plankTexture.getMetadata();
                ArrayList<Palette> overlayPalette = new ArrayList<Palette>();
                for (Palette p2 : plankPalette) {
                    PaletteColor d1 = p2.getDarkest();
                    PaletteColor d2 = p2.getDarkest();
                    if (!wood.getId().toString().equals("regions_unexplored:brimwood")) {
                        switch (removeDarkest) {
                            case 2: {
                                p2.remove(d2);
                            }
                            case 1: {
                                p2.remove(d1);
                            }
                        }
                    }
                    HCLColor n1 = new HCLColor(d1.hcl().hue(), d1.hcl().chroma() * 0.75f, d1.hcl().luminance() * 0.4f, d1.hcl().alpha());
                    HCLColor n2 = new HCLColor(d2.hcl().hue(), d2.hcl().chroma() * 0.75f, d2.hcl().luminance() * 0.6f, d2.hcl().alpha());
                    Palette pal = Palette.ofColors(List.of(n1, n2));
                    overlayPalette.add(pal);
                }
                if (!handler.alreadyHasTextureAtLocation(manager, normalPath)) {
                    CompatChestTexture.createChestTextures(handler, respriterNormal, respriterOverlay, plankMeta, plankPalette, overlayPalette, normalPath, trappedPath, trapOverlay, wood);
                }
            }
            catch (Exception ex) {
                handler.getLogger().error("Failed to generate Chest block texture for for: {} - {}", (Object)block, (Object)ex);
            }
        }
        catch (Exception ex) {
            handler.getLogger().error("Failed to open the Chest texture: ", (Throwable)ex);
        }
    }

    private static void createChestTextures(ClientDynamicResourcesHandler handler, Respriter respriter, Respriter respriterO, class_1079 baseMeta, List<Palette> basePalette, List<Palette> overlayPalette, class_2960 normalRLoc, class_2960 trappedRLoc, TextureImage trappedOverlay, WoodType wood) {
        TextureImage recoloredBase = respriter.recolorWithAnimation(basePalette, baseMeta);
        TextureImage recoloredOverlay = respriterO.recolorWithAnimation(overlayPalette, baseMeta);
        recoloredBase.applyOverlay(new TextureImage[]{recoloredOverlay});
        if (trappedOverlay != null) {
            TextureImage trapped = recoloredBase.makeCopy();
            trapped.applyOverlay(new TextureImage[]{trappedOverlay});
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(trappedRLoc, trapped);
        }
        if (!wood.getNamespace().equals("blue_skies") || wood.getId().toString().equals("blue_skies:crystallized")) {
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(normalRLoc, recoloredBase);
        }
    }
}

