/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5797;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcesUtils {
    private static final JsonObject DUMMY_BLOCKSTATE = new JsonObject();

    public static <B extends class_2248, T extends BlockType> void addStandardResources(String modId, class_3300 manager, DynClientResourcesProvider pack, Map<T, B> blocks, T baseType) {
        ResourcesUtils.addStandardResources(modId, manager, pack, blocks, baseType, null);
    }

    public static <B extends class_2248, T extends BlockType> void addStandardResources(String modId, class_3300 manager, DynClientResourcesProvider d, Map<T, B> blocks, T baseType, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        if (blocks.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)blocks.entrySet().stream().findFirst().get();
        class_2248 oakBlock = BlockType.changeBlockType((class_2248)((class_2248)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        String baseBlockName = baseType.getTypeName();
        if (oakBlock == null) {
            EveryCompat.LOGGER.error("Failed to generate some assets");
            return;
        }
        class_2960 oakId = Utils.getID((class_2248)oakBlock);
        BlockTypeResTransformer modifier = BlockTypeResTransformer.create((String)modId, (class_3300)manager);
        modifier.IDReplaceType(baseBlockName).replaceBlockType(baseBlockName);
        if (extraTransform != null) {
            extraTransform.accept(modifier);
        }
        BlockTypeResTransformer modelModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseBlockName, extraTransform);
        HashSet modelsLoc = new HashSet();
        class_1792 oakItem = oakBlock.method_8389();
        if (oakItem != class_1802.field_8162) {
            try {
                String parent;
                BlockTypeResTransformer itemModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseBlockName, extraTransform);
                StaticResource oakItemModel = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Utils.getID((class_1792)oakItem)));
                JsonObject json = RPUtils.deserializeJson((InputStream)oakItemModel.getInputStream());
                modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
                if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                    itemModifier.replaceItemType(baseBlockName);
                }
                blocks.forEach((w, b) -> {
                    class_2960 id = Utils.getID((class_2248)b);
                    try {
                        StaticResource newRes = itemModifier.transform(oakItemModel, id, w);
                        assert (newRes.location != oakItemModel.location) : "ids cant be the same";
                        d.addResourceIfNotPresent(manager, newRes);
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to add {} item model json file:", b, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakBlock);
            }
        }
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(oakId));
            JsonObject json = RPUtils.deserializeJson((InputStream)oakBlockstate.getInputStream());
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model")));
            ArrayList<StaticResource> oakModels = new ArrayList<StaticResource>();
            for (String m : modelsLoc) {
                StaticResource model;
                class_2960 modelRes = new class_2960(m);
                if (modelRes.method_12836().equals("minecraft") || (model = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.MODELS.getPath(m))) == null) continue;
                oakModels.add(model);
            }
            blocks.forEach((w, b) -> {
                class_2960 id = Utils.getID((class_2248)b);
                try {
                    StaticResource newBlockState = modifier.transform(oakBlockstate, id, w);
                    assert (newBlockState.location != oakBlockstate.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newBlockState);
                    for (StaticResource model : oakModels) {
                        try {
                            StaticResource newModel = modelModifier.transform(model, id, w);
                            assert (newModel.location != model.location) : "ids cant be the same";
                            d.addResourceIfNotPresent(manager, newModel);
                        }
                        catch (Exception exception) {
                            EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                        }
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} blockstate json file:", b, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find blockstate definition for {}", (Object)oakBlock);
        }
    }

    public static <I extends class_1792, T extends BlockType> void addItemModels(String modId, class_3300 manager, DynClientResourcesProvider d, Map<T, I> items, T baseType, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        if (items.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)items.entrySet().stream().findFirst().get();
        class_1792 oakItem = BlockType.changeItemType((class_1792)((class_1792)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        String baseItemname = baseType.getTypeName();
        if (oakItem == null) {
            EveryCompat.LOGGER.error("Failed to generate some assets");
            return;
        }
        BlockTypeResTransformer modifier = BlockTypeResTransformer.create((String)modId, (class_3300)manager);
        modifier.IDReplaceType(baseItemname).replaceBlockType(baseItemname);
        if (extraTransform != null) {
            extraTransform.accept(modifier);
        }
        BlockTypeResTransformer modelModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseItemname, extraTransform);
        HashSet modelsLoc = new HashSet();
        try {
            String parent;
            BlockTypeResTransformer itemModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseItemname, extraTransform);
            StaticResource oakItemModel = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Utils.getID((class_1792)oakItem)));
            JsonObject json = RPUtils.deserializeJson((InputStream)oakItemModel.getInputStream());
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
            if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                itemModifier.replaceItemType(baseItemname);
            }
            items.forEach((w, b) -> {
                class_2960 id = Utils.getID((class_1792)b);
                try {
                    StaticResource newRes = itemModifier.transform(oakItemModel, id, w);
                    assert (newRes.location != oakItemModel.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newRes);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} item model json file:", b, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakItem);
        }
        ArrayList<StaticResource> oakModels = new ArrayList<StaticResource>();
        for (String m : modelsLoc) {
            StaticResource model;
            class_2960 modelRes = new class_2960(m);
            if (modelRes.method_12836().equals("minecraft") || (model = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.MODELS.getPath(m))) == null) continue;
            oakModels.add(model);
        }
        items.forEach((w, b) -> {
            class_2960 id = Utils.getID((class_1792)b);
            for (StaticResource model : oakModels) {
                try {
                    StaticResource newModel = modelModifier.transform(model, id, w);
                    assert (newModel.location != model.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newModel);
                }
                catch (Exception exception) {
                    EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                }
            }
        });
    }

    @NotNull
    private static <T extends BlockType> BlockTypeResTransformer<T> standardModelTransformer(String modId, class_3300 manager, T baseType, String oldTypeName, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        BlockTypeResTransformer modelModifier = BlockTypeResTransformer.create((String)modId, (class_3300)manager);
        if (extraTransform != null) {
            extraTransform.accept(modelModifier);
        }
        modelModifier.IDReplaceType(oldTypeName);
        if (baseType instanceof LeavesType) {
            LeavesType leavesType = (LeavesType)baseType;
            modelModifier.replaceLeavesTextures(leavesType);
            WoodType woodT = leavesType.getWoodType();
            if (woodT != null) {
                modelModifier.replaceWoodTextures(woodT);
            }
        } else if (baseType instanceof WoodType) {
            WoodType woodType = (WoodType)baseType;
            modelModifier.replaceWoodTextures(woodType);
        }
        modelModifier.replaceGenericType(oldTypeName, "block");
        return modelModifier;
    }

    public static <B extends class_2248, T extends BlockType> void addBlockResources(String modId, class_3300 manager, DynamicResourcePack pack, Map<T, B> blocks, String typeName, class_2960 ... jsonsLocations) {
        ResourcesUtils.addBlockResources(modId, manager, pack, blocks, BlockTypeResTransformer.create((String)modId, (class_3300)manager).replaceSimpleType(typeName).IDReplaceType(typeName), jsonsLocations);
    }

    public static <B extends class_2248, T extends BlockType> void addBlockResources(String modId, class_3300 manager, DynamicResourcePack pack, Map<T, B> blocks, BlockTypeResTransformer<T> modifier, class_2960 ... jsonsLocations) {
        List<StaticResource> original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog((class_3300)manager, (class_2960)s)).toList();
        blocks.forEach((wood, value) -> {
            if (WoodConfigs.isEntryEnabled(wood, value)) {
                for (StaticResource res : original) {
                    try {
                        StaticResource newRes = modifier.transform(res, Utils.getID((class_2248)value), wood);
                        assert (newRes.location != res.location) : "ids cant be the same";
                        pack.addResource(newRes);
                    }
                    catch (Exception e) {
                        if (res == null) continue;
                        EveryCompat.LOGGER.error("Failed to generate json resource from {}", (Object)res.location);
                    }
                }
            }
        });
    }

    public static void addLeavesRecipes(String modId, class_3300 manager, DynamicDataPack pack, Map<LeavesType, class_1792> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, LeavesTypeRegistry.OAK_TYPE);
    }

    public static <B extends class_1792> void addWoodRecipes(String modId, class_3300 manager, DynamicDataPack pack, Map<WoodType, B> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, WoodTypeRegistry.OAK_TYPE);
    }

    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(String modId, class_3300 manager, DynamicDataPack pack, Map<T, B> blocks, String oakRecipe, T fromType) {
        ResourcesUtils.addBlocksRecipes(manager, pack, blocks, new class_2960(modId, oakRecipe), fromType, 0);
    }

    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(class_3300 manager, DynamicDataPack pack, Map<T, B> items, class_2960 oakRecipe, T fromType, int index) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((class_3300)manager, (class_2960)ResType.RECIPES.getPath(oakRecipe));
        items.forEach((w, i) -> {
            if (WoodConfigs.isEntryEnabled(w, i)) {
                try {
                    if (i.method_7859() != null) {
                        class_2444 newR;
                        Object id = class_5797.method_36442((class_1935)i).toString();
                        if (index != 0) {
                            id = (String)id + "_" + index;
                            newR = template.createSimilar(fromType, w, w.mainChild().method_8389(), (String)id);
                        } else {
                            newR = template.createSimilar(fromType, w, w.mainChild().method_8389());
                        }
                        if (newR == null) {
                            EveryCompat.LOGGER.error("Failed to generate recipe for {}: recipe template returned null", i);
                            return;
                        }
                        newR = ForgeHelper.addRecipeConditions((class_2444)newR, (List)template.getConditions());
                        pack.addRecipe(newR);
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate recipe for {}:", i, (Object)e);
                }
            }
        });
    }

    public static <T extends BlockType> class_1856 convertIngredient(class_1856 ingredient, T originalMat, T destinationMat) {
        class_1856 newIng = ingredient;
        for (class_1799 in : ingredient.method_8105()) {
            class_1792 i;
            class_1792 it = in.method_7909();
            if (it == class_1802.field_8077 || (i = BlockType.changeItemType((class_1792)it, originalMat, destinationMat)) == null) continue;
            newIng = class_1856.method_8091((class_1935[])new class_1935[]{i});
            break;
        }
        return newIng;
    }

    static {
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", (JsonElement)t);
    }
}

