package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public class TagUtility {

    /**
     * Get the namespace:WoodType_logs tag from the wood mods or create a new tag if not available
     *
     * @return ResourceLocation
     **/
    public static ResourceLocation getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink handler, ResourceManager manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();

        // ResourceLocation
        ResourceLocation RLocLogs = new ResourceLocation(resLocMOD + "_" + suffixTag);
        ResourceLocation RLocStems = new ResourceLocation(resLocMOD + "_" + suffixAlt);
        ResourceLocation RLocFolders = new ResourceLocation(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName());
        ResourceLocation RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);

        if (manager.m_213713_(ResType.TAGS.getPath(RLocLogs.m_246208_("blocks/"))).isPresent())
            return RLocLogs;
        else if (manager.m_213713_(ResType.TAGS.getPath(RLocStems.m_246208_("blocks/"))).isPresent())
            return RLocStems;
        else if (manager.m_213713_(ResType.TAGS.getPath(RLocEC.m_246208_("blocks/"))).isPresent())
            return RLocEC;
        else if (manager.m_213713_(ResType.TAGS.getPath(RLocFolders.m_246208_("blocks/"))).isPresent())
            return RLocFolders;
        else // if RLocECTags is not available, then it will be generated
            createAndAddDefaultTags(RLocEC, handler, blockType);

        return RLocEC;

    }

    /**
     * The method is to create a custom Tag file with
     * DEFAULT BLOCKS - log, stripped_log, wood, stripped_wood
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddDefaultTags(ResourceLocation resLoc, ResourceSink sink, BlockType blockType, Block... blocks) {
        if (blockType instanceof WoodType woodType)
            return createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        else
            return createAndAddCustomTags(resLoc, sink, blocks);
    }

    /**
     * Add any blocks to newly created tag
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Block... blocks) {
        boolean isTagCreated = false;

        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(resLoc);
        // Adding blocks to tag file
        for (Block block : blocks) {
            if (block != null) {
                tagBuilder.addEntry(block);
                isTagCreated = true;
            }
        }
        // Adding to the resources
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.f_256747_);
            sink.addTag(tagBuilder, Registries.f_256913_);
        }
        return isTagCreated;
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId, String tag,
            boolean includeBlock, boolean includeItem, ResourceSink pack
    ) {
        addTagToAllBlocks(blocks, nameStone, modId,
                TagKey.m_203882_(Registries.f_256747_, new ResourceLocation(tag)),
                includeBlock, includeItem, pack);
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId, TagKey<Block> tag,
            boolean includeBlock, boolean includeItem, ResourceSink pack
    ) {
        addTagToAllBlocks(blocks, nameStone, modId,
                tag, includeBlock, includeItem, pack, null);
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId,
            TagKey<Block> tag, boolean includeBlock, boolean includeItem, ResourceSink pack,
            @Nullable String regexBlockId
    ) {
        if (PlatHelper.isModLoaded(modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                T stoneType = entry.getKey();
                B block = entry.getValue();

                String blockPath = Utils.getID(block).m_135815_();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);

                if (stoneType.getTypeName().equals(nameStone) &&
                        (regexBlockId == null || blockId.matches(regexBlockId))) {
                    tagBuilder.addEntry(block);
                    isTagCreated = true;
                }
            }
            if (isTagCreated) {
                if (includeBlock) pack.addTag(tagBuilder, Registries.f_256747_);
                if (includeItem) pack.addTag(tagBuilder, Registries.f_256913_);
            }
        }
    }

}
