package net.mehvahdjukaar.every_compat.misc;

import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import org.jetbrains.annotations.Nullable;

// ugly mess. Too coupled with WoodTypes|LeavesTypes and too many hardcoded exceptions
public class HardcodedBlockType {

    public static String woodidentify;
    public static String woodTypeFromMod;
    public static String leavesidentify;
    public static String leavesTypeFromMod;
    public static String modId;
    public static String supportedBlockName;
    public static String shortenedIdenfity;

    @Nullable
    public static Boolean isWoodBlockAlreadyRegistered(String blockName, WoodType woodType, String ModId, String shortenedId) {
        woodTypeFromMod = woodType.getNamespace();
        woodidentify = woodType.getId().toString();
        modId = ModId;
        supportedBlockName = blockName;
        shortenedIdenfity = shortenedId;

            /// ========== INCLUDE VANILLA TYPE ========== \\\
        // Dawn-Of-Time's fancy-fence only has birch but no other vanilla variants
        if (isWoodFrom("dawnoftimebuilder", "", "", "minecraft:(oak|acacia|jungle|dark_oak|spruce|mangrove|cherry)", "fancy_fence")) return false;


        /// ========== EXCLUDE ========== \\\
        // Exclude all of Vanilla Types
        if (woodType.isVanilla()) return true;

        // Nature's-Spirit's joshua texture is a 8x8, it's currently excluded in Valhelaia-Structure for now - the texture generation could be improved
        if (isWoodFrom("valhelsia_structures", "", "natures_spirit:joshua", "", "")) return true;

        // Garden-Of-The-dead's whistle, Snifferent's globar, Nethers-Exoticism's jabuticaba already has branches, Regions-Unexplored's branches is not needed
        if (isWoodFrom("regions_unexplored", "", "gardens_of_the_dead|snifferent|nethers_exoticism", "", "(whistlecane|globar|jabuticaba)_branch")) return true;

        // Quark's stripped_post with Ecologics must be excluded beacuse azalea_post and stripped_azalea_post's texture are identical
        if (isWoodFrom("quark", "", "ecologics", "", "stripped_flowering_azalea_post")) return true;


        /// ========== INCLUDE ========== \\\
        // Makes it so the Guita's Branches block still registers if another mod adds a branch block/item
        if (isWoodFrom("branches", "", "", "", "branch")) return false;

        // Minecraft's CHERRY prevent the generation of blocks with Terraqueous's CHERRY
        if (isWoodFrom("", "", "", "terraqueous:cherry", "")) return false;

        // Refurbished-Furniture's oak_table wasn't generated due to Dawn-Of-Time's waxed_oak_table
        if (isWoodFrom("", "rfm", "", "dawnoftimebuilder:waxed_oak", "")) return false;

        // Minecraft has "mangrove" that caused the generation of blocks with The-Twilight-Forest's mangrove to be skipped.
        if (isWoodFrom("", "", "", "twilightforest:mangrove", "")) return false;

        // Quark's chests & ladders aren't generated with Abnormal's Wood mods | Quark's blocks with Caverns-And-Chasms' AZALEA aren't generated due to Quark's AZALEA
        if (isWoodFrom("quark", "", "upgrade_aquatic|autumnity|atmospheric|environmental|caverns_and_chasms", "", "")) return false;

        // Better Nether & Better End have stripped_bark as stripped_wood but bark from Bewitchment caused EC to skip
        if (isWoodFrom("", "bw", "betternether|betterend", "", "")) return false;

        // Create's windows will be skipped blc [Let's do] Blooming Nature & Meadow already has windows
        if (isWoodFrom("", "", "bloomingnature|meadow", "", "window")) return false;

        // ArchitectPalette's boards will be skipped blc Upgrade-Aqautic already has boards but have no recipes & no item in CreativeMode
        if (isWoodFrom("architects_palette", "", "upgrade_aquatic", "", "driftwood_boards|river_boards")) return false;

        // Similar to above, Architect's Palette - boards will be skipped due to the existing boards in Autumnity
        if (isWoodFrom("architects_palette", "", "autumnity", "", "maple_boards")) return false;

        // Ensure blocks to be generated because TerraFirmaCraft has similar name of vanilla woodType (oak, acacia, so on)
        if (isWoodFrom("", "", "tfc", "", "")) return false;

        //ecologics and quark azalea. tbh not sure why needed
        if (isWoodFrom("quark", "", "", "ecologics:azalea", "")) return false;

        // we always register everything for these (mehvahdjukaar)
        if (isWoodFrom("", "abnww", "architects_palette", "", "")) return false;

        // Ensure the Architects-Palette's boards are generated with Abnormal mods (Upgrade Aquatic, Woodworks)
        if (isWoodFrom("architects_palette", "", "upgrade_aquatic|autumnity|atmospheric|environmental|caverns_and_chasms", "", "")) return false;

        return null;
    }

    @Nullable
    public static Boolean isLeavesBlockAlreadyRegistered(String blockName, LeavesType leavesType, String supportedModId, String shortenedId) {
        leavesTypeFromMod = leavesType.getNamespace();
        leavesidentify = leavesType.getId().toString();
        modId = supportedModId;
        supportedBlockName = blockName;
        shortenedIdenfity = shortenedId;

        /// ========== EXCLUDE ========== \\\
        // Exclude all of Vanilla Types
        if (leavesType.isVanilla()) return true;

        // Traversable-Leaves' leaves is a testing item and should be excluded
        if (isLeavesFrom("", "", "", "traversable_leaves:dev_leaves", "")) return true;

        /// ========== INCLUDE ========== \\\
        // Unrelated to Quark's ancient_leaves & Alex's Cave (ancient_leaves) should be included
        if (isLeavesFrom("quark", "", "", "alexscaves:ancient", "")) return false;

        // Macaw's Fences&Walls or MrCrayFish's Furniture - hedges will be skipped because Quark already has hedges
        if (isLeavesFrom("", "mcf|cfm", "quark", "", "")) return false;

        return null;
    }

    public static Boolean isWoodFrom(String whichSupportedModId, String shortenedId, String woodtypeFromMod, String woodTypeId,
                                           String whichSupportedBlockName) {

        String[] expressions = {
                whichSupportedModId,
                shortenedId,
                woodtypeFromMod,
                woodTypeId,
                whichSupportedBlockName
        };

        String[] values = {
                modId,
                shortenedIdenfity,
                woodTypeFromMod,
                woodidentify,
                supportedBlockName
        };

        for (int idx = 0; idx < values.length; idx++) {

            if (!expressions[idx].isEmpty()) { // Skip the blank expressions
                boolean isNotMatched = !(values[idx].matches(expressions[idx]) | values[idx].contains(expressions[idx]));
                if (isNotMatched) return false;
            }
        }

        return true;
    }

    public static Boolean isLeavesFrom(String whichSupportedModId, String shortenedId, String leavestypeFromMod, String leavesTypeId, String whichSupportedBlockName) {

        String[] expressions = {
                whichSupportedModId,
                shortenedId,
                leavestypeFromMod,
                leavesTypeId,
                whichSupportedBlockName
        };

        String[] values = {
                modId,
                shortenedIdenfity,
                leavesTypeFromMod,
                leavesidentify,
                supportedBlockName
        };

        for (int idx = 0; idx < values.length; idx++) {

            if (!expressions[idx].isEmpty()) { // Skip the blank expressions
                boolean isNotMatched = !(values[idx].matches(expressions[idx]) | values[idx].contains(expressions[idx]));
                if (isNotMatched) return false;
            }
        }

        return true;
    }


}
