package net.mehvahdjukaar.every_compat.modules.forge.absent_by_design;

import com.lothrazar.absentbydesign.block.BlockAbsentFence;
import com.lothrazar.absentbydesign.block.BlockAbsentWall;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.level.block.Block;

//SUPPORT: v1.8.0+
public class AbsentByDesignModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Block> fence_log;
    public final SimpleEntrySet<WoodType, Block> wall_log;
    public final SimpleEntrySet<WoodType, Block> wall_stripped_log;
    public final SimpleEntrySet<WoodType, Block> wall_planks;

    public AbsentByDesignModule(String modId) {
        super(modId, "abd");
        ResourceLocation tab = modRes("tab");

        fence_log = SimpleEntrySet.builder(WoodType.class, "", "fence_log",
                        getModBlock("fence_log_oak"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new BlockAbsentFence(Utils.copyPropertySafe(w.log).m_278183_())
                )
                //TEXTURE: using the oak_log
                .addTag(BlockTags.f_13039_, Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(ItemTags.f_13147_, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(fence_log);

        wall_log = SimpleEntrySet.builder(WoodType.class, "log", "wall",
                        getModBlock("wall_oak_log"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new BlockAbsentWall(Utils.copyPropertySafe(w.log).m_278183_())
                )
                .requiresChildren("wood") //REASON: recipes
                //TEXTURE: using the oak_log
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(ItemTags.f_13140_, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .addRecipe(modRes("wall_oak_log_sc"))
                .build();
        this.addEntry(wall_log);

        wall_stripped_log = SimpleEntrySet.builder(WoodType.class, "log", "wall_stripped",
                        getModBlock("wall_stripped_oak_log"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new BlockAbsentWall(Utils.copyPropertySafe(w.log).m_278183_())
                )
                .requiresChildren("stripped_wood") //REASON: recipes
                //TEXTURE: stripped_log
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(ItemTags.f_13140_, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .addRecipe(modRes("wall_stripped_oak_log_sc"))
                .build();
        this.addEntry(wall_stripped_log);

        wall_planks = SimpleEntrySet.builder(WoodType.class, "planks", "wall",
                        getModBlock("wall_oak_planks"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new BlockAbsentWall(Utils.copyPropertySafe(w.planks).m_278183_())
                )
                //TEXTURE: planks
                .addTag(BlockTags.f_13032_, Registries.f_256747_)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_144282_, Registries.f_256747_)
                .addTag(ItemTags.f_13140_, Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .addRecipe(modRes("wall_oak_planks_sc"))
                .build();
        this.addEntry(wall_planks);

    }
}