package net.mehvahdjukaar.every_compat.modules.forge.blocks_plus;

import blocks_plus.blocks.*;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.*;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

import java.util.Objects;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;

//SUPPORT: v
public class BlocksPlusModule extends SimpleModule {

    /**
     * cracked_acacia_planks
     * mossy_acacia_planks
     * acacia_crafting_table
     * acacia_chest
     * acacia_trapped_chest
     * acacia_bookshelf
     * acacia_wooden_crate
     * acacia_ladder
     * acacia_mosaic
     * cracked_acacia_mosaic
     * mossy_acacia_mosaic
     * acacia_mosaic_stairs
     * acacia_mosaic_slab
     * acacia_mosaic_pressure_plate
     */

    public final SimpleEntrySet<WoodType, Block> cracked_planks;
    public final SimpleEntrySet<WoodType, Block> mossy_planks;
    public final SimpleEntrySet<WoodType, Block> crafting_table;
    public final SimpleEntrySet<WoodType, Block> chest;
    public final SimpleEntrySet<WoodType, Block> trapped_chest;
    public final SimpleEntrySet<WoodType, Block> bookshelf;
    public final SimpleEntrySet<WoodType, Block> wooden_crate;
    public final SimpleEntrySet<WoodType, Block> ladder;
    public final SimpleEntrySet<WoodType, Block> mosaic,
                                                 mosaic_stairs,
                                                 mosaic_slab,
                                                 mosaic_pressure_plate;
    public final SimpleEntrySet<WoodType, Block> cracked_mosaic;
    public final SimpleEntrySet<WoodType, Block> mossy_mosaic;

    public BlocksPlusModule(String modId) {
        super(modId, "bp");
        var tab = modRes("creative_tab");

        cracked_planks = SimpleEntrySet.builder(WoodType.class, "planks", "cracked",
                        getModBlock("cracked_acacia_planks"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/cracked_acacia_planks"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(cracked_planks);

        mossy_planks = SimpleEntrySet.builder(WoodType.class, "planks", "mossy",
                        getModBlock("mossy_acacia_planks"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe(w.planks))
                )
                .addTextureM(modRes("block/mossy_acacia_planks"), EveryCompat.res("block/bp/mossy_acacia_planks_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mossy_planks);

        crafting_table = SimpleEntrySet.builder(WoodType.class, "crafting_table",
                        getModBlock("acacia_crafting_table"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPCraftingTable(Utils.copyPropertySafe(Blocks.f_50091_).m_284180_(w.getColor()))
                )
                .addTextureM(modRes("block/acacia_crafting_table_side"), EveryCompat.res("block/vanilla_crafting_table_side_m"))
                .addTextureM(modRes("block/acacia_crafting_table_front"), EveryCompat.res("block/vanilla_crafting_table_front_m"))
                .addTextureM(modRes("block/acacia_crafting_table_top"), EveryCompat.res("block/vanilla_crafting_table_top_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(crafting_table);

        chest = SimpleEntrySet.builder(WoodType.class, "chest",
                        getModBlock("acacia_chest"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe(Blocks.f_50087_).m_284180_(w.getColor()))
                )
                //TEXTURES: planks
                .addTile(bpChestBlockEntity::new)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("chests"), Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .build();
        this.addEntry(chest);

        trapped_chest = SimpleEntrySet.builder(WoodType.class, "trapped_chest",
                        getModBlock("acacia_trapped_chest"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe(Blocks.f_50325_).m_284180_(w.getColor()))
                )
                //TEXTURES: planks
                .addTile(bpTrappedBlockEntity::new)
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("chests"), Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .build();
        this.addEntry(trapped_chest);

        bookshelf = SimpleEntrySet.builder(WoodType.class, "bookshelf",
                        getModBlock("acacia_bookshelf"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPPlankBookshelf(Utils.copyPropertySafe(Blocks.f_50078_).m_284180_(w.getColor()))
                )
                .addTextureM(modRes("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(modRes("bookshelves"), Registries.f_256747_)
                .addTag(modRes("bookshelves"), Registries.f_256913_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(bookshelf);

        wooden_crate = SimpleEntrySet.builder(WoodType.class, "wooden_crate",
                        getModBlock("acacia_wooden_crate"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPPlanks(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/acacia_wooden_crate"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(wooden_crate);

        ladder = SimpleEntrySet.builder(WoodType.class, "ladder",
                        getModBlock("acacia_ladder"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new LadderBlock(Utils.copyPropertySafe(Blocks.f_50155_).m_284180_(w.getColor()))
                )
                .addTexture(modRes("block/acacia_ladder"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .addTag(BlockTags.f_13082_, Registries.f_256747_)
                .addTag(BlockTags.f_201924_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(ladder);

        mosaic = SimpleEntrySet.builder(WoodType.class, "mosaic",
                        getModBlock("acacia_mosaic"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPPlanks(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/acacia_mosaic"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic);

        mosaic_stairs = SimpleEntrySet.builder(WoodType.class, "mosaic_stairs",
                        getModBlock("acacia_mosaic_stairs"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPPlankStairs(mosaic.blocks.get(w).m_49966_(),
                                Utils.copyPropertySafe(getBlockSafe(w, "stairs")).m_284180_(w.getColor()))
                )
                .requiresChildren("stairs")
                .requiresFromMap(mosaic.blocks) //REASON: textures, recipes
                //TEXTURES: mosaic
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic_stairs);

        mosaic_slab = SimpleEntrySet.builder(WoodType.class, "mosaic_slab",
                        getModBlock("acacia_mosaic_slab"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPPlankSlab(Utils.copyPropertySafe(getBlockSafe(w, "slab")).m_284180_(w.getColor()))
                )
                .requiresChildren("slab")
                .requiresFromMap(mosaic.blocks) //REASON: textures, recipes
                //TEXTURES: mosaic
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic_slab);

        mosaic_pressure_plate = SimpleEntrySet.builder(WoodType.class, "mosaic_pressure_plate",
                        getModBlock("acacia_mosaic_pressure_plate"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new PressurePlateBlock(
                                PressurePlateBlock.Sensitivity.EVERYTHING,
                                Utils.copyPropertySafe(getBlockSafe(w, "pressure_plate")).m_284180_(w.getColor()),
                                BlockSetType.f_271512_
                        )
                )
                .requiresFromMap(mosaic.blocks) //REASON: textures, recipes
                //TEXTURES: mosaic
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mosaic_pressure_plate);

        cracked_mosaic = SimpleEntrySet.builder(WoodType.class, "mosaic", "cracked",
                        getModBlock("cracked_acacia_mosaic"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/cracked_acacia_mosaic"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(cracked_mosaic);

        mossy_mosaic = SimpleEntrySet.builder(WoodType.class, "mosaic", "mossy",
                        getModBlock("mossy_acacia_mosaic"), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe(w.planks))
                )
                .addTextureM(modRes("block/mossy_acacia_mosaic"), EveryCompat.res("block/bp/mossy_acacia_mosaic_m"))
                .addTag(BlockTags.f_144280_, Registries.f_256747_)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(mossy_mosaic);

    }

    public Block getBlockSafe(WoodType type, String childkey) {
        Block block = type.getBlockOfThis(childkey);
        if (Objects.nonNull(block)) return block;
        else {
            switch (childkey) {
                case "pressure_plate" -> block = Blocks.f_50171_;
                case "stairs" -> block = Blocks.f_50372_;
                case "slab" -> block = Blocks.f_50402_;
            }
            return block;
        }
    }

    // GetTile
    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return chest.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return trapped_chest.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity
    private class bpChestBlockEntity extends CompatChestBlockEntity {
        public bpChestBlockEntity(BlockPos pos, BlockState state) {
            super(chest.getTile(), pos, state);
        }
    }

    private class bpTrappedBlockEntity extends CompatChestBlockEntity {
        public bpTrappedBlockEntity(BlockPos pos, BlockState state) {
            super(trapped_chest.getTile(), pos, state);
        }
    }

    @Override
    @OnlyIn(Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, chest.getTile(CompatChestBlockEntity.class), shortenedId());
        CompatChestBlockRenderer.register(event, trapped_chest.getTile(CompatChestBlockEntity.class), shortenedId());
    }

    @Override
    // Textures
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) ->
            trapped_chest.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia/acacia"),
                        EveryCompat.res("entity/bp/chest_normal_m"),
                        EveryCompat.res("model/oak_chest_normal_o"),
                        EveryCompat.res("model/trapped_chest_normal")
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia/left"),
                        EveryCompat.res("entity/bp/chest_left_m"),
                        EveryCompat.res("model/oak_chest_left_o"),
                        EveryCompat.res("model/trapped_chest_left")
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia/right"),
                        EveryCompat.res("entity/bp/chest_right_m"),
                        EveryCompat.res("model/oak_chest_right_o"),
                        EveryCompat.res("model/trapped_chest_right")
                );
            })
        );
    }
}